/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeSmell;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCallInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpAccessInstructionImpl;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.annotator.PhpDeleteElementQuickFix;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.type.PhpExpressionAlwaysConstantInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.ElseIf;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.If;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.ParenthesizedExpression;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.TernaryExpression;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.PhpClassImpl;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.refactoring.unwrap.PhpIfUnwrapper;
import com.jetbrains.php.refactoring.unwrap.PhpUnwrapper;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PhpInstanceofIsAlwaysTrueInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpInstanceofIsAlwaysTrueInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpBinaryExpression(BinaryExpression expression) {
                if (expression.getOperationType() != PhpTokenTypes.kwINSTANCEOF) {
                    return;
                }
                Variable aThis = (Variable)ObjectUtils.tryCast((Object)expression.getLeftOperand(), Variable.class);
                if (!PhpLangUtil.isThisReference((PsiElement)aThis)) {
                    return;
                }
                ClassReference classReference = (ClassReference)ObjectUtils.tryCast((Object)expression.getRightOperand(), ClassReference.class);
                if (classReference == null) {
                    return;
                }
                String fqn = classReference.getFQN();
                PhpClass containingClass = PhpClassImpl.getContainingClass((PhpPsiElement)aThis);
                if (containingClass == null) {
                    return;
                }
                Function function = (Function)PhpPsiUtil.getParentByCondition((PsiElement)expression, (Condition<? super PsiElement>)Function.INSTANCEOF);
                if (function != null && function.isClosure() && PhpInstanceofIsAlwaysTrueInspection.canRebind(function)) {
                    return;
                }
                Ref alwaysInHierarchy = new Ref((Object)Boolean.FALSE);
                PhpClassHierarchyUtils.processSupers((PhpClass)containingClass, (boolean)true, (boolean)true, aClass -> {
                    if (PhpLangUtil.equalsClassNames(aClass.getFQN(), fqn)) {
                        alwaysInHierarchy.set((Object)true);
                        return false;
                    }
                    return true;
                });
                if (((Boolean)alwaysInHierarchy.get()).booleanValue()) {
                    holder.registerProblem((PsiElement)expression, PhpBundle.message("instanceof.is.always.true", fqn, aThis.getText()), new LocalQuickFix[]{PhpInstanceofIsAlwaysTrueInspection.getFix(PhpExpressionAlwaysConstantInspection.ConstantValue.TRUE, (PsiElement)expression)});
                }
            }
        };
    }

    private static boolean canRebind(Function closure) {
        PsiElement parent = closure.getParent();
        if (!PhpPsiUtil.isOfType(parent, PhpElementTypes.CLOSURE)) {
            return false;
        }
        FunctionReference parentFunctionCall = (FunctionReference)PhpPsiUtil.getParentByCondition((PsiElement)closure, (Condition<? super PsiElement>)FunctionReference.INSTANCEOF);
        if (parentFunctionCall != null && ArrayUtil.find((Object[])parentFunctionCall.getParameters(), (Object)parent) >= 0) {
            return true;
        }
        AssignmentExpression assignment = (AssignmentExpression)ObjectUtils.tryCast((Object)parent.getParent(), AssignmentExpression.class);
        if (assignment != null && assignment.getValue() == parent) {
            Variable assignedVariable = (Variable)ObjectUtils.tryCast((Object)assignment.getVariable(), Variable.class);
            if (assignedVariable == null) {
                return true;
            }
            return PhpInstanceofIsAlwaysTrueInspection.usedAsFunctionCallArgument(assignedVariable);
        }
        return false;
    }

    private static boolean usedAsFunctionCallArgument(final @NotNull Variable variable) {
        PhpAccessVariableInstruction instruction;
        if (variable == null) {
            PhpInstanceofIsAlwaysTrueInspection.$$$reportNull$$$0(1);
        }
        if ((instruction = PhpControlFlowUtil.getAccessInstruction((PhpPsiElement)variable, PhpAccessVariableInstruction.class)) == null) {
            return false;
        }
        final Ref usedAsArgument = Ref.create((Object)Boolean.FALSE);
        PhpControlFlowUtil.processSuccessors((PhpInstruction)instruction, false, new PhpInstructionProcessor(){

            public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                if (PhpLangUtil.equalsVariableNames(instruction.getVariableName(), variable.getName())) {
                    PhpAccessInstruction.Access access = instruction.getAccess();
                    if (access.isWrite()) {
                        return false;
                    }
                    if (((PhpAccessInstructionImpl)instruction).isReadOrReadRefAccessLocalAware()) {
                        usedAsArgument.set((Object)Boolean.TRUE);
                        return false;
                    }
                }
                return true;
            }

            public boolean processPhpCallInstruction(PhpCallInstruction instruction) {
                Variable classReference;
                MethodReference reference = (MethodReference)ObjectUtils.tryCast((Object)instruction.getFunctionReference(), MethodReference.class);
                if (reference != null && PhpLangUtil.equalsFunctionNames(reference.getName(), "bindTo") && (classReference = (Variable)ObjectUtils.tryCast((Object)reference.getClassReference(), Variable.class)) != null && PhpLangUtil.equalsVariableNames(classReference.getName(), variable.getName())) {
                    usedAsArgument.set((Object)Boolean.TRUE);
                    return false;
                }
                return true;
            }
        });
        return (Boolean)usedAsArgument.get();
    }

    public static LocalQuickFix getFix(PhpExpressionAlwaysConstantInspection.ConstantValue constantValue, @NotNull PsiElement expression) {
        if (expression == null) {
            PhpInstanceofIsAlwaysTrueInspection.$$$reportNull$$$0(2);
        }
        Pair<PhpExpressionAlwaysConstantInspection.ConstantValue, PsiElement> pair = PhpInstanceofIsAlwaysTrueInspection.computeTopmostExpressionWithConstantValue(constantValue, expression, null);
        return PhpInstanceofIsAlwaysTrueInspection.getFixInternal((PhpExpressionAlwaysConstantInspection.ConstantValue)((Object)pair.first), (PsiElement)pair.second);
    }

    @NotNull
    public static LocalQuickFix getFixInternal(PhpExpressionAlwaysConstantInspection.ConstantValue constantValue, @NotNull PsiElement expression) {
        If parentIf;
        IElementType type;
        boolean isTrue;
        if (expression == null) {
            PhpInstanceofIsAlwaysTrueInspection.$$$reportNull$$$0(3);
        }
        PsiElement parent = expression.getParent();
        boolean bl = isTrue = constantValue == PhpExpressionAlwaysConstantInspection.ConstantValue.TRUE;
        if (parent instanceof BinaryExpression && ((type = ((BinaryExpression)parent).getOperationType()) == PhpTokenTypes.opAND && isTrue || type == PhpTokenTypes.opOR && constantValue == PhpExpressionAlwaysConstantInspection.ConstantValue.FALSE)) {
            return new PhpDeleteBinaryOperandQuickFix(expression);
        }
        if (parent instanceof If && ((If)parent).getCondition() == expression && ((If)parent).getElseBranch() == null && ((If)parent).getElseIfBranches().length == 0) {
            return isTrue ? new PhpUnwrapQuickFix((If)parent) : new PhpDeleteElementQuickFix(parent, PhpBundle.message("delete.if", new Object[0]));
        }
        if (parent instanceof TernaryExpression && ((TernaryExpression)parent).getCondition() == expression) {
            return new PhpReplaceTernaryWithTrueBranchQuickFix((TernaryExpression)parent, isTrue);
        }
        if (parent instanceof ElseIf && (parentIf = (If)ObjectUtils.tryCast((Object)parent.getParent(), If.class)) != null && parentIf.getElseBranch() == null && ArrayUtil.getLastElement((Object[])parentIf.getElseIfBranches()) == parent) {
            return isTrue ? new PhpReplaceLastElseIfWithElseQuickFix(parent) : new PhpDeleteElementQuickFix(parent, PhpBundle.message("delete.elseif", new Object[0]));
        }
        return new PhpReplaceWithConstantQuickFix(expression, constantValue);
    }

    static Pair<PhpExpressionAlwaysConstantInspection.ConstantValue, PsiElement> computeTopmostExpressionWithConstantValue(PhpExpressionAlwaysConstantInspection.ConstantValue value, PsiElement expression, PsiElement stopAt) {
        PsiElement parent = expression.getParent();
        if (PhpLangUtil.isTrue(expression)) {
            value = PhpExpressionAlwaysConstantInspection.ConstantValue.TRUE;
        } else if (PhpLangUtil.isFalse(expression)) {
            value = PhpExpressionAlwaysConstantInspection.ConstantValue.FALSE;
        }
        if (stopAt != null && (parent == stopAt || expression == stopAt)) {
            return Pair.create((Object)((Object)value), (Object)expression);
        }
        if (parent instanceof ParenthesizedExpression) {
            return PhpInstanceofIsAlwaysTrueInspection.computeTopmostExpressionWithConstantValue(value, parent, stopAt);
        }
        if (parent instanceof BinaryExpression) {
            PsiElement leftOperand = ((BinaryExpression)parent).getLeftOperand();
            PsiElement otherOperand = leftOperand == expression ? ((BinaryExpression)parent).getRightOperand() : leftOperand;
            PhpExpressionAlwaysConstantInspection.ConstantValue constantValueOfOtherOperand = otherOperand != null ? (PhpExpressionAlwaysConstantInspection.ConstantValue)((Object)PhpInstanceofIsAlwaysTrueInspection.computeTopmostExpressionWithConstantValue((PhpExpressionAlwaysConstantInspection.ConstantValue)PhpExpressionAlwaysConstantInspection.ConstantValue.UNKNOWN, (PsiElement)otherOperand, (PsiElement)parent).first) : PhpExpressionAlwaysConstantInspection.ConstantValue.UNKNOWN;
            IElementType type = ((BinaryExpression)parent).getOperationType();
            if (type == PhpTokenTypes.opAND && (value == PhpExpressionAlwaysConstantInspection.ConstantValue.FALSE || constantValueOfOtherOperand == PhpExpressionAlwaysConstantInspection.ConstantValue.FALSE)) {
                return PhpInstanceofIsAlwaysTrueInspection.computeTopmostExpressionWithConstantValue(PhpExpressionAlwaysConstantInspection.ConstantValue.FALSE, parent, stopAt);
            }
            if (type == PhpTokenTypes.opOR && (value == PhpExpressionAlwaysConstantInspection.ConstantValue.TRUE || constantValueOfOtherOperand == PhpExpressionAlwaysConstantInspection.ConstantValue.TRUE)) {
                return PhpInstanceofIsAlwaysTrueInspection.computeTopmostExpressionWithConstantValue(PhpExpressionAlwaysConstantInspection.ConstantValue.TRUE, parent, stopAt);
            }
            if ((type == PhpTokenTypes.opOR || type == PhpTokenTypes.opAND) && value == constantValueOfOtherOperand) {
                return PhpInstanceofIsAlwaysTrueInspection.computeTopmostExpressionWithConstantValue(value, parent, stopAt);
            }
            if (constantValueOfOtherOperand != PhpExpressionAlwaysConstantInspection.ConstantValue.UNKNOWN) {
                boolean nonEquality;
                boolean equalValues = constantValueOfOtherOperand == value;
                boolean equality = type == PhpTokenTypes.opEQUAL || type == PhpTokenTypes.opIDENTICAL;
                boolean bl = nonEquality = type == PhpTokenTypes.opNOT_EQUAL || type == PhpTokenTypes.opNOT_IDENTICAL;
                if (equality || nonEquality) {
                    return PhpInstanceofIsAlwaysTrueInspection.computeTopmostExpressionWithConstantValue(equality && equalValues || !equalValues && nonEquality ? PhpExpressionAlwaysConstantInspection.ConstantValue.TRUE : PhpExpressionAlwaysConstantInspection.ConstantValue.FALSE, parent, stopAt);
                }
            }
        }
        if (parent instanceof UnaryExpression && PhpPsiUtil.isOfType(((UnaryExpression)parent).getOperation(), PhpTokenTypes.opNOT)) {
            return PhpInstanceofIsAlwaysTrueInspection.computeTopmostExpressionWithConstantValue(value == PhpExpressionAlwaysConstantInspection.ConstantValue.TRUE ? PhpExpressionAlwaysConstantInspection.ConstantValue.FALSE : PhpExpressionAlwaysConstantInspection.ConstantValue.TRUE, parent, stopAt);
        }
        if (parent instanceof TernaryExpression && ((TernaryExpression)parent).getCondition() == expression) {
            PhpExpressionAlwaysConstantInspection.ConstantValue branchConstantValue;
            if (value == PhpExpressionAlwaysConstantInspection.ConstantValue.TRUE) {
                PhpPsiElement trueVariant = ((TernaryExpression)parent).getTrueVariant();
                branchConstantValue = trueVariant != null ? (PhpExpressionAlwaysConstantInspection.ConstantValue)((Object)PhpInstanceofIsAlwaysTrueInspection.computeTopmostExpressionWithConstantValue((PhpExpressionAlwaysConstantInspection.ConstantValue)PhpExpressionAlwaysConstantInspection.ConstantValue.UNKNOWN, (PsiElement)trueVariant, (PsiElement)parent).first) : PhpExpressionAlwaysConstantInspection.ConstantValue.UNKNOWN;
            } else {
                PhpPsiElement falseVariant = ((TernaryExpression)parent).getFalseVariant();
                PhpExpressionAlwaysConstantInspection.ConstantValue constantValue = branchConstantValue = falseVariant != null ? (PhpExpressionAlwaysConstantInspection.ConstantValue)((Object)PhpInstanceofIsAlwaysTrueInspection.computeTopmostExpressionWithConstantValue((PhpExpressionAlwaysConstantInspection.ConstantValue)PhpExpressionAlwaysConstantInspection.ConstantValue.UNKNOWN, (PsiElement)falseVariant, (PsiElement)parent).first) : PhpExpressionAlwaysConstantInspection.ConstantValue.UNKNOWN_BOOLEAN_VALUE;
            }
            if (branchConstantValue != PhpExpressionAlwaysConstantInspection.ConstantValue.UNKNOWN) {
                return PhpInstanceofIsAlwaysTrueInspection.computeTopmostExpressionWithConstantValue(branchConstantValue, parent, stopAt);
            }
        }
        return Pair.create((Object)((Object)value), (Object)expression);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpInstanceofIsAlwaysTrueInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "usedAsFunctionCallArgument";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getFix";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getFixInternal";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class PhpReplaceLastElseIfWithElseQuickFix
    extends LocalQuickFixOnPsiElement {
        protected PhpReplaceLastElseIfWithElseQuickFix(@NotNull PsiElement element) {
            if (element == null) {
                PhpReplaceLastElseIfWithElseQuickFix.$$$reportNull$$$0(0);
            }
            super(element);
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.replace.elseif.with.else", new Object[0]);
            if (string == null) {
                PhpReplaceLastElseIfWithElseQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @IntentionName
        @NotNull
        public String getText() {
            String string = this.getFamilyName();
            if (string == null) {
                PhpReplaceLastElseIfWithElseQuickFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                PhpReplaceLastElseIfWithElseQuickFix.$$$reportNull$$$0(3);
            }
            if (file == null) {
                PhpReplaceLastElseIfWithElseQuickFix.$$$reportNull$$$0(4);
            }
            if (startElement == null) {
                PhpReplaceLastElseIfWithElseQuickFix.$$$reportNull$$$0(5);
            }
            if (endElement == null) {
                PhpReplaceLastElseIfWithElseQuickFix.$$$reportNull$$$0(6);
            }
            If anIf = (If)PhpPsiUtil.getParentByCondition(startElement, false, (Condition<? super PsiElement>)((Condition)If.class::isInstance));
            if (anIf == null) {
                return;
            }
            ElseIf lastElseIf = (ElseIf)ArrayUtil.getLastElement((Object[])anIf.getElseIfBranches());
            if (lastElseIf == null) {
                return;
            }
            PhpPsiElement condition = lastElseIf.getCondition();
            PsiElement openParen = PhpPsiUtil.getPrevSiblingIgnoreWhitespace((PsiElement)condition, true);
            PsiElement closeParen = PhpPsiUtil.getNextSiblingIgnoreWhitespace((PsiElement)condition, true);
            if (openParen == null || closeParen == null) {
                return;
            }
            lastElseIf.deleteChildRange(openParen, closeParen);
            lastElseIf.getFirstChild().replace(PhpPsiElementFactory.createFromText(project, PhpTokenTypes.kwELSE, "if ($a) else {}"));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeSmell/PhpInstanceofIsAlwaysTrueInspection$PhpReplaceLastElseIfWithElseQuickFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpInstanceofIsAlwaysTrueInspection$PhpReplaceLastElseIfWithElseQuickFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PhpReplaceTernaryWithTrueBranchQuickFix
    extends LocalQuickFixOnPsiElement {
        private final boolean myReplaceWithTrueBranch;

        protected PhpReplaceTernaryWithTrueBranchQuickFix(@NotNull TernaryExpression element, boolean trueBranch) {
            if (element == null) {
                PhpReplaceTernaryWithTrueBranchQuickFix.$$$reportNull$$$0(0);
            }
            super((PsiElement)element);
            this.myReplaceWithTrueBranch = trueBranch;
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.replace.ternary.expression.with.true.branch", this.myReplaceWithTrueBranch ? "true" : "false");
            if (string == null) {
                PhpReplaceTernaryWithTrueBranchQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @IntentionName
        @NotNull
        public String getText() {
            String string = this.getFamilyName();
            if (string == null) {
                PhpReplaceTernaryWithTrueBranchQuickFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            PhpPsiElement trueVariant;
            if (project == null) {
                PhpReplaceTernaryWithTrueBranchQuickFix.$$$reportNull$$$0(3);
            }
            if (file == null) {
                PhpReplaceTernaryWithTrueBranchQuickFix.$$$reportNull$$$0(4);
            }
            if (startElement == null) {
                PhpReplaceTernaryWithTrueBranchQuickFix.$$$reportNull$$$0(5);
            }
            if (endElement == null) {
                PhpReplaceTernaryWithTrueBranchQuickFix.$$$reportNull$$$0(6);
            }
            TernaryExpression ternaryExpression = (TernaryExpression)startElement;
            PhpPsiElement phpPsiElement = trueVariant = this.myReplaceWithTrueBranch ? ternaryExpression.getTrueVariant() : ternaryExpression.getFalseVariant();
            if (trueVariant == null) {
                return;
            }
            ternaryExpression.replace((PsiElement)trueVariant);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeSmell/PhpInstanceofIsAlwaysTrueInspection$PhpReplaceTernaryWithTrueBranchQuickFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpInstanceofIsAlwaysTrueInspection$PhpReplaceTernaryWithTrueBranchQuickFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class PhpUnwrapQuickFix
    extends LocalQuickFixOnPsiElement {
        private PhpUnwrapQuickFix(If anIf) {
            super((PsiElement)anIf);
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("unwrap.if", new Object[0]);
            if (string == null) {
                PhpUnwrapQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @IntentionName
        @NotNull
        public String getText() {
            String string = this.getFamilyName();
            if (string == null) {
                PhpUnwrapQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                PhpUnwrapQuickFix.$$$reportNull$$$0(2);
            }
            if (file == null) {
                PhpUnwrapQuickFix.$$$reportNull$$$0(3);
            }
            if (startElement == null) {
                PhpUnwrapQuickFix.$$$reportNull$$$0(4);
            }
            if (endElement == null) {
                PhpUnwrapQuickFix.$$$reportNull$$$0(5);
            }
            new PhpIfUnwrapper().unwrapElement(startElement, new PhpUnwrapper.Context(true));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeSmell/PhpInstanceofIsAlwaysTrueInspection$PhpUnwrapQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpInstanceofIsAlwaysTrueInspection$PhpUnwrapQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class PhpDeleteBinaryOperandQuickFix
    extends LocalQuickFixOnPsiElement {
        private final String myText;

        private PhpDeleteBinaryOperandQuickFix(PsiElement expression) {
            super(expression);
            this.myText = expression.getText();
        }

        @IntentionName
        @NotNull
        public String getText() {
            String string = this.getFamilyName();
            if (string == null) {
                PhpDeleteBinaryOperandQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            BinaryExpression expression;
            PsiElement elementToRemain;
            if (project == null) {
                PhpDeleteBinaryOperandQuickFix.$$$reportNull$$$0(1);
            }
            if (file == null) {
                PhpDeleteBinaryOperandQuickFix.$$$reportNull$$$0(2);
            }
            if (startElement == null) {
                PhpDeleteBinaryOperandQuickFix.$$$reportNull$$$0(3);
            }
            if (endElement == null) {
                PhpDeleteBinaryOperandQuickFix.$$$reportNull$$$0(4);
            }
            PsiElement psiElement = elementToRemain = startElement == (expression = (BinaryExpression)startElement.getParent()).getLeftOperand() ? expression.getRightOperand() : expression.getLeftOperand();
            if (elementToRemain == null) {
                return;
            }
            expression.replace(elementToRemain);
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("quick.fix.delete", this.myText);
            if (string == null) {
                PhpDeleteBinaryOperandQuickFix.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeSmell/PhpInstanceofIsAlwaysTrueInspection$PhpDeleteBinaryOperandQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpInstanceofIsAlwaysTrueInspection$PhpDeleteBinaryOperandQuickFix";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class PhpReplaceWithConstantQuickFix
    extends LocalQuickFixOnPsiElement {
        private final PhpExpressionAlwaysConstantInspection.ConstantValue myValue;

        private PhpReplaceWithConstantQuickFix(PsiElement element, PhpExpressionAlwaysConstantInspection.ConstantValue value) {
            super(element);
            this.myValue = value;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("php.replace.with", this.myValue.getPresentableName());
            if (string == null) {
                PhpReplaceWithConstantQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @IntentionName
        @NotNull
        public String getText() {
            String string = this.getFamilyName();
            if (string == null) {
                PhpReplaceWithConstantQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                PhpReplaceWithConstantQuickFix.$$$reportNull$$$0(2);
            }
            if (file == null) {
                PhpReplaceWithConstantQuickFix.$$$reportNull$$$0(3);
            }
            if (startElement == null) {
                PhpReplaceWithConstantQuickFix.$$$reportNull$$$0(4);
            }
            if (endElement == null) {
                PhpReplaceWithConstantQuickFix.$$$reportNull$$$0(5);
            }
            startElement.replace(this.myValue.createPsi(project));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeSmell/PhpInstanceofIsAlwaysTrueInspection$PhpReplaceWithConstantQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpInstanceofIsAlwaysTrueInspection$PhpReplaceWithConstantQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

