/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeSmell;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCallInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.codeStyle.PhpArrayMapCanBeConvertedToLoopInspection;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpFuncGetArgCanBeReplacedWithParamInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpFuncGetArgCanBeReplacedWithParamInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpFunctionCall(FunctionReference reference) {
                Parameter parameter;
                PsiElement argument = reference.getParameter(0);
                if (!PhpArrayMapCanBeConvertedToLoopInspection.isGlobalFunctionCallWithName(reference, "func_get_arg")) {
                    return;
                }
                int index = PhpPsiUtil.isOfType(argument, PhpElementTypes.NUMBER) ? StringUtil.parseInt((String)argument.getText(), (int)-1) : -1;
                Function function = (Function)PhpPsiUtil.getParentByCondition((PsiElement)reference, (Condition<? super PsiElement>)Function.INSTANCEOF);
                Parameter parameter2 = parameter = function != null ? function.getParameter(index) : null;
                if (parameter == null || parameter.isOptional() || parameter.isVariadic() || PhpFuncGetArgCanBeReplacedWithParamInspection.isParameterOverwritten(reference, parameter.getName())) {
                    return;
                }
                holder.registerProblem((PsiElement)reference, PhpBundle.message("inspection.message.can.be.replaced.with.direct.parameter.access", new Object[0]), new LocalQuickFix[]{new PhpReplaceWithParameterAccessQuickFix(parameter.getName())});
            }
        };
    }

    private static boolean isParameterOverwritten(FunctionReference functionCall, final String parameterName) {
        PhpCallInstruction callInstruction = PhpControlFlowUtil.getCallInstruction(functionCall);
        if (callInstruction == null) {
            return false;
        }
        final Ref isParameterOverwritten = new Ref((Object)false);
        PhpControlFlowUtil.processPredecessors((PhpInstruction)callInstruction, false, new PhpInstructionProcessor(){

            public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                if (PhpLangUtil.equalsVariableNames(parameterName, instruction.getVariableName()) && !instruction.getAccess().isRead()) {
                    isParameterOverwritten.set((Object)true);
                    return false;
                }
                return super.processAccessVariableInstruction(instruction);
            }
        });
        return (Boolean)isParameterOverwritten.get();
    }

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP710;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/codeSmell/PhpFuncGetArgCanBeReplacedWithParamInspection", "buildVisitor"));
    }

    private static class PhpReplaceWithParameterAccessQuickFix
    implements LocalQuickFix {
        @NotNull
        @NlsSafe
        private final String myParameterName;

        private PhpReplaceWithParameterAccessQuickFix(@NotNull @NlsSafe String parameterName) {
            if (parameterName == null) {
                PhpReplaceWithParameterAccessQuickFix.$$$reportNull$$$0(0);
            }
            this.myParameterName = parameterName;
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.replace.with.parameter.access", new Object[0]);
            if (string == null) {
                PhpReplaceWithParameterAccessQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @IntentionName
        @NotNull
        public String getName() {
            String string = PhpBundle.message("php.replace.with", "$" + this.myParameterName);
            if (string == null) {
                PhpReplaceWithParameterAccessQuickFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                PhpReplaceWithParameterAccessQuickFix.$$$reportNull$$$0(3);
            }
            if (descriptor == null) {
                PhpReplaceWithParameterAccessQuickFix.$$$reportNull$$$0(4);
            }
            descriptor.getStartElement().replace((PsiElement)PhpPsiElementFactory.createVariable(project, this.myParameterName, true));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameterName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeSmell/PhpFuncGetArgCanBeReplacedWithParamInspection$PhpReplaceWithParameterAccessQuickFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpFuncGetArgCanBeReplacedWithParamInspection$PhpReplaceWithParameterAccessQuickFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

