/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeSmell;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpBreak;
import com.jetbrains.php.lang.psi.elements.PhpContinue;
import com.jetbrains.php.lang.psi.elements.PhpLoop;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpSwitch;
import com.jetbrains.php.lang.psi.elements.StatementWithArgument;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.navigation.PhpGotoBreakContinueHandler;
import org.jetbrains.annotations.NotNull;

public class PhpContinueTargetingSwitchInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpContinueTargetingSwitchInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpContinue(PhpContinue continueStatement) {
                int argument = PhpGotoBreakContinueHandler.Companion.getArgument((StatementWithArgument)continueStatement);
                if (PhpPsiUtil.getLoopStatement((PhpPsiElement)continueStatement, argument) instanceof PhpSwitch) {
                    holder.registerProblem((PsiElement)continueStatement, PhpBundle.message("inspection.message.continue.targeting.switch.equivalent.to.break", new Object[0]), PhpContinueTargetingSwitchInspection.getFixes(continueStatement, argument));
                }
            }
        };
    }

    private static LocalQuickFix[] getFixes(PhpContinue continueStatement, int argument) {
        if (PhpPsiUtil.getLoopStatement((PhpPsiElement)continueStatement, argument + 1) instanceof PhpLoop) {
            return new LocalQuickFix[]{new PhpReplaceWithBreakQuickFix(argument), new PhpReplaceContinueArgumentQuickFix(argument + 1)};
        }
        return new LocalQuickFix[]{new PhpReplaceWithBreakQuickFix(argument)};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/codeSmell/PhpContinueTargetingSwitchInspection", "buildVisitor"));
    }

    private static class PhpReplaceContinueArgumentQuickFix
    implements LocalQuickFix {
        private final int myArgument;

        private PhpReplaceContinueArgumentQuickFix(int argument) {
            this.myArgument = argument;
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.replace.with", "continue " + this.myArgument + ";");
            if (string == null) {
                PhpReplaceContinueArgumentQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                PhpReplaceContinueArgumentQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                PhpReplaceContinueArgumentQuickFix.$$$reportNull$$$0(2);
            }
            PsiElement argument = ((PhpContinue)descriptor.getStartElement()).getArgument();
            PhpContinue phpContinue = PhpPsiElementFactory.createPhpPsiFromText(project, PhpContinue.class, "while (true) continue " + this.myArgument + ";");
            if (argument != null) {
                argument.replace(phpContinue.getArgument());
            } else {
                descriptor.getStartElement().replace((PsiElement)phpContinue);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeSmell/PhpContinueTargetingSwitchInspection$PhpReplaceContinueArgumentQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpContinueTargetingSwitchInspection$PhpReplaceContinueArgumentQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PhpReplaceWithBreakQuickFix
    implements LocalQuickFix {
        private final int myArgument;

        private PhpReplaceWithBreakQuickFix(int argument) {
            this.myArgument = argument;
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.replace.with", "break" + (String)(this.myArgument == 1 ? "" : " " + this.myArgument) + ";");
            if (string == null) {
                PhpReplaceWithBreakQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement argument;
            if (project == null) {
                PhpReplaceWithBreakQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                PhpReplaceWithBreakQuickFix.$$$reportNull$$$0(2);
            }
            String argumentText = (argument = ((PhpContinue)descriptor.getStartElement()).getArgument()) != null ? argument.getText() : "";
            PhpBreak phpBreak = PhpPsiElementFactory.createPhpPsiFromText(project, PhpBreak.class, "while(true) break " + argumentText + ";");
            descriptor.getStartElement().replace((PsiElement)phpBreak);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeSmell/PhpContinueTargetingSwitchInspection$PhpReplaceWithBreakQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpContinueTargetingSwitchInspection$PhpReplaceWithBreakQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

