/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeSmell;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.codeSmell.PhpLoopCanBeReplacedWithStrRepeatInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.SelfAssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;

public class PhpConcatenationWithEmptyStringCanBeInlinedInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpConcatenationWithEmptyStringCanBeInlinedInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpSelfAssignmentExpression(SelfAssignmentExpression expression) {
                AssignmentExpression prevAssignment;
                if (expression.getOperationType() != PhpTokenTypes.opCONCAT_ASGN) {
                    return;
                }
                PsiElement parent = expression.getParent();
                if (!(parent instanceof Statement) || PhpLoopCanBeReplacedWithStrRepeatInspection.getOnlyItem(parent.getChildren(), SelfAssignmentExpression.class) != expression) {
                    return;
                }
                Statement prevStatement = (Statement)ObjectUtils.tryCast((Object)PhpPsiUtil.getPrevSiblingIgnoreWhitespace(parent, true), Statement.class);
                AssignmentExpression assignmentExpression = prevAssignment = prevStatement != null ? PhpLoopCanBeReplacedWithStrRepeatInspection.getOnlyItem(prevStatement.getChildren(), AssignmentExpression.class) : null;
                if (prevAssignment == null || prevAssignment instanceof SelfAssignmentExpression || !PhpConcatenationWithEmptyStringCanBeInlinedInspection.isEmptyStringLiteral(prevAssignment.getValue())) {
                    return;
                }
                if (PhpConcatenationWithEmptyStringCanBeInlinedInspection.variablesAreTheSame(expression, prevAssignment)) {
                    return;
                }
                if (!new PhpType().add((PsiElement)expression.getValue()).global(holder.getProject()).equals((Object)PhpType.STRING)) {
                    return;
                }
                PsiElement operation = expression.getOperation();
                if (operation == null) {
                    return;
                }
                holder.registerProblem(operation, PhpBundle.message("inspection.message.concatenation.can.be.merged.with.assignment.empty.string.literal", new Object[0]), new LocalQuickFix[]{PhpMergeWithAssignmentQuickFix.INSTANCE});
            }
        };
    }

    private static boolean variablesAreTheSame(SelfAssignmentExpression expression, AssignmentExpression assignment) {
        PhpPsiElement variable = expression.getVariable();
        if (variable == null) {
            return true;
        }
        PhpPsiElement assignedVariable = assignment.getVariable();
        return assignedVariable == null || !PsiEquivalenceUtil.areElementsEquivalent((PsiElement)assignedVariable, (PsiElement)variable, (o1, o2) -> 0, null, null, (boolean)false);
    }

    private static boolean isEmptyStringLiteral(PhpPsiElement element) {
        return element instanceof StringLiteralExpression && ((StringLiteralExpression)element).getValueRange().isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/codeSmell/PhpConcatenationWithEmptyStringCanBeInlinedInspection", "buildVisitor"));
    }

    private static class PhpMergeWithAssignmentQuickFix
    implements LocalQuickFix {
        static final LocalQuickFix INSTANCE = new PhpMergeWithAssignmentQuickFix();

        private PhpMergeWithAssignmentQuickFix() {
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.merge.with.assignment", new Object[0]);
            if (string == null) {
                PhpMergeWithAssignmentQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            SelfAssignmentExpression element;
            PsiElement prevStatement;
            if (project == null) {
                PhpMergeWithAssignmentQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                PhpMergeWithAssignmentQuickFix.$$$reportNull$$$0(2);
            }
            if ((prevStatement = PhpPsiUtil.getPrevSiblingIgnoreWhitespace((element = (SelfAssignmentExpression)descriptor.getStartElement().getParent()).getParent(), true)) == null) {
                return;
            }
            prevStatement.delete();
            String assignmentText = element.getVariable().getText() + " = " + element.getValue().getText();
            element.replace((PsiElement)PhpPsiElementFactory.createPhpPsiFromText(project, AssignmentExpression.class, assignmentText));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeSmell/PhpConcatenationWithEmptyStringCanBeInlinedInspection$PhpMergeWithAssignmentQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpConcatenationWithEmptyStringCanBeInlinedInspection$PhpMergeWithAssignmentQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

