/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.classes;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collection;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class PhpParameterNameChangedDuringInheritanceInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpParameterNameChangedDuringInheritanceInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpMethod(Method method) {
                if (method instanceof PhpDocMethod || method.getMethodType(true) == Method.MethodType.CONSTRUCTOR) {
                    return;
                }
                Parameter[] parameters = method.getParameters();
                if (parameters.length == 0 || parameters[0].isVariadic()) {
                    return;
                }
                PhpClass containingClass = method.getContainingClass();
                if (containingClass == null || containingClass.isTrait()) {
                    return;
                }
                Collection<Parameter[]> superParameters = PhpParameterNameChangedDuringInheritanceInspection.getSuperParameters(method, containingClass);
                for (int i = 0; i < parameters.length && !parameters[i].isVariadic(); ++i) {
                    LocalQuickFix[] localQuickFixArray;
                    Collection<String> differentNames;
                    String parameterName = parameters[i].getName();
                    if (StringUtil.isEmpty((String)parameterName) || (differentNames = PhpParameterNameChangedDuringInheritanceInspection.getSuperParametersDifferentNames(superParameters, i, parameterName)).isEmpty()) continue;
                    if (differentNames.size() == 1 && isOnTheFly) {
                        LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                        localQuickFixArray = localQuickFixArray2;
                        localQuickFixArray2[0] = new PhpRenameParameterQuickFix((String)ContainerUtil.getFirstItem(differentNames));
                    } else {
                        localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
                    }
                    LocalQuickFix[] fixes = localQuickFixArray;
                    PsiElement identifier = parameters[i].getNameIdentifier();
                    assert (identifier != null);
                    holder.registerProblem(identifier, PhpBundle.message("inspection.message.parameter.name.changed.from.to", StringUtil.join(differentNames, (String)", "), parameterName), fixes);
                }
            }
        };
    }

    @NotNull
    private static Collection<Parameter[]> getSuperParameters(Method method, PhpClass containingClass) {
        Collection collection = (Collection)StreamEx.of((Collection)PhpClassHierarchyUtils.getImmediateParents((PhpClass)containingClass)).map(c -> c.findMethodByName((CharSequence)method.getName())).nonNull().map(Function::getParameters).collect(Collectors.toList());
        if (collection == null) {
            PhpParameterNameChangedDuringInheritanceInspection.$$$reportNull$$$0(1);
        }
        return collection;
    }

    @NotNull
    private static Collection<String> getSuperParametersDifferentNames(Collection<Parameter[]> superParameters, int parameterPosition, String parameterName) {
        Collection collection = superParameters.stream().filter(p -> parameterPosition < ((Parameter[])p).length).map(p -> p[parameterPosition].getName()).filter(superName -> !PhpLangUtil.equalsParameterNames(superName, parameterName)).collect(Collectors.toSet());
        if (collection == null) {
            PhpParameterNameChangedDuringInheritanceInspection.$$$reportNull$$$0(2);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/classes/PhpParameterNameChangedDuringInheritanceInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/classes/PhpParameterNameChangedDuringInheritanceInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperParameters";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperParametersDifferentNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PhpRenameParameterQuickFix
    implements LocalQuickFix {
        @NlsSafe
        private final String myParameterName;

        private PhpRenameParameterQuickFix(@NlsSafe String parameterName) {
            this.myParameterName = parameterName;
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.rename.parameter.to.match.super", new Object[0]);
            if (string == null) {
                PhpRenameParameterQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @IntentionName
        @NotNull
        public String getName() {
            String string = PhpBundle.message("intention.name.rename.to", this.myParameterName);
            if (string == null) {
                PhpRenameParameterQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            Parameter element;
            if (project == null) {
                PhpRenameParameterQuickFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                PhpRenameParameterQuickFix.$$$reportNull$$$0(3);
            }
            if ((element = (Parameter)PhpPsiUtil.getParentByCondition(descriptor.getStartElement(), false, (Condition<? super PsiElement>)Parameter.INSTANCEOF)) == null) {
                return;
            }
            PsiElementRenameHandler.rename((PsiElement)element, (Project)project, (PsiElement)element, null, (String)this.myParameterName);
        }

        public boolean startInWriteAction() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/classes/PhpParameterNameChangedDuringInheritanceInspection$PhpRenameParameterQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/classes/PhpParameterNameChangedDuringInheritanceInspection$PhpRenameParameterQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

