/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.classes;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.annotator.PhpAnnotatorVisitor;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.ParameterListOwner;
import com.jetbrains.php.lang.psi.elements.impl.ParameterListImpl;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpNamedArgumentsWithChangedOrderInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpNamedArgumentsWithChangedOrderInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpParameterList(ParameterList list) {
                List<PsiElement> arguments = Arrays.asList(list.getParameters());
                int firstIndex = ContainerUtil.indexOf(arguments, x$0 -> PhpNamedArgumentsWithChangedOrderInspection.isNamedArgument(x$0));
                if (firstIndex == ContainerUtil.lastIndexOf(arguments, x$0 -> PhpNamedArgumentsWithChangedOrderInspection.isNamedArgument(x$0))) {
                    return;
                }
                List<Parameter> parameters = PhpNamedArgumentsWithChangedOrderInspection.resolveParameters(list);
                if (parameters.isEmpty()) {
                    return;
                }
                if (PhpNamedArgumentsWithChangedOrderInspection.argumentsAlreadySorted(arguments, firstIndex, parameters)) {
                    PsiElement identifier = ParameterListImpl.getNameIdentifier(arguments.get(firstIndex));
                    if (identifier == null) {
                        return;
                    }
                    holder.registerProblem((PsiElement)list, TextRange.create((int)identifier.getTextRangeInParent().getStartOffset(), (int)((PsiElement)ContainerUtil.getLastItem(arguments)).getTextRangeInParent().getEndOffset()), PhpBundle.message("inspection.php.named.arguments.with.changed.order", new Object[0]), new LocalQuickFix[]{PhpSortArgumentsQuickFix.INSTANCE});
                }
            }
        };
    }

    @NotNull
    private static List<Parameter> resolveParameters(ParameterList list) {
        ParameterListOwner owner = (ParameterListOwner)ObjectUtils.tryCast((Object)list.getParent(), ParameterListOwner.class);
        Function function = owner != null ? (Function)ContainerUtil.getFirstItem(PhpAnnotatorVisitor.resolveFunctions(owner)) : null;
        List<Parameter> list2 = function != null ? Arrays.asList(function.getParameters()) : Collections.emptyList();
        if (list2 == null) {
            PhpNamedArgumentsWithChangedOrderInspection.$$$reportNull$$$0(1);
        }
        return list2;
    }

    private static boolean isNamedArgument(PsiElement a) {
        return ParameterListImpl.getNameIdentifier(a) != null;
    }

    private static boolean argumentsAlreadySorted(List<PsiElement> arguments, int index, List<Parameter> parameters) {
        int lastIndex = -1;
        for (int i = index; i < arguments.size(); ++i) {
            PsiElement nameIdentifier = ParameterListImpl.getNameIdentifier(arguments.get(i));
            if (nameIdentifier == null) {
                return false;
            }
            int parameterIndex = PhpWorkaroundUtil.resolveMappedParameterIndex(nameIdentifier.getText(), parameters);
            if (parameterIndex < 0) {
                return false;
            }
            if (parameterIndex < lastIndex) {
                return true;
            }
            lastIndex = parameterIndex;
        }
        return false;
    }

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP800;
    }

    public static void sortNamedArguments(@NotNull Project project, ParameterList list) {
        List<PsiElement> arguments;
        int index;
        if (project == null) {
            PhpNamedArgumentsWithChangedOrderInspection.$$$reportNull$$$0(2);
        }
        if ((index = ContainerUtil.indexOf(arguments = Arrays.asList(list.getParameters()), PhpNamedArgumentsWithChangedOrderInspection::isNamedArgument)) < 0) {
            return;
        }
        List sortedArguments = IntStream.range(index, arguments.size()).mapToObj(arguments::get).sorted(Comparator.comparingInt(PhpWorkaroundUtil::resolveMappedParameterIndex)).map(a -> Pair.create((Object)Objects.requireNonNull(ParameterListImpl.getNameIdentifier(a)).getText(), (Object)a.copy())).collect(Collectors.toList());
        for (int i = index; i < arguments.size(); ++i) {
            Pair sortedPair = (Pair)sortedArguments.get(i - index);
            PsiElement identifier = ParameterListImpl.getNameIdentifier(arguments.get(i));
            assert (identifier != null);
            identifier.replace(PhpPsiElementFactory.createNamedArgumentNameIdentifier(project, (String)sortedPair.getFirst()));
            arguments.get(i).replace((PsiElement)sortedPair.getSecond());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/classes/PhpNamedArgumentsWithChangedOrderInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/classes/PhpNamedArgumentsWithChangedOrderInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "sortNamedArguments";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PhpSortArgumentsQuickFix
    implements LocalQuickFix {
        private static final LocalQuickFix INSTANCE = new PhpSortArgumentsQuickFix();

        private PhpSortArgumentsQuickFix() {
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.sort.arguments", new Object[0]);
            if (string == null) {
                PhpSortArgumentsQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            ParameterList list;
            if (project == null) {
                PhpSortArgumentsQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                PhpSortArgumentsQuickFix.$$$reportNull$$$0(2);
            }
            if ((list = (ParameterList)PhpPsiUtil.getParentByCondition(descriptor.getStartElement(), false, (Condition<? super PsiElement>)ParameterList.INSTANCEOF)) == null) {
                return;
            }
            PhpNamedArgumentsWithChangedOrderInspection.sortNamedArguments(project, list);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/classes/PhpNamedArgumentsWithChangedOrderInspection$PhpSortArgumentsQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/classes/PhpNamedArgumentsWithChangedOrderInspection$PhpSortArgumentsQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

