/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.classes;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.annotator.PhpAnnotatorVisitor;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.classes.PhpArgumentWithoutNamedIdentifierInspection;
import com.jetbrains.php.lang.inspections.type.PhpParamsInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.impl.ParameterListImpl;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpNamedArgumentUsageInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpNamedArgumentUsageInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpParameterList(ParameterList list) {
                List<PsiElement> arguments = Arrays.asList(list.getParameters());
                int indexOfLastPositionalArgument = PhpArgumentWithoutNamedIdentifierInspection.getIndexOfLastPositionalArgument(arguments);
                if (indexOfLastPositionalArgument == arguments.size() - 1) {
                    return;
                }
                List<Parameter> parameters = PhpArgumentWithoutNamedIdentifierInspection.resolveParameters(list);
                if (parameters == null) {
                    return;
                }
                for (int i = indexOfLastPositionalArgument + 1; i < arguments.size(); ++i) {
                    Parameter param = PhpParamsInspection.getMappedParam(arguments, parameters, i);
                    if (param == null) {
                        return;
                    }
                    if (param.isVariadic()) {
                        this.checkRemainVariadics(arguments, indexOfLastPositionalArgument, parameters, i, param);
                        return;
                    }
                    if (parameters.indexOf(param) != i) {
                        return;
                    }
                    this.registerProblem(arguments, indexOfLastPositionalArgument, i);
                }
            }

            private void checkRemainVariadics(List<PsiElement> arguments, int indexOfLastPositionalArgument, List<Parameter> parameters, int firstVariadicIndex, Parameter param) {
                if (IntStream.range(firstVariadicIndex + 1, arguments.size()).allMatch(i -> PhpParamsInspection.getMappedParam(arguments, parameters, i) == param)) {
                    for (int i2 = firstVariadicIndex; i2 < arguments.size(); ++i2) {
                        this.registerProblem(arguments, indexOfLastPositionalArgument, i2);
                    }
                }
            }

            private void registerProblem(List<PsiElement> arguments, int indexOfLastPositionalArgument, int argumentIndex) {
                if (!isOnTheFly && argumentIndex != arguments.size() - 1) {
                    return;
                }
                boolean firstNamedArgument = indexOfLastPositionalArgument + 1 == argumentIndex;
                PsiElement nameIdentifier = ParameterListImpl.getNameIdentifier(arguments.get(argumentIndex));
                if (nameIdentifier == null) {
                    return;
                }
                PsiElement parent = nameIdentifier.getParent();
                holder.registerProblem(parent, PhpAnnotatorVisitor.getRangeWithColon(nameIdentifier).shiftLeft(parent.getTextRange().getStartOffset()), PhpBundle.message("inspection.message.named.argument.usage", new Object[0]), new LocalQuickFix[]{new PhpRemoveArgumentNamesQuickFix(firstNamedArgument)});
            }
        };
    }

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP800;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/classes/PhpNamedArgumentUsageInspection", "buildVisitor"));
    }

    private static class PhpRemoveArgumentNamesQuickFix
    implements LocalQuickFix {
        private final boolean myFirstArgument;

        private PhpRemoveArgumentNamesQuickFix(boolean firstArgument) {
            this.myFirstArgument = firstArgument;
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.remove.argument.name", new Object[0]);
            if (string == null) {
                PhpRemoveArgumentNamesQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @IntentionName
        @NotNull
        public String getName() {
            String string = this.myFirstArgument ? this.getFamilyName() : PhpBundle.message("intention.name.remove.argument.names.from.all.arguments.up.to.current", new Object[0]);
            if (string == null) {
                PhpRemoveArgumentNamesQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            ParameterList parent;
            PsiElement identifier;
            if (project == null) {
                PhpRemoveArgumentNamesQuickFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                PhpRemoveArgumentNamesQuickFix.$$$reportNull$$$0(3);
            }
            if (!PhpPsiUtil.isOfType(identifier = (parent = (ParameterList)descriptor.getStartElement()).findElementAt(descriptor.getTextRangeInElement().getStartOffset()), PhpTokenTypes.IDENTIFIER)) {
                return;
            }
            for (PsiElement argument : parent.getParameters()) {
                PsiElement nameIdentifier = ParameterListImpl.getNameIdentifier(argument);
                if (nameIdentifier == null) continue;
                boolean stop = false;
                PsiElement colon = PhpPsiUtil.getNextSiblingIgnoreWhitespace(nameIdentifier, true);
                if (nameIdentifier == identifier) {
                    stop = true;
                }
                parent.deleteChildRange(nameIdentifier, colon);
                if (!stop) continue;
                return;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/classes/PhpNamedArgumentUsageInspection$PhpRemoveArgumentNamesQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/classes/PhpNamedArgumentUsageInspection$PhpRemoveArgumentNamesQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

