/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.classes;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.PhpDynamicAsStaticMethodCallInspection;
import com.jetbrains.php.lang.inspections.quickfix.PhpChangeMethodModifiersQuickFix;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.refactoring.move.member.PhpMoveMemberProcessor;
import java.util.Collection;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PhpMakeMethodNonStaticQuickFix
implements LocalQuickFix {
    static final LocalQuickFix INSTANCE = new PhpMakeMethodNonStaticQuickFix();

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("php.make.method.non.static.quick.fix.family.name", new Object[0]);
        if (string == null) {
            PhpMakeMethodNonStaticQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        Method method;
        if (project == null) {
            PhpMakeMethodNonStaticQuickFix.$$$reportNull$$$0(1);
        }
        if (descriptor == null) {
            PhpMakeMethodNonStaticQuickFix.$$$reportNull$$$0(2);
        }
        if ((method = (Method)PhpPsiUtil.getParentByCondition(descriptor.getStartElement(), false, (Condition<? super PsiElement>)Method.INSTANCEOF)) == null) {
            return;
        }
        Collection references = (Collection)StreamEx.of(PhpMoveMemberProcessor.findReferences((PsiElement)method)).select(MethodReference.class).collect(Collectors.toSet());
        WriteAction.run(() -> {
            if (!CommonRefactoringUtil.checkReadOnlyStatus((PsiElement)method)) {
                return;
            }
            if (references.stream().anyMatch(r -> !CommonRefactoringUtil.checkReadOnlyStatus((PsiElement)r.getElement()))) {
                return;
            }
            for (MethodReference reference : references) {
                if (reference == null) continue;
                PhpDynamicAsStaticMethodCallInspection.MakeCallDynamicQuickFix.doFix(project, (MemberReference)reference);
            }
            PhpChangeMethodModifiersQuickFix.changeMethodModifier(method, method.getModifier().copy(PhpModifier.State.DYNAMIC));
        });
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/classes/PhpMakeMethodNonStaticQuickFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/classes/PhpMakeMethodNonStaticQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

