/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.classes;

import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.quickfix.PhpChangeMethodModifiersQuickFix;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PhpMakeMethodNonFinalQuickFix
extends LocalQuickFixOnPsiElement {
    public PhpMakeMethodNonFinalQuickFix(Method method) {
        super((PsiElement)method);
    }

    @NotNull
    public String getText() {
        Method method = (Method)ObjectUtils.tryCast((Object)this.getStartElement(), Method.class);
        if (method == null) {
            String string = this.getFamilyName();
            if (string == null) {
                PhpMakeMethodNonFinalQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = PhpBundle.message("intention.name.make.non.final", PhpLangUtil.toPresentableFQN(PhpLangUtil.toShortName(method.getFQN())));
        if (string == null) {
            PhpMakeMethodNonFinalQuickFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        Method method;
        if (project == null) {
            PhpMakeMethodNonFinalQuickFix.$$$reportNull$$$0(2);
        }
        if (file == null) {
            PhpMakeMethodNonFinalQuickFix.$$$reportNull$$$0(3);
        }
        if (startElement == null) {
            PhpMakeMethodNonFinalQuickFix.$$$reportNull$$$0(4);
        }
        if (endElement == null) {
            PhpMakeMethodNonFinalQuickFix.$$$reportNull$$$0(5);
        }
        if ((method = (Method)ObjectUtils.tryCast((Object)startElement, Method.class)) == null) {
            return;
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((PsiElement)method)) {
            return;
        }
        WriteAction.run(() -> PhpChangeMethodModifiersQuickFix.changeMethodModifier(method, method.getModifier().copy(PhpModifier.Abstractness.IMPLEMENTED)));
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("php.make.method.non.final.quick.fix.family.name", new Object[0]);
        if (string == null) {
            PhpMakeMethodNonFinalQuickFix.$$$reportNull$$$0(6);
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/classes/PhpMakeMethodNonFinalQuickFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/classes/PhpMakeMethodNonFinalQuickFix";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

