/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.classes;

import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PhpMakeClassAbstractQuickFix
extends LocalQuickFixOnPsiElement {
    public PhpMakeClassAbstractQuickFix(PhpClass clazz) {
        super((PsiElement)clazz);
    }

    @NotNull
    public String getText() {
        PhpClass element = (PhpClass)ObjectUtils.tryCast((Object)this.getStartElement(), PhpClass.class);
        String string = element != null ? PhpBundle.message("intention.name.make.abstract", element.getName()) : this.getFamilyName();
        if (string == null) {
            PhpMakeClassAbstractQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        PhpClass phpClass;
        if (project == null) {
            PhpMakeClassAbstractQuickFix.$$$reportNull$$$0(1);
        }
        if (file == null) {
            PhpMakeClassAbstractQuickFix.$$$reportNull$$$0(2);
        }
        if (startElement == null) {
            PhpMakeClassAbstractQuickFix.$$$reportNull$$$0(3);
        }
        if (endElement == null) {
            PhpMakeClassAbstractQuickFix.$$$reportNull$$$0(4);
        }
        if ((phpClass = (PhpClass)ObjectUtils.tryCast((Object)this.getStartElement(), PhpClass.class)) == null) {
            return;
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((PsiElement)phpClass)) {
            return;
        }
        PsiElement text = PhpPsiElementFactory.createFromText(project, PhpTokenTypes.kwABSTRACT, "<?php abstract class A{}");
        WriteAction.run(() -> phpClass.addBefore(text, PhpPsiUtil.getChildOfType((PsiElement)phpClass, PhpTokenTypes.kwCLASS)));
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("php.make.class.abstract.quick.fix.family.name", new Object[0]);
        if (string == null) {
            PhpMakeClassAbstractQuickFix.$$$reportNull$$$0(5);
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/classes/PhpMakeClassAbstractQuickFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/classes/PhpMakeClassAbstractQuickFix";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

