/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.classes;

import com.google.common.base.Predicates;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ex.ProblemDescriptorImpl;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.PhpPresentationUtil;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocProperty;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.classes.PhpAddMethodStubsQuickFix;
import com.jetbrains.php.lang.inspections.classes.PhpMakeClassAbstractQuickFix;
import com.jetbrains.php.lang.inspections.classes.PhpMakeMethodNonFinalQuickFix;
import com.jetbrains.php.lang.inspections.classes.PhpMakeMethodNonStaticQuickFix;
import com.jetbrains.php.lang.inspections.codeStyle.PhpMethodMayBeStaticInspection;
import com.jetbrains.php.lang.inspections.quickfix.PhpChangeMethodModifiersQuickFix;
import com.jetbrains.php.lang.inspections.quickfix.PhpMakeMethodNonAbstractQuickFix;
import com.jetbrains.php.lang.inspections.quickfix.PhpSwitchLanguageLevelQuickFix;
import com.jetbrains.php.lang.inspections.quickfix.type.PhpChangeFieldTypeToMatchSuperQuickFix;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ExtendsList;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.ImplementsList;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpAttributesList;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassAlias;
import com.jetbrains.php.lang.psi.elements.PhpClassFieldsList;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpReturnType;
import com.jetbrains.php.lang.psi.elements.PhpTypeDeclaration;
import com.jetbrains.php.lang.psi.elements.impl.ParameterImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpTypeDeclarationImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeSignatureKey;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpHierarchyChecksInspection
extends PhpInspection {
    private static final PhpAddMethodStubsQuickFix FIX = new PhpAddMethodStubsQuickFix();
    private static final PhpChangeFieldTypeToMatchSuperQuickFix CHANGE_FIELD_TYPE_FIX = new PhpChangeFieldTypeToMatchSuperQuickFix();
    private static final LocalQuickFix[] FIXES = new LocalQuickFix[]{FIX};

    @NotNull
    public static ProblemDescriptor getMethodSignatureDescriptor(@NotNull Method method, @NotNull PsiElement identifier, @InspectionMessage String descriptionTemplate, boolean isOnTheFly, LocalQuickFix ... fixes) {
        if (method == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(0);
        }
        if (identifier == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(1);
        }
        ProblemDescriptor problemDescriptor = InspectionManager.getInstance((Project)method.getProject()).createProblemDescriptor((PsiElement)method, TextRange.create((int)0, (int)identifier.getTextRangeInParent().getEndOffset()), descriptionTemplate, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly, fixes);
        if (problemDescriptor == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(2);
        }
        return problemDescriptor;
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(3);
        }
        return new PhpElementVisitor(){

            public void visitPhpClass(PhpClass clazz) {
                PhpClass containingClass;
                for (Method method2 : clazz.getOwnMethods()) {
                    String name = method2.getName();
                    containingClass = method2.getContainingClass();
                    PsiElement node = method2.getNameIdentifier();
                    if (containingClass == null || node == null || name.equalsIgnoreCase(containingClass.getName()) || method2 instanceof PhpDocMethod || containingClass.isTrait()) continue;
                    PhpModifier modifier = method2.getModifier();
                    if (method2.isStatic() && ("__clone".equalsIgnoreCase(name) || "__construct".equalsIgnoreCase(name) || "__destruct".equalsIgnoreCase(name))) {
                        String text = "__construct".equalsIgnoreCase(name) ? PhpBundle.message("inspection.message.constructor.cannot.be.static", new Object[0]) : ("__destruct".equalsIgnoreCase(name) ? PhpBundle.message("inspection.message.destructor.cannot.be.static", new Object[0]) : PhpBundle.message("inspection.message.clone.method.cannot.be.static", new Object[0]));
                        PhpModifier newMod = PhpModifier.instance((PhpModifier.Access)modifier.getAccess(), (PhpModifier.Abstractness)modifier.getAbstractness(), (PhpModifier.State)PhpModifier.State.DYNAMIC);
                        holder.registerProblem(PhpHierarchyChecksInspection.getMethodSignatureDescriptor(method2, node, text, isOnTheFly, new PhpChangeMethodModifiersQuickFix(containingClass.isInterface() ? null : newMod)));
                    }
                    PhpClassHierarchyUtils.processSuperMethods((Method)method2, (superMethod, subClass, baseClass) -> {
                        Compatibility compatibility;
                        String descriptionTemplate;
                        String superName;
                        if (superMethod instanceof PhpDocMethod) {
                            return true;
                        }
                        PhpClass superContainingClass = superMethod.getContainingClass();
                        if (superContainingClass == null || superContainingClass.isTrait() && (!PhpLanguageLevel.current(holder.getProject()).isAtLeast(PhpLanguageLevel.PHP800) || !superMethod.isAbstract())) {
                            return true;
                        }
                        String string = superName = isOnTheFly ? PhpHierarchyChecksInspection.buildSuperName(superMethod, superContainingClass) : null;
                        if (superMethod.isStatic() != method2.isStatic()) {
                            ProblemDescriptor problemDescriptor;
                            String methodName;
                            String string2 = methodName = isOnTheFly ? superName : "";
                            if (superMethod.isStatic()) {
                                LocalQuickFix[] localQuickFixArray;
                                String string3 = PhpBundle.message("inspection.message.cannot.make.static.method.non.static", methodName);
                                if (PhpMethodMayBeStaticInspection.methodMayBeStatic(method2)) {
                                    LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                                    localQuickFixArray = localQuickFixArray2;
                                    localQuickFixArray2[0] = PhpMethodMayBeStaticInspection.MAKE_METHOD_STATIC_FIX;
                                } else {
                                    localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
                                }
                                problemDescriptor = PhpHierarchyChecksInspection.getMethodSignatureDescriptor(method2, node, string3, isOnTheFly, localQuickFixArray);
                            } else {
                                problemDescriptor = PhpHierarchyChecksInspection.getMethodSignatureDescriptor(method2, node, PhpBundle.message("inspection.message.cannot.make.non.static.method.static", methodName), isOnTheFly, PhpMakeMethodNonStaticQuickFix.INSTANCE);
                            }
                            ProblemDescriptor descriptor = problemDescriptor;
                            holder.registerProblem(descriptor);
                        }
                        if (!baseClass.isInterface() && !baseClass.isTrait() && !superMethod.isAbstract() && method2.isAbstract()) {
                            descriptionTemplate = isOnTheFly ? PhpBundle.message("inspection.message.cannot.make.non.abstract.method.abstract.1", superName) : PhpBundle.message("inspection.message.cannot.make.non.abstract.method.abstract", new Object[0]);
                            holder.registerProblem(PhpHierarchyChecksInspection.getMethodSignatureDescriptor(method2, node, descriptionTemplate, isOnTheFly, PhpMakeMethodNonAbstractQuickFix.INSTANCE));
                        }
                        if (superMethod.isFinal()) {
                            descriptionTemplate = isOnTheFly ? PhpBundle.message("inspection.message.cannot.override.final.method.1", superName) : PhpBundle.message("inspection.message.cannot.override.final.method", new Object[0]);
                            holder.registerProblem(PhpHierarchyChecksInspection.getMethodSignatureDescriptor(method2, node, descriptionTemplate, isOnTheFly, new LocalQuickFix[]{new PhpMakeMethodNonFinalQuickFix((Method)superMethod)}));
                        }
                        if (!(superContainingClass.isTrait() || superMethod.getAccess().getLevel() <= method2.getAccess().getLevel() || ("__construct".equals(superMethod.getName()) || "__destruct".equals(superMethod.getName())) && (PhpLangUtil.isObject(superContainingClass) || "__construct".equals(superMethod.getName()) && PhpProjectConfigurationFacade.getInstance(superMethod.getProject()).getLanguageLevel().isAtLeast(PhpLanguageLevel.PHP720)))) {
                            descriptionTemplate = isOnTheFly ? PhpBundle.message("inspection.message.cannot.make.method", superMethod.getAccess(), superName, method2.getAccess()) : PhpBundle.message("inspection.message.cannot.make.method.visibility.lower.than.super.s", new Object[0]);
                            holder.registerProblem(PhpHierarchyChecksInspection.getMethodSignatureDescriptor(method2, node, descriptionTemplate, isOnTheFly, PhpHierarchyChecksInspection.getAccessFixes(modifier, superMethod.getAccess())));
                        }
                        if ((PhpLanguageLevel.current(superMethod.getProject()).isAtLeast(PhpLanguageLevel.PHP800) || superMethod.isAbstract()) && (!"__construct".equalsIgnoreCase(name) || PhpHierarchyChecksInspection.shouldCheckConstructor(clazz, subClass, baseClass, superMethod))) {
                            Pair<Compatibility, Parameter> result = PhpHierarchyChecksInspection.checkDeclarationsCompatibility(superMethod, method2);
                            if (!((Compatibility)result.first).isCompatible()) {
                                String descriptionTemplate2 = isOnTheFly ? PhpBundle.message("declaration.must.be.compatible.with.0", superName) : PhpBundle.message("declaration.must.be.compatible.with.super", new Object[0]);
                                ProblemDescriptor descriptor = result.second != null ? InspectionManager.getInstance((Project)((Parameter)result.second).getProject()).createProblemDescriptor((PsiElement)result.second, descriptionTemplate2, isOnTheFly, LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING) : PhpHierarchyChecksInspection.getMethodSignatureDescriptor(method2, node, descriptionTemplate2, isOnTheFly, new LocalQuickFix[0]);
                                ((Compatibility)result.first).registerProblem(holder, descriptor);
                            }
                        }
                        if (!(compatibility = PhpHierarchyChecksInspection.compatibleByReturnType(method2.getProject(), (PhpReturnType)method2.getTypeDeclaration(), superMethod.getDeclaredType())).isCompatible()) {
                            PhpTypeDeclaration returnType = method2.getTypeDeclaration();
                            String descriptionTemplate3 = isOnTheFly ? PhpBundle.message("inspection.message.return.type.declaration.must.be.compatible.with", superName, superMethod.getDeclaredType().global(method2.getProject()).toString()) : PhpBundle.message("return.type.declaration.must.be.compatible.with.super", new Object[0]);
                            ProblemDescriptor descriptor = returnType != null ? InspectionManager.getInstance((Project)returnType.getProject()).createProblemDescriptor((PsiElement)returnType, descriptionTemplate3, isOnTheFly, LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING) : PhpHierarchyChecksInspection.getMethodSignatureDescriptor(method2, node, descriptionTemplate3, isOnTheFly, new LocalQuickFix[0]);
                            compatibility.registerProblem(holder, descriptor);
                        }
                        return true;
                    });
                }
                boolean clazzIsAbstract = clazz.isAbstract();
                if (clazz.isInterface() || clazzIsAbstract && !clazz.hasTraitUses() || clazz.isTrait()) {
                    return;
                }
                List methods = ContainerUtil.filter((Collection)clazz.getMethods(), m -> !m.isAbstract() || PhpHierarchyChecksInspection.isAbstractInAllMultiResolvedClasses(m));
                ArrayList<Method> abstractMethods = new ArrayList<Method>();
                for (Method method3 : methods) {
                    containingClass = method3.getContainingClass();
                    if (clazzIsAbstract && (containingClass == null || !containingClass.isTrait() || !method3.getModifier().isPrivate()) || !method3.isAbstract()) continue;
                    abstractMethods.add(method3);
                }
                if (!abstractMethods.isEmpty()) {
                    StringBuilder methodList = new StringBuilder();
                    if (abstractMethods.size() == 1) {
                        methodList.append("method '").append(((Method)abstractMethods.get(0)).getName()).append("'");
                    } else {
                        methodList.append("methods ");
                        Iterator methodIterator = abstractMethods.iterator();
                        while (methodIterator.hasNext()) {
                            Method abstractMethod = (Method)methodIterator.next();
                            methodList.append("'").append(abstractMethod.getName()).append("'");
                            if (!methodIterator.hasNext()) continue;
                            methodList.append(", ");
                        }
                    }
                    PsiElement startNode = clazz.getFirstChild();
                    while (startNode instanceof PhpAttributesList) {
                        startNode = PhpPsiUtil.getNextSiblingIgnoreWhitespace(startNode, true);
                    }
                    PsiElement endNode = clazz.getImplementedInterfaces().length > 0 ? PsiTreeUtil.getChildOfType((PsiElement)clazz, ImplementsList.class) : (!clazz.getSuperClasses().isEmpty() ? PsiTreeUtil.getChildOfType((PsiElement)clazz, ExtendsList.class) : (clazz.getNameNode() != null ? clazz.getNameNode().getPsi() : startNode));
                    boolean hasMethodsToImplement = ContainerUtil.exists(abstractMethods, method -> PhpHierarchyChecksInspection.shouldAddMethodStub(method, clazz));
                    ProblemDescriptorImpl descriptor = new ProblemDescriptorImpl(startNode, endNode, clazzIsAbstract ? PhpBundle.message("inspection.hierarchyChecks.should.implement", methodList.toString()) : PhpBundle.message("inspection.hierarchyChecks.descr", methodList.toString()), PhpHierarchyChecksInspection.appendMakeClassAbstractQuickFix(isOnTheFly && hasMethodsToImplement ? FIXES : LocalQuickFix.EMPTY_ARRAY, clazz), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false, null, isOnTheFly);
                    holder.registerProblem((ProblemDescriptor)descriptor);
                }
            }

            public void visitPhpField(Field field) {
                Project project = field.getProject();
                if (!PhpLanguageFeature.TYPED_PROPERTIES.isSupported(project)) {
                    return;
                }
                if (field.isConstant() || field instanceof PhpDocProperty) {
                    return;
                }
                Field superField = PhpHierarchyChecksInspection.findDeepestSuperField(field);
                if (superField == null) {
                    return;
                }
                if (!PhpHierarchyChecksInspection.compatibleByInvariance(project, field.getDeclaredType().global(project), superField.getDeclaredType().global(project))) {
                    String message = PhpHierarchyChecksInspection.getMessage(superField);
                    if (message == null) {
                        return;
                    }
                    PsiElement nameIdentifier = field.getNameIdentifier();
                    PhpClassFieldsList fieldsList = field.getParentList();
                    PhpTypeDeclaration typeDeclaration = (PhpTypeDeclaration)PhpPsiUtil.getPrevSiblingByCondition((PsiElement)field, (Condition<? super PsiElement>)((Condition)PhpTypeDeclaration.class::isInstance));
                    if (fieldsList != null && !PhpHierarchyChecksInspection.isGroupedDeclarations(fieldsList) && typeDeclaration != null) {
                        holder.registerProblem((PsiElement)fieldsList, typeDeclaration.getTextRangeInParent(), message, new LocalQuickFix[]{CHANGE_FIELD_TYPE_FIX});
                    } else if (nameIdentifier != null) {
                        holder.registerProblem(nameIdentifier, message, new LocalQuickFix[]{CHANGE_FIELD_TYPE_FIX});
                    }
                }
            }
        };
    }

    private static boolean isAbstractInAllMultiResolvedClasses(Method method) {
        PhpClass aClass = method.getContainingClass();
        if (aClass == null) {
            return true;
        }
        Collection classes = PhpIndex.getInstance((Project)method.getProject()).getAnyByFQN(aClass.getFQN());
        if (classes.size() <= 1) {
            return true;
        }
        return ContainerUtil.all((Collection)classes, c -> {
            Method m = c.findOwnMethodByName((CharSequence)method.getName());
            return m != null && m.isAbstract();
        });
    }

    private static boolean shouldCheckConstructor(PhpClass clazz, PhpClass subClass, PhpClass baseClass, Method constructor) {
        if (constructor.isAbstract()) {
            if (PhpLanguageLevel.current(clazz.getProject()).isAtLeast(PhpLanguageLevel.PHP740)) {
                return true;
            }
            return clazz == subClass || baseClass.isInterface();
        }
        return false;
    }

    private static boolean compatibleByInvariance(@NotNull Project project, @NotNull PhpType type, @NotNull PhpType superType) {
        if (project == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(4);
        }
        if (type == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(5);
        }
        if (superType == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(6);
        }
        return PhpHierarchyChecksInspection.streamOfTypes(type).map(t -> PhpHierarchyChecksInspection.compatibleByCovariance(project, t, superType)).allMatch(Compatibility::isCompatible) && PhpHierarchyChecksInspection.streamOfTypes(superType).map(superT -> PhpHierarchyChecksInspection.compatibleByContravariance(project, type, superT)).allMatch(Compatibility::isCompatible);
    }

    @NotNull
    public static @NotNull StreamEx<@NotNull PhpType> streamOfTypes(@NotNull PhpType type) {
        if (type == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(7);
        }
        if (type.isEmpty()) {
            StreamEx streamEx = StreamEx.of((Object)PhpType.EMPTY);
            if (streamEx == null) {
                PhpHierarchyChecksInspection.$$$reportNull$$$0(8);
            }
            return streamEx;
        }
        StreamEx streamEx = StreamEx.of((Collection)type.getTypes()).map(t -> new PhpType().add(t));
        if (streamEx == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(9);
        }
        return streamEx;
    }

    public static boolean areDeclarationsFullyCompatible(@NotNull Method method, @NotNull Method superMethod) {
        if (method == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(10);
        }
        if (superMethod == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(11);
        }
        return PhpHierarchyChecksInspection.compatibleByReturnType(method.getProject(), (PhpReturnType)method.getTypeDeclaration(), superMethod.getDeclaredType()).isCompatible() && ((Compatibility)PhpHierarchyChecksInspection.checkDeclarationsCompatibility((Method)superMethod, (Method)method).first).isCompatible();
    }

    public static Compatibility compatibleByReturnType(@NotNull Project project, PhpReturnType childReturnType, PhpType superMethodDeclaredType) {
        if (project == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(12);
        }
        PhpType type = PhpHierarchyChecksInspection.getTypeFromReferences(childReturnType);
        return PhpHierarchyChecksInspection.getCompatibility(project, superMethodDeclaredType, type, childReturnType);
    }

    public static Compatibility getCompatibility(@NotNull Project project, PhpType superMethodDeclaredType, PhpType childType, @Nullable PhpReturnType childReturnType) {
        if (project == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(13);
        }
        if (childType.isEmpty()) {
            return superMethodDeclaredType.isEmpty() ? Compatibility.COMPATIBLE : Compatibility.NON_COMPATIBLE;
        }
        Map referenceCompatibilityMap = StreamEx.of((Collection)childType.getTypes()).mapToEntry(r -> new PhpType().add(r), r -> PhpHierarchyChecksInspection.compatibleByReturnType(project, superMethodDeclaredType, new PhpType().add(r), childReturnType)).filterValues((Predicate)Predicates.not(Compatibility::isCompatible)).toMap();
        return Compatibility.createUnionTypeCompatibility(referenceCompatibilityMap, (PhpTypeDeclaration)childReturnType);
    }

    @NotNull
    private static PhpType getTypeFromReferences(PhpReturnType childReturnType) {
        Collection<Object> classReferences = childReturnType != null ? childReturnType.getClassReferences() : Collections.emptyList();
        PhpType type = new PhpType();
        classReferences.forEach(arg_0 -> ((PhpType)type).add(arg_0));
        PhpType phpType = type;
        if (phpType == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(14);
        }
        return phpType;
    }

    private static Compatibility compatibleByReturnType(Project project, PhpType superMethodReturnType, PhpType child, @NotNull PhpReturnType childReturnType) {
        if (childReturnType == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(15);
        }
        boolean nullable = childReturnType.isNullable();
        PhpType superType = superMethodReturnType.global(project);
        if (superType.equals((Object)PhpType.MIXED)) {
            return child.equals((Object)PhpType.VOID) ? Compatibility.NON_COMPATIBLE : Compatibility.COMPATIBLE;
        }
        if (nullable && !superType.isEmpty() && !superType.isNullable()) {
            return Compatibility.NON_COMPATIBLE;
        }
        if (!PhpType.intersectsGlobal((Project)project, (PhpType)PhpType.NULL, (PhpType)child)) {
            superType = superType.filterNull();
        }
        if (superType.isEmpty()) {
            return Compatibility.COMPATIBLE;
        }
        PhpType childType = child.global(project);
        if (PhpHierarchyChecksInspection.hasStaticReference(superMethodReturnType)) {
            PhpType superTypeWithoutStatic = superMethodReturnType.filterOut(arg_0 -> ((PhpTypeSignatureKey)PhpTypeSignatureKey.POLYMORPHIC_CLASS).isSigned(arg_0)).global(project);
            return child.getTypes().stream().anyMatch(arg_0 -> ((PhpTypeSignatureKey)PhpTypeSignatureKey.POLYMORPHIC_CLASS).isSigned(arg_0)) || PhpHierarchyChecksInspection.compatibleByCovariance(project, childType, superTypeWithoutStatic).isCompatible() ? Compatibility.COMPATIBLE : Compatibility.NON_COMPATIBLE;
        }
        PhpClass childClass = (PhpClass)PhpPsiUtil.getParentByCondition((PsiElement)childReturnType, (Condition<? super PsiElement>)PhpClass.INSTANCEOF);
        if (!PhpProjectConfigurationFacade.getInstance(project).getLanguageLevel().isAtLeast(PhpLanguageLevel.PHP740) && childClass != null && childClass.isTrait() && PhpType.intersects((PhpType)childType, (PhpType)superType)) {
            return Compatibility.COMPATIBLE;
        }
        return PhpHierarchyChecksInspection.compatibleByCovariance(project, childType, superType);
    }

    private static boolean hasStaticReference(PhpType superTypeUnresolved) {
        return superTypeUnresolved.getTypes().stream().anyMatch(arg_0 -> ((PhpTypeSignatureKey)PhpTypeSignatureKey.POLYMORPHIC_CLASS).isSigned(arg_0));
    }

    private static LocalQuickFix[] getAccessFixes(PhpModifier currentMethodModifier, PhpModifier.Access superMethodAccess) {
        return (LocalQuickFix[])((StreamEx)StreamEx.of((Object[])PhpModifier.Access.values()).filter(access -> access.getLevel() >= superMethodAccess.getLevel())).map(targetAccess -> new PhpChangeMethodModifiersQuickFix(currentMethodModifier.copy(targetAccess))).toArray((Object[])LocalQuickFix.EMPTY_ARRAY);
    }

    private static LocalQuickFix @NotNull [] appendMakeClassAbstractQuickFix(LocalQuickFix[] fixes, @NotNull PhpClass clazz) {
        if (clazz == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(16);
        }
        if (clazz.isFinal()) {
            if (fixes == null) {
                PhpHierarchyChecksInspection.$$$reportNull$$$0(17);
            }
            return fixes;
        }
        LocalQuickFix[] localQuickFixArray = (LocalQuickFix[])ArrayUtil.append((Object[])fixes, (Object)((Object)new PhpMakeClassAbstractQuickFix(clazz)));
        if (localQuickFixArray == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(18);
        }
        return localQuickFixArray;
    }

    @Nullable
    @InspectionMessage
    private static String getMessage(@NotNull Field superField) {
        PhpClass containingClass;
        if (superField == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(19);
        }
        if ((containingClass = superField.getContainingClass()) == null) {
            return null;
        }
        String fqn = containingClass.getFQN();
        PhpType superType = superField.getDeclaredType().global(superField.getProject());
        if (superType.isEmpty()) {
            return PhpBundle.message("inspection.hierarchyChecks.field.type.redeclaration.must.not.be.defined", fqn);
        }
        return PhpBundle.message("inspection.hierarchyChecks.field.type.redeclaration.match.super.type", superType, fqn);
    }

    public static boolean isGroupedDeclarations(@Nullable PhpClassFieldsList fieldsList) {
        return fieldsList != null && fieldsList.getFields().size() > 1;
    }

    @Nullable
    public static Field findDeepestSuperField(@NotNull Field field) {
        if (field == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(20);
        }
        Ref superField = new Ref();
        PhpClassHierarchyUtils.processSuperFields((Field)field, (superMember, superClass, baseClass) -> {
            if (!(superMember instanceof PhpDocProperty)) {
                superField.set((Object)superMember);
                return true;
            }
            return false;
        });
        return (Field)superField.get();
    }

    @NotNull
    public static String buildSuperName(@NotNull Method superMethod, @NotNull PhpClass superContainingClass) {
        if (superMethod == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(21);
        }
        if (superContainingClass == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(22);
        }
        String string = PhpPresentationUtil.formatParameters(new StringBuilder().append(superContainingClass.getName()).append(superMethod.isStatic() ? "::" : "->").append(superMethod.getName()), superMethod.getParameters()).toString();
        if (string == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(23);
        }
        return string;
    }

    @NotNull
    public static @NotNull Pair<@NotNull Compatibility, @Nullable Parameter> checkDeclarationsCompatibility(Method superMethod, Method method) {
        Parameter lastParameter;
        boolean superVariadic;
        if (superMethod.isReturningByReference() && !method.isReturningByReference()) {
            Pair pair = Pair.create((Object)Compatibility.NON_COMPATIBLE, null);
            if (pair == null) {
                PhpHierarchyChecksInspection.$$$reportNull$$$0(24);
            }
            return pair;
        }
        Parameter[] parameters = method.getParameters();
        Parameter[] superParameters = superMethod.getParameters();
        PhpLanguageLevel level = PhpProjectConfigurationFacade.getInstance(method.getProject()).getLanguageLevel();
        int paramsLen = parameters.length;
        int superParamsLen = superParameters.length;
        if (paramsLen == 0 && superParamsLen != 0 || paramsLen < superParamsLen && !level.isAtLeast(PhpLanguageLevel.PHP800)) {
            Pair pair = Pair.create((Object)Compatibility.NON_COMPATIBLE, null);
            if (pair == null) {
                PhpHierarchyChecksInspection.$$$reportNull$$$0(25);
            }
            return pair;
        }
        int minParamsLen = Math.min(superParamsLen, paramsLen);
        for (int i = 0; i < minParamsLen; ++i) {
            Parameter superParameter = superParameters[i];
            Parameter parameter = parameters[i];
            if (parameter.getName().isEmpty() || superParameter.getName().isEmpty()) {
                Pair pair = Pair.create((Object)Compatibility.NON_COMPATIBLE, null);
                if (pair == null) {
                    PhpHierarchyChecksInspection.$$$reportNull$$$0(26);
                }
                return pair;
            }
            if (parameter.isPassByRef() != superParameter.isPassByRef()) {
                Pair pair = Pair.create((Object)Compatibility.NON_COMPATIBLE, (Object)parameter);
                if (pair == null) {
                    PhpHierarchyChecksInspection.$$$reportNull$$$0(27);
                }
                return pair;
            }
            if (superParameter.isOptional() && !parameter.isOptional()) {
                Pair pair = Pair.create((Object)Compatibility.NON_COMPATIBLE, (Object)parameter);
                if (pair == null) {
                    PhpHierarchyChecksInspection.$$$reportNull$$$0(28);
                }
                return pair;
            }
            Compatibility compatibilityByType = PhpHierarchyChecksInspection.compatibleByType(parameter, superParameter);
            if (compatibilityByType.isCompatible()) continue;
            Pair pair = Pair.create((Object)compatibilityByType, (Object)parameter);
            if (pair == null) {
                PhpHierarchyChecksInspection.$$$reportNull$$$0(29);
            }
            return pair;
        }
        boolean bl = superVariadic = superParamsLen > 0 && superParameters[superParamsLen - 1].isVariadic();
        if (superVariadic && !(lastParameter = parameters[paramsLen - 1]).isVariadic()) {
            Pair pair = Pair.create((Object)Compatibility.NON_COMPATIBLE, (Object)(!lastParameter.getName().isEmpty() ? lastParameter : null));
            if (pair == null) {
                PhpHierarchyChecksInspection.$$$reportNull$$$0(30);
            }
            return pair;
        }
        int maxParamsLen = Math.max(superParamsLen, paramsLen);
        for (int i = minParamsLen; i < maxParamsLen; ++i) {
            Compatibility compatibleByType;
            if (i < paramsLen) {
                Parameter parameter = parameters[i];
                if (parameter.getName().isEmpty()) {
                    Pair pair = Pair.create((Object)Compatibility.NON_COMPATIBLE, null);
                    if (pair == null) {
                        PhpHierarchyChecksInspection.$$$reportNull$$$0(31);
                    }
                    return pair;
                }
                if (superVariadic && !(compatibleByType = PhpHierarchyChecksInspection.compatibleByType(parameter, superParameters[superParamsLen - 1])).isCompatible()) {
                    Pair pair = Pair.create((Object)compatibleByType, (Object)parameter);
                    if (pair == null) {
                        PhpHierarchyChecksInspection.$$$reportNull$$$0(32);
                    }
                    return pair;
                }
                if (parameter.isOptional() || parameter.isVariadic()) continue;
                Pair pair = Pair.create((Object)Compatibility.NON_COMPATIBLE, (Object)parameter);
                if (pair == null) {
                    PhpHierarchyChecksInspection.$$$reportNull$$$0(33);
                }
                return pair;
            }
            Parameter lastParameter2 = parameters[paramsLen - 1];
            if (!lastParameter2.isVariadic()) {
                Pair pair = Pair.create((Object)Compatibility.NON_COMPATIBLE, null);
                if (pair == null) {
                    PhpHierarchyChecksInspection.$$$reportNull$$$0(34);
                }
                return pair;
            }
            compatibleByType = PhpHierarchyChecksInspection.compatibleByType(lastParameter2, superParameters[i]);
            if (compatibleByType.isCompatible()) continue;
            Pair pair = Pair.create((Object)compatibleByType, (Object)lastParameter2);
            if (pair == null) {
                PhpHierarchyChecksInspection.$$$reportNull$$$0(35);
            }
            return pair;
        }
        Pair pair = Pair.create((Object)Compatibility.COMPATIBLE, null);
        if (pair == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(36);
        }
        return pair;
    }

    private static Compatibility compatibleByType(@NotNull Parameter parameter, @NotNull Parameter superParameter) {
        if (parameter == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(37);
        }
        if (superParameter == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(38);
        }
        PhpType superType = PhpHierarchyChecksInspection.getParameterType(superParameter);
        PhpType type = PhpHierarchyChecksInspection.getParameterType(parameter);
        if (PhpType.intersects((PhpType)PhpType.MIXED, (PhpType)type)) {
            return Compatibility.COMPATIBLE;
        }
        PhpType typeDefaultNullAware = !PhpType.intersects((PhpType)PhpType.NULL, (PhpType)superType) || parameter.getDeclaredType().isEmpty() && !superParameter.getDeclaredType().isEmpty() && superType.isNullable() && PhpType.NULL.equals((Object)((ParameterImpl)parameter).getDefaultValueType()) ? type.filterNull() : type;
        boolean variadic = parameter.isVariadic();
        boolean superVariadic = superParameter.isVariadic();
        PhpLanguageLevel level = PhpLanguageLevel.current(parameter.getProject());
        if (variadic == superVariadic || parameter.getDefaultValue() != null || variadic && level.isAtLeast(PhpLanguageLevel.PHP800)) {
            if (typeDefaultNullAware.isEmpty() != superType.isEmpty()) {
                if (typeDefaultNullAware.isEmpty() && !superType.isEmpty()) {
                    return level.isAtLeast(PhpLanguageLevel.PHP720) ? Compatibility.COMPATIBLE : LanguageBasedCompatibility.COMPATIBLE_IN_72;
                }
                return Compatibility.NON_COMPATIBLE;
            }
            Map nonCompatible = PhpHierarchyChecksInspection.streamOfTypes(superType).mapToEntry(superT -> PhpHierarchyChecksInspection.parameterTypeSuperCompatible(typeDefaultNullAware, superT, parameter.getProject())).filterValues((Predicate)Predicates.not(Compatibility::isCompatible)).toMap();
            return PhpHierarchyChecksInspection.createAddNonCompatibleTypes(parameter.getProject(), nonCompatible);
        }
        return Compatibility.NON_COMPATIBLE;
    }

    @NotNull
    private static Compatibility createAddNonCompatibleTypes(Project project, final Map<PhpType, Compatibility> nonCompatible) {
        if (nonCompatible.isEmpty()) {
            Compatibility compatibility = Compatibility.COMPATIBLE;
            if (compatibility == null) {
                PhpHierarchyChecksInspection.$$$reportNull$$$0(39);
            }
            return compatibility;
        }
        if (!PhpLanguageFeature.UNION_TYPES.isSupported(project)) {
            Compatibility compatibility = (Compatibility)ContainerUtil.getFirstItem(nonCompatible.values());
            if (compatibility == null) {
                PhpHierarchyChecksInspection.$$$reportNull$$$0(40);
            }
            return compatibility;
        }
        return new Compatibility(false){

            @Override
            public void registerProblem(ProblemsHolder holder, ProblemDescriptor descriptor) {
                LocalQuickFix[] fixes = (LocalQuickFix[])ArrayUtil.append((Object[])((LocalQuickFix[])descriptor.getFixes()), (Object)new PhpAppendNonCompatibleClassReferencesToParameterQuickFix(nonCompatible.keySet()));
                super.registerProblem(holder, InspectionManager.getInstance((Project)holder.getProject()).createProblemDescriptor(descriptor.getStartElement(), descriptor.getDescriptionTemplate(), holder.isOnTheFly(), fixes, descriptor.getHighlightType()));
            }
        };
    }

    @NotNull
    private static PhpType getParameterType(@NotNull Parameter parameter) {
        if (parameter == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(41);
        }
        PhpType type = parameter.getDeclaredType();
        if (PhpLanguageFeature.NULLABLES.isSupported(parameter.getProject()) && PhpType.NULL.equals((Object)((ParameterImpl)parameter).getDefaultValueType())) {
            type = new PhpType().add(type).add(PhpType.NULL);
        }
        if (parameter.isVariadic()) {
            type = PhpType.ARRAY.equals((Object)type) ? PhpType.EMPTY : type.unpluralize();
        }
        PhpType phpType = type;
        if (phpType == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(42);
        }
        return phpType;
    }

    private static boolean typeSuperCompatible(PhpType type, PhpType superType, Project project) {
        return type.equals((Object)superType) || PhpHierarchyChecksInspection.unwrapAlias(type, project).equals((Object)PhpHierarchyChecksInspection.unwrapAlias(superType, project));
    }

    private static Compatibility parameterTypeSuperCompatible(PhpType type, PhpType superType, Project project) {
        if (PhpHierarchyChecksInspection.typeSuperCompatible(type, superType, project)) {
            return Compatibility.COMPATIBLE;
        }
        return PhpHierarchyChecksInspection.compatibleByContravariance(project, type, superType);
    }

    private static Compatibility compatibleByContravariance(Project project, PhpType type, PhpType superType) {
        return PhpHierarchyChecksInspection.compatibleByCovariance(project, superType, type);
    }

    public static boolean shouldAddMethodStub(@NotNull Method abstractMethod, @NotNull PhpClass klass) {
        if (abstractMethod == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(43);
        }
        if (klass == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(44);
        }
        return abstractMethod.getContainingClass() != klass;
    }

    private static Compatibility compatibleByCovariance(Project project, PhpType type, PhpType superType) {
        if (type.isEmpty() && !superType.isEmpty()) {
            return Compatibility.NON_COMPATIBLE;
        }
        if (PhpHierarchyChecksInspection.streamOfTypes(superType).anyMatch(superT -> PhpHierarchyChecksInspection.typeSuperCompatible(type, superT, project))) {
            return Compatibility.COMPATIBLE;
        }
        if (type.isComplete() && superType.isComplete()) {
            if (!superType.isNullable() && !superType.equals((Object)PhpType.MIXED) && type.isNullable()) {
                return Compatibility.NON_COMPATIBLE;
            }
            if (PhpHierarchyChecksInspection.compatibleByIterable(type, superType)) {
                return PhpLanguageFeature.ITERABLE_TYPE_HINT.isSupported(project) ? Compatibility.COMPATIBLE : LanguageBasedCompatibility.COMPATIBLE_IN_72;
            }
            if (PhpHierarchyChecksInspection.isCompatibleByCovariance(project, superType, type)) {
                return PhpProjectConfigurationFacade.getInstance(project).getLanguageLevel().isAtLeast(PhpLanguageLevel.PHP740) ? Compatibility.COMPATIBLE : LanguageBasedCompatibility.COMPATIBLE_IN_74;
            }
        }
        return Compatibility.NON_COMPATIBLE;
    }

    private static boolean isCompatibleByCovariance(@NotNull Project project, @NotNull PhpType superType, @NotNull PhpType type) {
        if (project == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(45);
        }
        if (superType == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(46);
        }
        if (type == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(47);
        }
        PhpIndex index = PhpIndex.getInstance((Project)project);
        for (String t : type.getTypes()) {
            for (String superT : superType.getTypes()) {
                if (!(superT.equalsIgnoreCase(t) || superT.equalsIgnoreCase("\\bool") && t.equalsIgnoreCase("\\false") || "\\object".equalsIgnoreCase(superT) && !PhpType.isPrimitiveType((String)t)) && !PhpType.findSuper((String)superT, (String)t, (PhpIndex)index)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean compatibleByIterable(@NotNull PhpType type, @NotNull PhpType superType) {
        if (type == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(48);
        }
        if (superType == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(49);
        }
        if ((PhpType.intersects((PhpType)type, (PhpType)PhpType.ARRAY) || PhpType.intersects((PhpType)type, (PhpType)PhpType.TRAVERSABLE)) && PhpType.intersects((PhpType)superType, (PhpType)PhpType.ITERABLE)) {
            return true;
        }
        return PhpType.intersects((PhpType)superType, (PhpType)PhpType.ARRAY) && PhpType.intersects((PhpType)superType, (PhpType)PhpType.TRAVERSABLE) && PhpType.intersects((PhpType)type, (PhpType)PhpType.ITERABLE);
    }

    public static PhpType unwrapAlias(@NotNull PhpType type, @NotNull Project project) {
        PhpClass original2;
        PhpClass phpClass;
        Collection classes;
        String fqn;
        if (type == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(50);
        }
        if (project == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(51);
        }
        if (type.isComplete() && type.getTypes().size() == 1 && !PhpType.isPrimitiveType((String)(fqn = (String)ContainerUtil.getFirstItem((Collection)type.getTypes()))) && !PhpType.isPluralType((String)fqn) && (classes = PhpIndex.getInstance((Project)project).getAnyByFQN(fqn)).size() == 1 && (phpClass = (PhpClass)ContainerUtil.getFirstItem((Collection)classes)) instanceof PhpClassAlias && (original2 = ((PhpClassAlias)phpClass).getOriginal()) != null) {
            return original2.getType();
        }
        return type;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 14: 
            case 17: 
            case 18: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 39: 
            case 40: 
            case 42: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 14: 
            case 17: 
            case 18: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 39: 
            case 40: 
            case 42: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 14: 
            case 17: 
            case 18: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 39: 
            case 40: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/classes/PhpHierarchyChecksInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 4: 
            case 12: 
            case 13: 
            case 45: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 7: 
            case 47: 
            case 48: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 6: 
            case 46: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superType";
                break;
            }
            case 11: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superMethod";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childReturnType";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superField";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superContainingClass";
                break;
            }
            case 37: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superParameter";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "abstractMethod";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "klass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/classes/PhpHierarchyChecksInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodSignatureDescriptor";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "streamOfTypes";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeFromReferences";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "appendMakeClassAbstractQuickFix";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "buildSuperName";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "checkDeclarationsCompatibility";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "createAddNonCompatibleTypes";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMethodSignatureDescriptor";
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 14: 
            case 17: 
            case 18: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 39: 
            case 40: 
            case 42: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "compatibleByInvariance";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "streamOfTypes";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "areDeclarationsFullyCompatible";
                break;
            }
            case 12: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "compatibleByReturnType";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getCompatibility";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "appendMakeClassAbstractQuickFix";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getMessage";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findDeepestSuperField";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "buildSuperName";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "compatibleByType";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getParameterType";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "shouldAddMethodStub";
                break;
            }
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "isCompatibleByCovariance";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "compatibleByIterable";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "unwrapAlias";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 14: 
            case 17: 
            case 18: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 39: 
            case 40: 
            case 42: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class PhpAppendNonCompatibleClassReferencesToParameterQuickFix
    implements LocalQuickFix {
        private final PhpType myNonCompatibleType;
        private final String myNonCompatibleTypePresentation;

        private PhpAppendNonCompatibleClassReferencesToParameterQuickFix(Set<PhpType> nonCompatibleTypes) {
            this.myNonCompatibleType = nonCompatibleTypes.stream().reduce(new PhpType(), (type, type2) -> type.add(type2));
            this.myNonCompatibleTypePresentation = StreamEx.of((Collection)this.myNonCompatibleType.getTypes()).map(PhpLangUtil::toShortName).joining((CharSequence)"|");
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            if (this.myNonCompatibleType.equals((Object)PhpType.MIXED)) {
                String string = PhpBundle.message("intention.family.name.change.to.mixed", new Object[0]);
                if (string == null) {
                    PhpAppendNonCompatibleClassReferencesToParameterQuickFix.$$$reportNull$$$0(0);
                }
                return string;
            }
            String string = PhpBundle.message("intention.family.name.append", this.myNonCompatibleTypePresentation);
            if (string == null) {
                PhpAppendNonCompatibleClassReferencesToParameterQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                PhpAppendNonCompatibleClassReferencesToParameterQuickFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                PhpAppendNonCompatibleClassReferencesToParameterQuickFix.$$$reportNull$$$0(3);
            }
            Parameter parameter = (Parameter)PhpPsiUtil.getParentByCondition(descriptor.getStartElement(), false, (Condition<? super PsiElement>)((Condition)Parameter.class::isInstance));
            PhpTypeDeclarationImpl typeDeclaration = (PhpTypeDeclarationImpl)((Object)PhpPsiUtil.getChildByCondition((PsiElement)parameter, (Condition<? super PsiElement>)((Condition)PhpTypeDeclaration.class::isInstance)));
            assert (typeDeclaration != null);
            if (this.myNonCompatibleType.equals((Object)PhpType.MIXED)) {
                typeDeclaration.update(PhpType.MIXED);
                return;
            }
            for (String type : this.myNonCompatibleType.getTypes()) {
                typeDeclaration.addTypeReference(type);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/classes/PhpHierarchyChecksInspection$PhpAppendNonCompatibleClassReferencesToParameterQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/classes/PhpHierarchyChecksInspection$PhpAppendNonCompatibleClassReferencesToParameterQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PhpRemoveClassReferenceFromTypeDeclaration
    extends LocalQuickFixOnPsiElement {
        private final String myElementText;

        protected PhpRemoveClassReferenceFromTypeDeclaration(@NotNull PsiElement element) {
            if (element == null) {
                PhpRemoveClassReferenceFromTypeDeclaration.$$$reportNull$$$0(0);
            }
            super(element);
            this.myElementText = element.getText();
        }

        @IntentionName
        @NotNull
        public String getText() {
            String string = PhpBundle.message("annotator.fix.remove", this.myElementText);
            if (string == null) {
                PhpRemoveClassReferenceFromTypeDeclaration.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                PhpRemoveClassReferenceFromTypeDeclaration.$$$reportNull$$$0(2);
            }
            if (file == null) {
                PhpRemoveClassReferenceFromTypeDeclaration.$$$reportNull$$$0(3);
            }
            if (startElement == null) {
                PhpRemoveClassReferenceFromTypeDeclaration.$$$reportNull$$$0(4);
            }
            if (endElement == null) {
                PhpRemoveClassReferenceFromTypeDeclaration.$$$reportNull$$$0(5);
            }
            PhpCodeEditUtil.removeStatementWithDelivery(startElement, PhpTokenTypes.opBIT_OR);
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = this.getText();
            if (string == null) {
                PhpRemoveClassReferenceFromTypeDeclaration.$$$reportNull$$$0(6);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/classes/PhpHierarchyChecksInspection$PhpRemoveClassReferenceFromTypeDeclaration";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/classes/PhpHierarchyChecksInspection$PhpRemoveClassReferenceFromTypeDeclaration";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 6: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class Compatibility {
        private static final Compatibility COMPATIBLE = new Compatibility(true);
        private static final Compatibility NON_COMPATIBLE = new Compatibility(false);
        protected final boolean myCompatible;

        protected Compatibility(boolean compatible) {
            this.myCompatible = compatible;
        }

        public boolean isCompatible() {
            return this.myCompatible;
        }

        public static Compatibility from(boolean value) {
            return value ? COMPATIBLE : NON_COMPATIBLE;
        }

        public void registerProblem(ProblemsHolder holder, ProblemDescriptor descriptor) {
            holder.registerProblem(descriptor.getPsiElement(), descriptor.getTextRangeInElement(), descriptor.getDescriptionTemplate(), (LocalQuickFix[])descriptor.getFixes());
        }

        private static Compatibility createUnionTypeCompatibility(final Map<PhpType, Compatibility> nonCompatibleReferences, final @Nullable PhpTypeDeclaration typeDeclaration) {
            if (nonCompatibleReferences.isEmpty()) {
                return COMPATIBLE;
            }
            final boolean standaloneTypeDeclaration = typeDeclaration != null && typeDeclaration.getClassReferences().size() == 1;
            return new Compatibility(false){

                @Override
                public void registerProblem(ProblemsHolder holder, ProblemDescriptor descriptor) {
                    InspectionManager manager = InspectionManager.getInstance((Project)holder.getProject());
                    for (Map.Entry e : nonCompatibleReferences.entrySet()) {
                        Object element = typeDeclaration != null && !standaloneTypeDeclaration ? (PsiElement)ContainerUtil.find((Iterable)typeDeclaration.getClassReferences(), ref -> ref.resolveLocalType().equals(e.getKey())) : typeDeclaration;
                        if (element == null) continue;
                        LocalQuickFix[] fixes = !standaloneTypeDeclaration ? (LocalQuickFix[])ArrayUtil.append((Object[])((LocalQuickFix[])descriptor.getFixes()), (Object)((Object)new PhpRemoveClassReferenceFromTypeDeclaration((PsiElement)element))) : (LocalQuickFix[])descriptor.getFixes();
                        ((Compatibility)e.getValue()).registerProblem(holder, manager.createProblemDescriptor((PsiElement)element, descriptor.getDescriptionTemplate(), holder.isOnTheFly(), fixes, descriptor.getHighlightType()));
                    }
                }
            };
        }
    }

    private static final class LanguageBasedCompatibility
    extends Compatibility {
        private static final Compatibility COMPATIBLE_IN_72 = new LanguageBasedCompatibility(false, PhpLanguageLevel.PHP720);
        private static final Compatibility COMPATIBLE_IN_74 = new LanguageBasedCompatibility(false, PhpLanguageLevel.PHP740);
        @NotNull
        private final PhpLanguageLevel myCompatibleLanguageLevel;

        private LanguageBasedCompatibility(boolean compatible, @NotNull PhpLanguageLevel level) {
            if (level == null) {
                LanguageBasedCompatibility.$$$reportNull$$$0(0);
            }
            super(compatible);
            this.myCompatibleLanguageLevel = level;
        }

        @Override
        public void registerProblem(ProblemsHolder holder, ProblemDescriptor descriptor) {
            LocalQuickFix[] fixes = new LocalQuickFix[]{PhpSwitchLanguageLevelQuickFix.getInstance(this.myCompatibleLanguageLevel)};
            holder.registerProblem(descriptor.getPsiElement(), descriptor.getTextRangeInElement(), PhpBundle.message("inspection.message.from.php.this.allowed", descriptor.getDescriptionTemplate(), this.myCompatibleLanguageLevel.getPresentableName()), fixes);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/jetbrains/php/lang/inspections/classes/PhpHierarchyChecksInspection$LanguageBasedCompatibility", "<init>"));
        }
    }
}

