/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.classes;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.annotator.PhpAnnotatorVisitor;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.type.PhpParamsInspection;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.ParameterListOwner;
import com.jetbrains.php.lang.psi.elements.impl.ParameterListImpl;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpArgumentWithoutNamedIdentifierInspection
extends PhpInspection {
    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP800;
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpArgumentWithoutNamedIdentifierInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpParameterList(ParameterList list) {
                Parameter parameter;
                LocalQuickFix quickFix;
                List<PsiElement> arguments = Arrays.asList(list.getParameters());
                int indexOfLastPositionalArgument = PhpArgumentWithoutNamedIdentifierInspection.getIndexOfLastPositionalArgument(arguments);
                if (indexOfLastPositionalArgument < 0) {
                    return;
                }
                List<Parameter> parameters = PhpArgumentWithoutNamedIdentifierInspection.resolveParameters(list);
                if (parameters == null) {
                    return;
                }
                for (int i = indexOfLastPositionalArgument; i >= 0 && (quickFix = PhpArgumentWithoutNamedIdentifierInspection.getQuickFix(indexOfLastPositionalArgument, i, parameter = PhpParamsInspection.getMappedParam(arguments, parameters, i))) != null; --i) {
                    holder.registerProblem(arguments.get(i), PhpBundle.message("inspection.message.argument.without.name.identifier", new Object[0]), new LocalQuickFix[]{quickFix});
                }
            }
        };
    }

    @Nullable
    public static LocalQuickFix getQuickFix(int indexOfLastPositionalArgument, int argumentIndex, Parameter mappedParameter) {
        if (mappedParameter == null || mappedParameter.isVariadic()) {
            return null;
        }
        return argumentIndex == indexOfLastPositionalArgument ? new PhpAddNameToLastArgumentQuickFix(mappedParameter.getName()) : PhpAddNameToAllArgumentsStartingFromCurrentQuickFix.INSTANCE;
    }

    @Nullable
    public static List<Parameter> resolveParameters(ParameterList list) {
        Function singleFunction;
        ParameterListOwner parameterListOwner = (ParameterListOwner)ObjectUtils.tryCast((Object)list.getParent(), ParameterListOwner.class);
        Function function = singleFunction = parameterListOwner != null ? (Function)ContainerUtil.getOnlyItem(PhpAnnotatorVisitor.resolveFunctions(parameterListOwner)) : null;
        if (singleFunction == null || singleFunction instanceof PhpDocMethod) {
            return null;
        }
        return Arrays.asList(singleFunction.getParameters());
    }

    public static int getIndexOfLastPositionalArgument(List<PsiElement> arguments) {
        return ContainerUtil.lastIndexOf(arguments, argument -> ParameterListImpl.getNameIdentifier(argument) == null);
    }

    public static void doAddNamedArguments(@NotNull Project project, PsiElement argument) {
        if (project == null) {
            PhpArgumentWithoutNamedIdentifierInspection.$$$reportNull$$$0(1);
        }
        ParameterList parameterList = (ParameterList)argument.getParent();
        Function function = (Function)ContainerUtil.getOnlyItem(PhpAnnotatorVisitor.resolveFunctions((ParameterListOwner)parameterList.getParent()));
        assert (function != null);
        List<Parameter> parameters = Arrays.asList(function.getParameters());
        List<PsiElement> arguments = Arrays.asList(parameterList.getParameters());
        int startIndex = PhpCodeInsightUtil.getParameterIndex(argument);
        int endIndex = PhpArgumentWithoutNamedIdentifierInspection.getIndexOfLastPositionalArgument(arguments);
        List parameterNames = IntStream.rangeClosed(startIndex, endIndex).mapToObj(i -> PhpParamsInspection.getMappedParam(arguments, parameters, i)).map(p -> Objects.requireNonNull(p).getName()).collect(Collectors.toList());
        for (int i2 = startIndex; i2 <= endIndex; ++i2) {
            PsiElement colon = parameterList.addBefore(PhpPsiElementFactory.createColon(project), arguments.get(i2));
            parameterList.addBefore(PhpPsiElementFactory.createNamedArgumentNameIdentifier(project, (String)parameterNames.get(i2 - startIndex)), colon);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/classes/PhpArgumentWithoutNamedIdentifierInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "doAddNamedArguments";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class PhpAddNameToAllArgumentsStartingFromCurrentQuickFix
    implements LocalQuickFix {
        private static final PhpAddNameToAllArgumentsStartingFromCurrentQuickFix INSTANCE = new PhpAddNameToAllArgumentsStartingFromCurrentQuickFix();

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.add.name.identifiers.to.all.arguments.starting.from.current", new Object[0]);
            if (string == null) {
                PhpAddNameToAllArgumentsStartingFromCurrentQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                PhpAddNameToAllArgumentsStartingFromCurrentQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                PhpAddNameToAllArgumentsStartingFromCurrentQuickFix.$$$reportNull$$$0(2);
            }
            PhpArgumentWithoutNamedIdentifierInspection.doAddNamedArguments(project, descriptor.getStartElement());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/classes/PhpArgumentWithoutNamedIdentifierInspection$PhpAddNameToAllArgumentsStartingFromCurrentQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/classes/PhpArgumentWithoutNamedIdentifierInspection$PhpAddNameToAllArgumentsStartingFromCurrentQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PhpAddNameToLastArgumentQuickFix
    extends PhpAddNameToAllArgumentsStartingFromCurrentQuickFix {
        private final String myName;

        private PhpAddNameToLastArgumentQuickFix(String name) {
            this.myName = name;
        }

        @IntentionName
        @NotNull
        public String getName() {
            String string = PhpBundle.message("intention.name.add.name.identifier", this.myName);
            if (string == null) {
                PhpAddNameToLastArgumentQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/lang/inspections/classes/PhpArgumentWithoutNamedIdentifierInspection$PhpAddNameToLastArgumentQuickFix", "getName"));
        }
    }
}

