/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.attributes;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpAttribute;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpRedundantAttributeParenthesisInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpRedundantAttributeParenthesisInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpAttribute(PhpAttribute attribute) {
                PsiElement lParen = PhpPsiUtil.getChildOfType((PsiElement)attribute, PhpTokenTypes.chLPAREN);
                PsiElement rParen = PhpPsiUtil.getChildOfType((PsiElement)attribute, PhpTokenTypes.chRPAREN);
                if (lParen != null && rParen != null && attribute.getParameter(0) == null) {
                    holder.registerProblem((PsiElement)attribute, PhpBundle.message("inspection.message.redundant.parenthesis", new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, TextRange.create((int)lParen.getTextRangeInParent().getStartOffset(), (int)rParen.getTextRangeInParent().getEndOffset()), new LocalQuickFix[]{PhpRemoveParenthesisQuickFix.INSTANCE});
                }
            }
        };
    }

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP800;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/attributes/PhpRedundantAttributeParenthesisInspection", "buildVisitor"));
    }

    private static class PhpRemoveParenthesisQuickFix
    implements LocalQuickFix {
        static final LocalQuickFix INSTANCE = new PhpRemoveParenthesisQuickFix();

        private PhpRemoveParenthesisQuickFix() {
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.remove.parenthesis", new Object[0]);
            if (string == null) {
                PhpRemoveParenthesisQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                PhpRemoveParenthesisQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                PhpRemoveParenthesisQuickFix.$$$reportNull$$$0(2);
            }
            PsiElement attribute = descriptor.getStartElement();
            PsiElement lParen = PhpPsiUtil.getChildOfType(attribute, PhpTokenTypes.chLPAREN);
            PsiElement rParen = PhpPsiUtil.getChildOfType(attribute, PhpTokenTypes.chRPAREN);
            attribute.deleteChildRange(lParen, rParen);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/attributes/PhpRedundantAttributeParenthesisInspection$PhpRemoveParenthesisQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/attributes/PhpRedundantAttributeParenthesisInspection$PhpRemoveParenthesisQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

