/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.attributes;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCallInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpAttribute;
import com.jetbrains.php.lang.psi.elements.PhpAttributesList;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpTriviallyPureFunctionsIndex;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpPureFunctionMayProduceSideEffectsInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpPureFunctionMayProduceSideEffectsInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            /*
             * Issues handling annotations - annotations may be inaccurate
             */
            public void visitPhpFunction(Function function) {
                @NotNull Collection pureAttributes = function.getAttributes("\\JetBrains\\PhpStorm\\Pure");
                if (pureAttributes.isEmpty()) {
                    return;
                }
                if (PhpTriviallyPureFunctionsIndex.canContainsSideEffect(function, (Ref<Boolean>)new Ref((Object)false), (Ref<Boolean>)new Ref((Object)false), true) && !this.hasUnresolvedCall(function)) {
                    this.registerErrorsOnAttributes(function, pureAttributes);
                }
            }

            private void registerErrorsOnAttributes(Function function, Collection<@NotNull PhpAttribute> pureAttributes) {
                String template = function instanceof Method ? PhpBundle.message("inspection.message.method.may.produce.side.effects", new Object[0]) : PhpBundle.message("inspection.message.function.may.produce.side.effects", new Object[0]);
                for (PhpAttribute attribute : pureAttributes) {
                    ClassReference reference = attribute.getClassReference();
                    if (reference == null) continue;
                    holder.registerProblem((PsiElement)reference, template, new LocalQuickFix[]{PhpRemovePureAttributeQuickFix.INSTANCE});
                }
            }

            private boolean hasUnresolvedCall(Function function) {
                final Ref hasUnresolvedCall = new Ref((Object)false);
                PhpControlFlowUtil.processSuccessors((PhpInstruction)function.getControlFlow().getEntryPoint(), false, new PhpInstructionProcessor(){

                    public boolean processPhpCallInstruction(PhpCallInstruction instruction) {
                        if (instruction.getFunctionReference().multiResolve(false).length == 0) {
                            hasUnresolvedCall.set((Object)true);
                            return false;
                        }
                        return super.processPhpCallInstruction(instruction);
                    }
                });
                return (Boolean)hasUnresolvedCall.get();
            }

            public void visitPhpMethod(Method method) {
                this.visitPhpFunction((Function)method);
            }
        };
    }

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP800;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/attributes/PhpPureFunctionMayProduceSideEffectsInspection", "buildVisitor"));
    }

    private static class PhpRemovePureAttributeQuickFix
    implements LocalQuickFix {
        static final LocalQuickFix INSTANCE = new PhpRemovePureAttributeQuickFix();

        private PhpRemovePureAttributeQuickFix() {
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.remove.pure", new Object[0]);
            if (string == null) {
                PhpRemovePureAttributeQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                PhpRemovePureAttributeQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                PhpRemovePureAttributeQuickFix.$$$reportNull$$$0(2);
            }
            Object element = PhpPsiUtil.getParentByCondition(descriptor.getStartElement(), false, (Condition<? super PsiElement>)((Condition)PhpAttribute.class::isInstance));
            if (element != null && element.isValid()) {
                PhpAttributesList list = (PhpAttributesList)PhpPsiUtil.getParentByCondition(element, (Condition<? super PsiElement>)((Condition)PhpAttributesList.class::isInstance));
                if (list != null && list.getAttributes().size() == 1) {
                    list.delete();
                } else {
                    PhpCodeEditUtil.removeStatementWithDelivery(element, PhpTokenTypes.opCOMMA);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/attributes/PhpPureFunctionMayProduceSideEffectsInspection$PhpRemovePureAttributeQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/attributes/PhpPureFunctionMayProduceSideEffectsInspection$PhpRemovePureAttributeQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

