/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.attributes;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.attributes.PhpAddAttributeQuickFixBase;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpTriviallyPureFunctionsIndex;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpPureAttributeCanBeAddedInspection
extends PhpInspection {
    static final LocalQuickFix FIX = new PhpAddAttributeQuickFixBase("\\JetBrains\\PhpStorm\\Pure");

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpPureAttributeCanBeAddedInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpFunction(Function function) {
                PsiElement nameIdentifier = function.getNameIdentifier();
                if (nameIdentifier == null || PhpTriviallyPureFunctionsIndex.cannotBeTriviallyPure(function)) {
                    return;
                }
                Ref nonTrivial = new Ref((Object)false);
                if (!PhpTriviallyPureFunctionsIndex.canContainSideEffects(function, (Ref<Boolean>)nonTrivial, true) && ((Boolean)nonTrivial.get()).booleanValue()) {
                    holder.registerProblem((PsiElement)function, nameIdentifier.getTextRangeInParent(), PhpBundle.message("inspection.message.pure.can.be.added", new Object[0]), new LocalQuickFix[]{FIX});
                }
            }

            public void visitPhpMethod(Method method) {
                this.visitPhpFunction((Function)method);
            }
        };
    }

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP800;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/attributes/PhpPureAttributeCanBeAddedInspection", "buildVisitor"));
    }
}

