/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.attributes;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveResult;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpAttribute;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassFieldsList;
import com.jetbrains.php.lang.psi.elements.impl.PhpClassConstantsListImpl;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionArgument;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionClassConstantArgument;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpInapplicableAttributeTargetDeclarationInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpInapplicableAttributeTargetDeclarationInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpAttribute(PhpAttribute attribute) {
                String inapplicableTargetDeclarationName = PhpInapplicableAttributeTargetDeclarationInspection.getInapplicableDeclarationName(attribute.getParent().getParent(), PhpInapplicableAttributeTargetDeclarationInspection.getRootAttributes(attribute));
                if (inapplicableTargetDeclarationName != null) {
                    String requiredAttribute = "Attribute::TARGET_" + inapplicableTargetDeclarationName.toUpperCase(Locale.ENGLISH);
                    holder.registerProblem((PsiElement)attribute, PhpBundle.message("inspection.message.attribute.can.t.be.applied.to.because.it.doest.contains", inapplicableTargetDeclarationName, requiredAttribute), new LocalQuickFix[0]);
                }
            }
        };
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static String getInapplicableDeclarationName(@NotNull PsiElement declaration, Collection<@NotNull PhpAttribute> rootAttributes) {
        if (declaration == null) {
            PhpInapplicableAttributeTargetDeclarationInspection.$$$reportNull$$$0(1);
        }
        if (rootAttributes.isEmpty()) {
            return null;
        }
        HashSet<@NotNull PhpExpectedFunctionArgument> arguments = new HashSet<PhpExpectedFunctionArgument>();
        for (PhpAttribute rootAttribute : rootAttributes) {
            @NotNull List args = rootAttribute.getArgumentsValues();
            if (args.isEmpty()) {
                return null;
            }
            arguments.addAll(args);
        }
        return PhpInapplicableAttributeTargetDeclarationInspection.getInapplicableDeclarationName(arguments, declaration);
    }

    @NotNull
    public static @NotNull List<@NotNull PhpAttribute> getRootAttributes(@NotNull PhpAttribute attribute) {
        ClassReference reference;
        if (attribute == null) {
            PhpInapplicableAttributeTargetDeclarationInspection.$$$reportNull$$$0(2);
        }
        if ((reference = attribute.getClassReference()) == null) {
            List<PhpAttribute> list = Collections.emptyList();
            if (list == null) {
                PhpInapplicableAttributeTargetDeclarationInspection.$$$reportNull$$$0(3);
            }
            return list;
        }
        List list = (List)((StreamEx)StreamEx.of((Object[])reference.multiResolve(false)).map(ResolveResult::getElement).map(PhpInapplicableAttributeTargetDeclarationInspection::remapConstructorToClass).select(PhpClass.class).flatMap(c -> c.getAttributes().stream()).filter(attr -> PhpLangUtil.equalsClassNames(attr.getFQN(), "\\Attribute"))).collect(Collectors.toList());
        if (list == null) {
            PhpInapplicableAttributeTargetDeclarationInspection.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Nullable
    private static PsiElement remapConstructorToClass(PsiElement e) {
        return e instanceof Method && ((Method)e).getMethodType(false) == Method.MethodType.CONSTRUCTOR ? ((Method)e).getContainingClass() : e;
    }

    @Nls
    private static String getInapplicableDeclarationName(Collection<PhpExpectedFunctionArgument> arguments, PsiElement declaration) {
        if (PhpInapplicableAttributeTargetDeclarationInspection.existsRootDeclaration(arguments, "TARGET_ALL")) {
            return null;
        }
        if (declaration instanceof PhpClass) {
            return !PhpInapplicableAttributeTargetDeclarationInspection.existsRootDeclaration(arguments, "TARGET_CLASS") ? PhpBundle.message("class2", new Object[0]) : null;
        }
        if (declaration instanceof Method) {
            return !PhpInapplicableAttributeTargetDeclarationInspection.existsRootDeclaration(arguments, "TARGET_METHOD") ? PhpBundle.message("method1", new Object[0]) : null;
        }
        if (declaration instanceof Function) {
            return !PhpInapplicableAttributeTargetDeclarationInspection.existsRootDeclaration(arguments, "TARGET_FUNCTION") ? PhpBundle.message("function", new Object[0]) : null;
        }
        if (declaration instanceof PhpClassConstantsListImpl) {
            return !PhpInapplicableAttributeTargetDeclarationInspection.existsRootDeclaration(arguments, "TARGET_CLASS_CONSTANT") ? PhpBundle.message("class.constant1", new Object[0]) : null;
        }
        if (declaration instanceof PhpClassFieldsList || declaration instanceof Parameter && ((Parameter)declaration).isPromotedField()) {
            return !PhpInapplicableAttributeTargetDeclarationInspection.existsRootDeclaration(arguments, "TARGET_PROPERTY") ? PhpBundle.message("property", new Object[0]) : null;
        }
        if (declaration instanceof Parameter) {
            return !PhpInapplicableAttributeTargetDeclarationInspection.existsRootDeclaration(arguments, "TARGET_PARAMETER") ? PhpBundle.message("parameter1", new Object[0]) : null;
        }
        return null;
    }

    public static boolean existsRootDeclaration(Collection<PhpExpectedFunctionArgument> arguments, String aClass) {
        return ContainerUtil.exists(arguments, a -> a instanceof PhpExpectedFunctionClassConstantArgument && PhpLangUtil.equalsClassNames(PhpLangUtil.toFQN(((PhpExpectedFunctionClassConstantArgument)((Object)a)).getClassFqn()), "\\Attribute") && PhpLangUtil.equalsClassConstantNames(((PhpExpectedFunctionClassConstantArgument)((Object)a)).getConstantName(), aClass));
    }

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP800;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/attributes/PhpInapplicableAttributeTargetDeclarationInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/attributes/PhpInapplicableAttributeTargetDeclarationInspection";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInapplicableDeclarationName";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getRootAttributes";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

