/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.attributes;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveResult;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.annotator.PhpAnnotatorVisitor;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpAttribute;
import com.jetbrains.php.lang.psi.elements.PhpAttributesOwner;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.impl.FieldReferenceImpl;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionArgument;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionClassConstantArgument;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collection;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpImmutablePropertyIsWrittenInspection
extends PhpInspection {
    private static final String IMMUTABLE_ATTRIBUTE_FQN = "\\JetBrains\\PhpStorm\\Immutable";
    private static final PhpExpectedFunctionClassConstantArgument DEFAULT_WRITE_SCOPE = new PhpExpectedFunctionClassConstantArgument("\\JetBrains\\PhpStorm\\Immutable", PropertyWriteScope.CONSTRUCTOR.getName(), 0, 0, null, false, true);

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpImmutablePropertyIsWrittenInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            /*
             * Issues handling annotations - annotations may be inaccurate
             */
            public void visitPhpFieldReference(FieldReference fieldReference) {
                if (((FieldReferenceImpl)fieldReference).isWriteAccess(false)) {
                    List fields = StreamEx.of((Object[])fieldReference.multiResolve(false)).map(ResolveResult::getElement).select(PhpAttributesOwner.class).select(Field.class).toList();
                    if (fields.isEmpty()) {
                        return;
                    }
                    @NotNull List attributes = ContainerUtil.map((Collection)fields, x$0 -> PhpImmutablePropertyIsWrittenInspection.getImmutableAttribute(x$0));
                    if (attributes.contains(null)) {
                        return;
                    }
                    PropertyWriteScope declaredWriteScope = PhpImmutablePropertyIsWrittenInspection.getDeclaredWriteScope(attributes);
                    if (declaredWriteScope != null && fields.stream().allMatch(field -> PhpImmutablePropertyIsWrittenInspection.writeAccessIsNotAllowed(fieldReference, declaredWriteScope, field))) {
                        holder.registerProblem((PsiElement)fieldReference, PhpBundle.message("inspection.message.immutable.property.write.scope.does.not.allow.write.access.here", declaredWriteScope.getName()), new LocalQuickFix[0]);
                    }
                }
            }
        };
    }

    @Nullable
    private static PropertyWriteScope getDeclaredWriteScope(List<@NotNull PhpAttribute> attributes) {
        return StreamEx.of(attributes).map(attribute -> (PhpExpectedFunctionArgument)ContainerUtil.getFirstItem((Collection)attribute.getArgumentsValues(), (Object)((Object)DEFAULT_WRITE_SCOPE))).select(PhpExpectedFunctionClassConstantArgument.class).map(constant -> PhpImmutablePropertyIsWrittenInspection.getWriteScope(constant.getConstantName())).nonNull().reverseSorted().findFirst().orElse(null);
    }

    private static boolean writeAccessIsNotAllowed(FieldReference fieldReference, PropertyWriteScope writeScope, Field field) {
        PhpClass containingClass = field.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        PropertyWriteScope placeWriteScope = PhpImmutablePropertyIsWrittenInspection.getWriteScope(fieldReference, containingClass);
        return placeWriteScope == null || writeScope.compareTo(placeWriteScope) < 0;
    }

    @Nullable
    private static PropertyWriteScope getWriteScope(@NotNull FieldReference place, @NotNull PhpClass fieldClass) {
        Method method;
        Method constructor;
        if (place == null) {
            PhpImmutablePropertyIsWrittenInspection.$$$reportNull$$$0(1);
        }
        if (fieldClass == null) {
            PhpImmutablePropertyIsWrittenInspection.$$$reportNull$$$0(2);
        }
        if ((constructor = fieldClass.getOwnConstructor()) != null && (method = (Method)PhpPsiUtil.getParentByCondition((PsiElement)place, false, (Condition<? super PsiElement>)Method.INSTANCEOF)) != null && PhpLangUtil.equalsMethodNames(method.getFQN(), constructor.getFQN())) {
            return PropertyWriteScope.CONSTRUCTOR;
        }
        Collection<PhpClass> current = PhpAnnotatorVisitor.resolveCurrentScope((MemberReference)place, null);
        PhpModifier.Access accessibleInContextAccess = PhpAnnotatorVisitor.getStrictestAccessibleInContextReferenceAccess((MemberReference)place, fieldClass, current);
        if (accessibleInContextAccess == PhpModifier.Access.PRIVATE) {
            return PropertyWriteScope.PRIVATE;
        }
        if (accessibleInContextAccess == PhpModifier.Access.PROTECTED) {
            return PropertyWriteScope.PROTECTED;
        }
        return null;
    }

    @Nullable
    private static PhpAttribute getImmutableAttribute(PhpAttributesOwner field) {
        PhpAttribute attribute = (PhpAttribute)ContainerUtil.getFirstItem((Collection)field.getAttributes(IMMUTABLE_ATTRIBUTE_FQN));
        if (attribute != null) {
            return attribute;
        }
        PhpClass containingClass = ((Field)field).getContainingClass();
        return containingClass != null ? (PhpAttribute)ContainerUtil.getFirstItem((Collection)containingClass.getAttributes(IMMUTABLE_ATTRIBUTE_FQN)) : null;
    }

    @Nullable
    private static PropertyWriteScope getWriteScope(@Nullable String constantName) {
        return (PropertyWriteScope)((Object)ContainerUtil.find((Object[])PropertyWriteScope.values(), scope -> PhpLangUtil.equalsConstantNames(constantName, scope.getName())));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldClass";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/attributes/PhpImmutablePropertyIsWrittenInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getWriteScope";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static enum PropertyWriteScope {
        CONSTRUCTOR("CONSTRUCTOR_WRITE_SCOPE"),
        PRIVATE("PRIVATE_WRITE_SCOPE"),
        PROTECTED("PROTECTED_WRITE_SCOPE");

        private final String myName;

        private PropertyWriteScope(String name) {
            this.myName = name;
        }

        String getName() {
            return this.myName;
        }
    }
}

