/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.attributes;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.PhpAttribute;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collection;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpClassCantBeUsedAsAttributeInspection
extends PhpInspection {
    public static final String ROOT_ATTRIBUTE = "\\Attribute";

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpClassCantBeUsedAsAttributeInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpAttribute(PhpAttribute attribute) {
                ClassReference reference;
                String fqn = attribute.getFQN();
                if (PhpLangUtil.equalsClassNames(PhpClassCantBeUsedAsAttributeInspection.ROOT_ATTRIBUTE, fqn)) {
                    return;
                }
                Collection classes = PhpIndex.getInstance((Project)holder.getProject()).getAnyByFQN(fqn);
                if (fqn != null && !classes.isEmpty() && classes.stream().noneMatch(c -> PhpClassCantBeUsedAsAttributeInspection.rootAttributes(c).findAny().isPresent()) && (reference = attribute.getClassReference()) != null) {
                    LocalQuickFix[] localQuickFixArray;
                    if (classes.size() == 1) {
                        LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                        localQuickFixArray = localQuickFixArray2;
                        localQuickFixArray2[0] = new PhpAddRootAttributeQuickFix(fqn);
                    } else {
                        localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
                    }
                    LocalQuickFix[] fixes = localQuickFixArray;
                    holder.registerProblem((PsiElement)reference, PhpBundle.message("inspection.message.class.does.not.have.attribute", reference.getName()), fixes);
                }
            }
        };
    }

    public static Stream<PhpAttribute> rootAttributes(PhpClass phpClass) {
        return phpClass.getAttributes().stream().filter(attr -> PhpLangUtil.equalsClassNames(attr.getFQN(), ROOT_ATTRIBUTE));
    }

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP800;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/attributes/PhpClassCantBeUsedAsAttributeInspection", "buildVisitor"));
    }

    private static class PhpAddRootAttributeQuickFix
    implements LocalQuickFix {
        private final String myFqn;

        private PhpAddRootAttributeQuickFix(String fqn) {
            this.myFqn = fqn;
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.add.attribute.attribute", new Object[0]);
            if (string == null) {
                PhpAddRootAttributeQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PhpClass phpClass;
            if (project == null) {
                PhpAddRootAttributeQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                PhpAddRootAttributeQuickFix.$$$reportNull$$$0(2);
            }
            if ((phpClass = (PhpClass)ContainerUtil.getFirstItem((Collection)PhpIndex.getInstance((Project)project).getAnyByFQN(this.myFqn))) == null) {
                return;
            }
            PhpPsiElement scope = (PhpPsiElement)ObjectUtils.notNull((Object)PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)phpClass), (Object)phpClass);
            phpClass.addBefore((PsiElement)PhpPsiElementFactory.createAttributesList(project, PhpCodeInsightUtil.createQualifiedName(scope, PhpClassCantBeUsedAsAttributeInspection.ROOT_ATTRIBUTE)), phpClass.getFirstChild());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/attributes/PhpClassCantBeUsedAsAttributeInspection$PhpAddRootAttributeQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/attributes/PhpClassCantBeUsedAsAttributeInspection$PhpAddRootAttributeQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

