/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.attributes;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpArrayAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpReturnInstruction;
import com.jetbrains.php.completion.expectedArguments.PhpExpectedFunctionArgumentLookupElement;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.attributes.PhpAttributeCanBeAddedToOverriddenMemberInspection;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.ArrayHashElement;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpAttributesList;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.ArrayCreationExpressionImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpArrayShapeEntriesIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpArrayShapeRegistry;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpAttributesRegistryBase;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionArgument;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionArgumentsIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionClassConstantArgument;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionScalarArgument;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpArrayShapeAttributeCanBeAddedInspection
extends PhpInspection {
    private static final int SHAPE_LIMIT = 10;

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpArrayShapeAttributeCanBeAddedInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpMethod(Method method) {
                this.visitPhpFunction((Function)method);
            }

            public void visitPhpFunction(Function function) {
                if (function instanceof PhpDocMethod) {
                    return;
                }
                if (!function.getAttributes("\\JetBrains\\PhpStorm\\ArrayShape").isEmpty()) {
                    return;
                }
                PsiElement nameIdentifier = function.getNameIdentifier();
                if (nameIdentifier == null) {
                    return;
                }
                Collection<PhpArrayShapeEntriesIndex.PhpArrayShapeEntry> shapes = PhpArrayShapeAttributeCanBeAddedInspection.getShapes(function);
                if (shapes != null && shapes.size() < 10 && ContainerUtil.exists(shapes, s -> !(s.getKey() instanceof PhpExpectedFunctionScalarArgument) || ((PhpExpectedFunctionScalarArgument)s.getKey()).isStringLiteral())) {
                    holder.registerProblem((PsiElement)function, nameIdentifier.getTextRangeInParent(), PhpBundle.message("inspection.message.arrayshape.can.be.added", new Object[0]), new LocalQuickFix[]{PhpAddArrayShapeQuickFix.INSTANCE});
                }
            }
        };
    }

    private static Collection<PhpArrayShapeEntriesIndex.PhpArrayShapeEntry> getShapes(Function function) {
        final Ref shapes = new Ref(null);
        final Ref ambiguity = new Ref((Object)false);
        PhpControlFlowUtil.processSuccessors((PhpInstruction)function.getControlFlow().getEntryPoint(), false, new PhpInstructionProcessor(){

            public boolean processInstruction(PhpInstruction instruction) {
                if (((Boolean)ambiguity.get()).booleanValue()) {
                    return false;
                }
                return super.processInstruction(instruction);
            }

            public boolean processReturnInstruction(PhpReturnInstruction instruction) {
                List<PhpArrayShapeEntriesIndex.PhpArrayShapeEntry> currentShapes = PhpInferredArrayShapeRegistry.INSTANCE.getValues(instruction.getArgument(), false);
                if (currentShapes.isEmpty() || !shapes.isNull() && !currentShapes.equals(shapes.get())) {
                    ambiguity.set((Object)true);
                    return false;
                }
                shapes.set(currentShapes);
                return super.processReturnInstruction(instruction);
            }
        });
        return (Boolean)ambiguity.get() == false ? (Collection)shapes.get() : null;
    }

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP800;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/attributes/PhpArrayShapeAttributeCanBeAddedInspection", "buildVisitor"));
    }

    private static class PhpAddArrayShapeQuickFix
    implements LocalQuickFix {
        private static final LocalQuickFix INSTANCE = new PhpAddArrayShapeQuickFix();

        private PhpAddArrayShapeQuickFix() {
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.add.arrayshape.attribute", new Object[0]);
            if (string == null) {
                PhpAddArrayShapeQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            Function function;
            if (project == null) {
                PhpAddArrayShapeQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                PhpAddArrayShapeQuickFix.$$$reportNull$$$0(2);
            }
            if ((function = (Function)descriptor.getStartElement()) == null) {
                return;
            }
            Collection<PhpArrayShapeEntriesIndex.PhpArrayShapeEntry> shapes = PhpAddArrayShapeQuickFix.collapseSameKeys(PhpArrayShapeAttributeCanBeAddedInspection.getShapes(function));
            if (shapes == null) {
                return;
            }
            PhpAttributesList attributeList = PhpPsiElementFactory.createAttributesList(project, String.format("%s([%s])", "\\JetBrains\\PhpStorm\\ArrayShape", StringUtil.join(shapes, PhpAddArrayShapeQuickFix::getArrayHashElement, (String)", ")));
            PhpAttributesList addedArrayShapeAttribute = (PhpAttributesList)function.addBefore((PsiElement)attributeList, function.getFirstChild());
            PhpAttributeCanBeAddedToOverriddenMemberInspection.shortenClassReferences((PhpPsiElement)ContainerUtil.getFirstItem((Collection)addedArrayShapeAttribute.getAttributes()));
        }

        @Nullable
        private static Collection<PhpArrayShapeEntriesIndex.PhpArrayShapeEntry> collapseSameKeys(@Nullable Collection<PhpArrayShapeEntriesIndex.PhpArrayShapeEntry> shapes) {
            if (shapes == null) {
                return null;
            }
            LinkedHashMap<PhpExpectedFunctionArgument, PhpArrayShapeEntriesIndex.PhpArrayShapeEntry> visited = new LinkedHashMap<PhpExpectedFunctionArgument, PhpArrayShapeEntriesIndex.PhpArrayShapeEntry>();
            for (PhpArrayShapeEntriesIndex.PhpArrayShapeEntry shape : shapes) {
                PhpExpectedFunctionArgument key = shape.getKey();
                if (visited.containsKey(key)) {
                    visited.put(key, new PhpArrayShapeEntriesIndex.PhpArrayShapeEntry(key, PhpType.or((PhpType)shape.getType(), (PhpType)((PhpArrayShapeEntriesIndex.PhpArrayShapeEntry)visited.get(key)).getType())));
                    continue;
                }
                visited.put(key, shape);
            }
            return visited.values();
        }

        @NlsSafe
        private static String getArrayHashElement(PhpArrayShapeEntriesIndex.PhpArrayShapeEntry shape) {
            PhpExpectedFunctionArgument key = shape.getKey();
            String keyValue = key instanceof PhpExpectedFunctionClassConstantArgument ? PhpAddArrayShapeQuickFix.getConstantValue((PhpExpectedFunctionClassConstantArgument)key) : key.getValue();
            return String.format("%s => \"%s\"", keyValue, shape.getType().toString());
        }

        @NotNull
        private static String getConstantValue(PhpExpectedFunctionClassConstantArgument key) {
            String string = key.getClassFqn() + "::" + key.getConstantName();
            if (string == null) {
                PhpAddArrayShapeQuickFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/attributes/PhpArrayShapeAttributeCanBeAddedInspection$PhpAddArrayShapeQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/attributes/PhpArrayShapeAttributeCanBeAddedInspection$PhpAddArrayShapeQuickFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConstantValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PhpInferredArrayShapeRegistry
    extends PhpAttributesRegistryBase<PhpArrayShapeEntriesIndex.PhpArrayShapeEntry> {
        static final PhpInferredArrayShapeRegistry INSTANCE = new PhpInferredArrayShapeRegistry();
        private static final int TYPE_LIMIT = 3;

        private PhpInferredArrayShapeRegistry() {
        }

        @Override
        public List<PhpArrayShapeEntriesIndex.PhpArrayShapeEntry> getValues(@Nullable PsiElement element, boolean allowAmbiguity) {
            if (element instanceof ArrayCreationExpression) {
                return PhpInferredArrayShapeRegistry.getValues((ArrayCreationExpression)element);
            }
            return super.getValues(element, allowAmbiguity);
        }

        @Override
        protected Collection<PhpArrayShapeEntriesIndex.PhpArrayShapeEntry> collectValuesFromAssignments(final Variable element, PhpAccessVariableInstruction accessInstruction, final Ref<Boolean> ambiguous) {
            final Collection<PhpArrayShapeEntriesIndex.PhpArrayShapeEntry> entries = super.collectValuesFromAssignments(element, accessInstruction, ambiguous);
            if (((Boolean)ambiguous.get()).booleanValue()) {
                return Collections.emptyList();
            }
            PhpControlFlowUtil.processPredecessors((PhpInstruction)accessInstruction, false, new PhpInstructionProcessor(){

                public boolean processArrayAccessInstruction(PhpArrayAccessInstruction instruction) {
                    if (!PhpLangUtil.equalsVariableNames(instruction.getVariableName(), element.getName()) || !instruction.getAccess().isWrite()) {
                        return true;
                    }
                    PsiElement instructionKey = instruction.getKey();
                    if (PhpInferredArrayShapeRegistry.isInapplicableKey(instructionKey)) {
                        ambiguous.set((Object)true);
                        return false;
                    }
                    PhpExpectedFunctionArgument key = PhpExpectedFunctionArgumentsIndex.getExpectedArgument(instructionKey, 0, 0, null, false);
                    PhpType type = PhpInferredArrayShapeRegistry.getTypeForKey(PhpPsiUtil.getParentByCondition(instructionKey, (Condition<? super PsiElement>)ArrayAccessExpression.INSTANCEOF));
                    entries.add(new PhpArrayShapeEntriesIndex.PhpArrayShapeEntry(key, type));
                    return super.processArrayAccessInstruction(instruction);
                }
            });
            return entries;
        }

        private static boolean isInapplicableKey(PsiElement instructionKey) {
            return instructionKey == null || !PhpExpectedFunctionArgumentLookupElement.ELEMENT_CAN_BE_EXPECTED_ARGUMENT.value((Object)instructionKey) || instructionKey instanceof Variable || instructionKey instanceof FieldReference;
        }

        private static List<PhpArrayShapeEntriesIndex.PhpArrayShapeEntry> getValues(ArrayCreationExpression array) {
            Iterator iterator = ArrayCreationExpressionImpl.children(array).iterator();
            int i = 0;
            ArrayList<PhpArrayShapeEntriesIndex.PhpArrayShapeEntry> res = new ArrayList<PhpArrayShapeEntriesIndex.PhpArrayShapeEntry>();
            while (iterator.hasNext()) {
                PhpPsiElement child = (PhpPsiElement)iterator.next();
                if (child instanceof ArrayHashElement && PhpInferredArrayShapeRegistry.isInapplicableKey((PsiElement)((ArrayHashElement)child).getKey())) {
                    return Collections.emptyList();
                }
                PhpExpectedFunctionArgument key = PhpArrayShapeEntriesIndex.createArrayShapeKeyFromArrayChild(child, i);
                PhpPsiElement value = child instanceof ArrayHashElement ? ((ArrayHashElement)child).getValue() : child.getFirstPsiChild();
                res.add(new PhpArrayShapeEntriesIndex.PhpArrayShapeEntry(key, PhpInferredArrayShapeRegistry.getTypeForKey((PsiElement)value)));
                ++i;
            }
            return res;
        }

        private static PhpType getTypeForKey(@Nullable PsiElement value) {
            if (value == null) {
                return PhpType.MIXED;
            }
            PhpType type = new PhpType().add(value).global(value.getProject());
            return type.hasUnknown() || type.size() > 3 ? PhpType.MIXED : type;
        }

        @Override
        @NotNull
        protected List<PhpArrayShapeEntriesIndex.PhpArrayShapeEntry> getValuesFromAssignedValue(PsiElement value) {
            if (value instanceof ArrayCreationExpression) {
                List<PhpArrayShapeEntriesIndex.PhpArrayShapeEntry> list = PhpInferredArrayShapeRegistry.getValues((ArrayCreationExpression)value);
                if (list == null) {
                    PhpInferredArrayShapeRegistry.$$$reportNull$$$0(0);
                }
                return list;
            }
            List<PhpArrayShapeEntriesIndex.PhpArrayShapeEntry> list = super.getValuesFromAssignedValue(value);
            if (list == null) {
                PhpInferredArrayShapeRegistry.$$$reportNull$$$0(1);
            }
            return list;
        }

        @Override
        @NotNull
        protected List<PhpArrayShapeEntriesIndex.PhpArrayShapeEntry> getParameterValuesInner(@NotNull Function function, int argumentIndex) {
            if (function == null) {
                PhpInferredArrayShapeRegistry.$$$reportNull$$$0(2);
            }
            List<PhpArrayShapeEntriesIndex.PhpArrayShapeEntry> list = PhpArrayShapeRegistry.INSTANCE.getParameterValues(function, argumentIndex);
            if (list == null) {
                PhpInferredArrayShapeRegistry.$$$reportNull$$$0(3);
            }
            return list;
        }

        @Override
        @NotNull
        protected List<PhpArrayShapeEntriesIndex.PhpArrayShapeEntry> getValuesInner(Function function) {
            List<PhpArrayShapeEntriesIndex.PhpArrayShapeEntry> list = PhpArrayShapeRegistry.INSTANCE.getValues(function);
            if (list == null) {
                PhpInferredArrayShapeRegistry.$$$reportNull$$$0(4);
            }
            return list;
        }

        @Override
        @NotNull
        protected List<PhpArrayShapeEntriesIndex.PhpArrayShapeEntry> getValues(Field field) {
            List<PhpArrayShapeEntriesIndex.PhpArrayShapeEntry> list = PhpArrayShapeRegistry.INSTANCE.getValues(field);
            if (list == null) {
                PhpInferredArrayShapeRegistry.$$$reportNull$$$0(5);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/attributes/PhpArrayShapeAttributeCanBeAddedInspection$PhpInferredArrayShapeRegistry";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "function";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValuesFromAssignedValue";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/attributes/PhpArrayShapeAttributeCanBeAddedInspection$PhpInferredArrayShapeRegistry";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getParameterValuesInner";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValuesInner";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValues";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getParameterValuesInner";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

