/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.attributes;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.PhpAttribute;
import com.jetbrains.php.lang.psi.elements.PhpAttributesList;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.refactoring.move.member.PhpMoveMemberProcessor;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class PhpAddAttributeQuickFixBase
implements LocalQuickFix {
    private final String myAttributeFQN;

    protected PhpAddAttributeQuickFixBase(String attributeFQN) {
        this.myAttributeFQN = attributeFQN;
    }

    @IntentionFamilyName
    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("intention.family.name.add.attribute", PhpLangUtil.toShortName(this.myAttributeFQN));
        if (string == null) {
            PhpAddAttributeQuickFixBase.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        Object function;
        if (project == null) {
            PhpAddAttributeQuickFixBase.$$$reportNull$$$0(1);
        }
        if (descriptor == null) {
            PhpAddAttributeQuickFixBase.$$$reportNull$$$0(2);
        }
        if ((function = PhpPsiUtil.getParentByCondition(descriptor.getStartElement(), false, (Condition<? super PsiElement>)Function.INSTANCEOF)) == null) {
            return;
        }
        PhpAttributesList attributesList = PhpPsiElementFactory.createAttributesList(project, this.myAttributeFQN);
        PhpAttributesList addedAttribute = (PhpAttributesList)function.addBefore((PsiElement)attributesList, function.getFirstChild());
        this.importClassReference(project, addedAttribute);
    }

    private void importClassReference(@NotNull Project project, PhpAttributesList attribute) {
        if (project == null) {
            PhpAddAttributeQuickFixBase.$$$reportNull$$$0(3);
        }
        ClassReference attributeReference = ((PhpAttribute)ContainerUtil.getFirstItem((Collection)attribute.getAttributes())).getClassReference();
        assert (attributeReference != null);
        String qualifiedName = PhpMoveMemberProcessor.importClassAndGetName((PhpPsiElement)attributeReference, Collections.emptyList(), this.myAttributeFQN);
        attributeReference.replace((PsiElement)PhpPsiElementFactory.createClassReference(project, qualifiedName));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/attributes/PhpAddAttributeQuickFixBase";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/attributes/PhpAddAttributeQuickFixBase";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "importClassReference";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

