/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.impl.FunctionImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.PropertyKey;

public class PhpVoidFunctionResultUsedInspection
extends PhpInspection {
    public static final String PROBLEM_1_DESCRIPTION = "inspection.void.function.result.used.problem1";
    public static final String PROBLEM_2_DESCRIPTION = "inspection.void.function.result.used.problem2";

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpVoidFunctionResultUsedInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpFunctionCall(FunctionReference reference) {
                PhpVoidFunctionResultUsedInspection.analyzeCall(reference, holder, PhpVoidFunctionResultUsedInspection.PROBLEM_1_DESCRIPTION);
            }

            public void visitPhpMethodReference(MethodReference reference) {
                if (PhpPsiUtil.isOfType(reference.getParent(), PhpStubElementTypes.TRAIT_USE_RULE)) {
                    return;
                }
                PhpVoidFunctionResultUsedInspection.analyzeCall((FunctionReference)reference, holder, PhpVoidFunctionResultUsedInspection.PROBLEM_2_DESCRIPTION);
            }
        };
    }

    private static void analyzeCall(@NotNull FunctionReference reference, @NotNull ProblemsHolder holder, @PropertyKey(resourceBundle="messages.PhpBundle") @NotNull @PropertyKey(resourceBundle="messages.PhpBundle") @NotNull String problemDescription) {
        PhpType functionType;
        String name;
        if (reference == null) {
            PhpVoidFunctionResultUsedInspection.$$$reportNull$$$0(1);
        }
        if (holder == null) {
            PhpVoidFunctionResultUsedInspection.$$$reportNull$$$0(2);
        }
        if (problemDescription == null) {
            PhpVoidFunctionResultUsedInspection.$$$reportNull$$$0(3);
        }
        if (!StringUtil.isEmptyOrSpaces((String)(name = reference.getName())) && PhpType.VOID.equals((Object)(functionType = reference.getGlobalType()))) {
            PsiElement parent = reference.getParent();
            if (parent instanceof BinaryExpression) {
                BinaryExpression binaryExpression = (BinaryExpression)parent;
                PsiElement rightOperand = binaryExpression.getRightOperand();
                if (rightOperand == reference && PhpLangUtil.isShortCircuitOperator(binaryExpression.getOperationType()) && PhpCodeInsightUtil.isResultUsed(parent)) {
                    holder.registerProblem((PsiElement)reference, PhpBundle.message(problemDescription, name), new LocalQuickFix[0]);
                }
            } else if (PhpCodeInsightUtil.isResultUsed((PsiElement)reference)) {
                if (parent instanceof FunctionImpl && FunctionImpl.isShortArrowFunction((Function)parent) && FunctionImpl.getShortArrowFunctionArgument((Function)parent) == reference) {
                    return;
                }
                holder.registerProblem((PsiElement)reference, PhpBundle.message(problemDescription, name), new LocalQuickFix[0]);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemDescription";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpVoidFunctionResultUsedInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "analyzeCall";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

