/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.impl.ParameterListImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpUseListImpl;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpUselessTrailingCommaInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpUselessTrailingCommaInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpParameterList(ParameterList list) {
                boolean hasTrailingComma = ((ParameterListImpl)list).hasTrailingComma();
                if (!hasTrailingComma || !PhpUselessTrailingCommaInspection.isSupportTrailingComma(list)) {
                    return;
                }
                PsiElement trailingComma = list.getLastChild();
                PsiElement nextSibling = PhpUselessTrailingCommaInspection.getNextSiblingIgnoreComments((PsiElement)list);
                boolean isMultilineParameterList = StringUtil.containsLineBreak((CharSequence)list.getText());
                this.registerTrailingCommaProblem(trailingComma, nextSibling, isMultilineParameterList);
                super.visitPhpParameterList(list);
            }

            public void visitPhpFunction(Function function) {
                super.visitPhpFunction(function);
                if (!function.isClosure() || !PhpLanguageFeature.TRAILING_COMMA_IN_CLOSURE_USE_LIST.isSupported(function.getProject())) {
                    return;
                }
                PhpUseList useList = (PhpUseList)PsiTreeUtil.getChildOfType((PsiElement)function, PhpUseList.class);
                if (useList == null) {
                    return;
                }
                PsiElement trailingComma = PhpUseListImpl.getTrailingComma(useList);
                if (trailingComma == null) {
                    return;
                }
                PsiElement nextSibling = PhpUselessTrailingCommaInspection.getNextSiblingIgnoreComments(trailingComma);
                this.registerTrailingCommaProblem(trailingComma, nextSibling, this.isMultilineUseList(useList, trailingComma));
            }

            private boolean isMultilineUseList(@NotNull PhpUseList useList, @NotNull PsiElement trailingComma) {
                PsiElement brackets;
                if (useList == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (trailingComma == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((brackets = PhpPsiUtil.getChildOfType((PsiElement)useList, PhpTokenTypes.chLPAREN)) == null) {
                    return false;
                }
                Ref result = new Ref((Object)false);
                PsiTreeUtil.processElements((PsiElement)useList, e -> {
                    if (e.getTextOffset() > brackets.getTextOffset() && e.getTextOffset() < trailingComma.getTextOffset() && StringUtil.containsLineBreak((CharSequence)e.getText())) {
                        result.set((Object)true);
                        return false;
                    }
                    return true;
                });
                return (Boolean)result.get();
            }

            private void registerTrailingCommaProblem(@NotNull PsiElement trailingComma, @Nullable PsiElement nextSibling, boolean isMultiline) {
                if (trailingComma == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (nextSibling instanceof PsiWhiteSpace && StringUtil.containsLineBreak((CharSequence)nextSibling.getText())) {
                    return;
                }
                if (isMultiline) {
                    holder.registerProblem(trailingComma, PhpBundle.message("inspection.php.useless.trailing.comma.inspection.desc", new Object[0]), new LocalQuickFix[]{AddLineBreakAfterTrailingCommaQuickFix.INSTANCE});
                } else {
                    holder.registerProblem(trailingComma, PhpBundle.message("inspection.php.useless.trailing.comma.inspection.desc", new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{RemoveTrailingCommaQuickFix.INSTANCE});
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "useList";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "trailingComma";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpUselessTrailingCommaInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isMultilineUseList";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "registerTrailingCommaProblem";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Nullable
    private static PsiElement getNextSiblingIgnoreComments(PsiElement list) {
        return PhpPsiUtil.getNextSiblingByCondition(list, (Condition<? super PsiElement>)((Condition)e -> !(e instanceof PsiComment)));
    }

    private static boolean isSupportTrailingComma(@NotNull ParameterList list) {
        if (list == null) {
            PhpUselessTrailingCommaInspection.$$$reportNull$$$0(1);
        }
        PsiElement parent = list.getParent();
        Project project = list.getProject();
        if (parent instanceof Function && PhpLanguageFeature.TRAILING_COMMA_IN_PARAMETER_LIST.isSupported(project)) {
            return true;
        }
        return parent instanceof FunctionReference && PhpLanguageFeature.TRAILING_COMMA_IN_FUNCTION_CALL.isSupported(project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpUselessTrailingCommaInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isSupportTrailingComma";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class AddLineBreakAfterTrailingCommaQuickFix
    implements LocalQuickFix {
        public static final AddLineBreakAfterTrailingCommaQuickFix INSTANCE = new AddLineBreakAfterTrailingCommaQuickFix();

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("inspection.php.add.line.break.after.trailing.comma", new Object[0]);
            if (string == null) {
                AddLineBreakAfterTrailingCommaQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element;
            if (project == null) {
                AddLineBreakAfterTrailingCommaQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                AddLineBreakAfterTrailingCommaQuickFix.$$$reportNull$$$0(2);
            }
            if ((element = descriptor.getPsiElement()) == null || element.getParent() == null) {
                return;
            }
            element.getParent().addAfter((PsiElement)PhpPsiElementFactory.createNewLine(element.getProject()), element);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpUselessTrailingCommaInspection$AddLineBreakAfterTrailingCommaQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpUselessTrailingCommaInspection$AddLineBreakAfterTrailingCommaQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class RemoveTrailingCommaQuickFix
    implements LocalQuickFix {
        public static final RemoveTrailingCommaQuickFix INSTANCE = new RemoveTrailingCommaQuickFix();

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("inspection.php.remove.useless.trailing.comma", new Object[0]);
            if (string == null) {
                RemoveTrailingCommaQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element;
            if (project == null) {
                RemoveTrailingCommaQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                RemoveTrailingCommaQuickFix.$$$reportNull$$$0(2);
            }
            if ((element = descriptor.getPsiElement()) == null) {
                return;
            }
            element.delete();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpUselessTrailingCommaInspection$RemoveTrailingCommaQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpUselessTrailingCommaInspection$RemoveTrailingCommaQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

