/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.CommonProcessors;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.refactoring.PhpMoveClassMemberBase;
import org.jetbrains.annotations.NotNull;

public class PhpUnusedPrivateFieldInspection
extends PhpInspection {
    private static final PhpRemoveFieldQuickFix FIX = new PhpRemoveFieldQuickFix();

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpUnusedPrivateFieldInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpField(Field field) {
                PsiElement namePsiElement = field.getNameIdentifier();
                if (namePsiElement == null) {
                    return;
                }
                if (field.getModifier().isPrivate()) {
                    PhpClass containingClass = field.getContainingClass();
                    if (containingClass == null || containingClass.isTrait() || containingClass.hasTraitUses()) {
                        return;
                    }
                    if (!PhpUnusedPrivateFieldInspection.isFieldUsed(field)) {
                        holder.registerProblem(namePsiElement, PhpBundle.message("inspection.message.unused.private.property.ref", new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{FIX});
                    }
                }
            }
        };
    }

    private static boolean isFieldUsed(@NotNull Field field) {
        if (field == null) {
            PhpUnusedPrivateFieldInspection.$$$reportNull$$$0(1);
        }
        return PhpUnusedPrivateFieldInspection.isFieldUsed(field, new CommonProcessors.FindProcessor<PsiReference>(){

            protected boolean accept(PsiReference reference) {
                return true;
            }
        });
    }

    public static boolean isFieldUsed(@NotNull Field field, CommonProcessors.FindProcessor<PsiReference> finder) {
        PhpClass containingClass;
        if (field == null) {
            PhpUnusedPrivateFieldInspection.$$$reportNull$$$0(2);
        }
        if ((containingClass = field.getContainingClass()) == null || containingClass.isTrait() || containingClass.hasTraitUses()) {
            return true;
        }
        return PhpPsiUtil.hasReferencesInSearchScope((SearchScope)new LocalSearchScope((PsiElement)containingClass), (PsiElement)field, finder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpUnusedPrivateFieldInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isFieldUsed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class PhpRemoveFieldQuickFix
    implements LocalQuickFix {
        private PhpRemoveFieldQuickFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.remove.unused.property", new Object[0]);
            if (string == null) {
                PhpRemoveFieldQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            Field field;
            if (project == null) {
                PhpRemoveFieldQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                PhpRemoveFieldQuickFix.$$$reportNull$$$0(2);
            }
            if ((field = (Field)PhpPsiUtil.getParentByCondition(descriptor.getStartElement(), false, (Condition<? super PsiElement>)Field.INSTANCEOF)) == null) {
                return;
            }
            PhpMoveClassMemberBase.removeFieldWithPhpDoc(field);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpUnusedPrivateFieldInspection$PhpRemoveFieldQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpUnusedPrivateFieldInspection$PhpRemoveFieldQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

