/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeAnalyserVisitor;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PhpUnusedFieldDefaultValueInspection
extends PhpInspection {
    @Nls
    public static final String FIX_NAME = PhpBundle.message("remove.redundant.initializer", new Object[0]);

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpUnusedFieldDefaultValueInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpField(Field field) {
                PsiElement defaultValue = field.getDefaultValue();
                if (defaultValue == null || !PhpTypeAnalyserVisitor.fieldAssignmentAlwaysReachable(field)) {
                    return;
                }
                PsiElement identifier = field.getNameIdentifier();
                if (identifier == null) {
                    return;
                }
                TextRange range = TextRange.create((int)identifier.getTextRangeInParent().getEndOffset(), (int)defaultValue.getTextRangeInParent().getEndOffset());
                holder.registerProblem((PsiElement)field, PhpBundle.message("inspection.php.unused.field.default.value.description", new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, range, new LocalQuickFix[]{PhpRemoveFieldDefaultValueQuickFix.INSTANCE});
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/PhpUnusedFieldDefaultValueInspection", "buildVisitor"));
    }

    private static class PhpRemoveFieldDefaultValueQuickFix
    implements LocalQuickFix {
        private static final LocalQuickFix INSTANCE = new PhpRemoveFieldDefaultValueQuickFix();

        private PhpRemoveFieldDefaultValueQuickFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = FIX_NAME;
            if (string == null) {
                PhpRemoveFieldDefaultValueQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            Field field;
            if (project == null) {
                PhpRemoveFieldDefaultValueQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                PhpRemoveFieldDefaultValueQuickFix.$$$reportNull$$$0(2);
            }
            if ((field = (Field)PhpPsiUtil.getParentByCondition(descriptor.getStartElement(), false, (Condition<? super PsiElement>)Field.INSTANCEOF)) == null) {
                return;
            }
            field.replace(this.createFieldWithoutDefaultValue(project, field));
        }

        @NotNull
        public PsiElement createFieldWithoutDefaultValue(@NotNull Project project, Field field) {
            if (project == null) {
                PhpRemoveFieldDefaultValueQuickFix.$$$reportNull$$$0(3);
            }
            PhpPsiElement classFields = PhpPsiElementFactory.createClassField(project, field.getModifier(), field.getName(), null, null);
            PsiElement fieldWithoutDefaultValue = PhpPsiUtil.getChildOfType((PsiElement)classFields, PhpStubElementTypes.CLASS_FIELD);
            assert (fieldWithoutDefaultValue != null);
            PsiElement psiElement = fieldWithoutDefaultValue;
            if (psiElement == null) {
                PhpRemoveFieldDefaultValueQuickFix.$$$reportNull$$$0(4);
            }
            return psiElement;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpUnusedFieldDefaultValueInspection$PhpRemoveFieldDefaultValueQuickFix";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpUnusedFieldDefaultValueInspection$PhpRemoveFieldDefaultValueQuickFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createFieldWithoutDefaultValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createFieldWithoutDefaultValue";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

