/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.quickfix.PhpRemoveStatementQuickFix;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;

public class PhpUnusedAliasInspection
extends PhpInspection {
    private static final LocalQuickFix[] FIXES = new LocalQuickFix[]{PhpRemoveStatementQuickFix.REMOVE_USE};

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpUnusedAliasInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpUse(PhpUse use) {
                if (PhpCodeInsightUtil.isUnused(use)) {
                    holder.registerProblem((PsiElement)use, PhpBundle.message("inspection.php.unused.alias.description2", new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, FIXES);
                } else if (PhpCodeInsightUtil.isUnnecessary(use)) {
                    holder.registerProblem((PsiElement)use, PhpBundle.message("inspection.php.unused.alias.description", new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, FIXES);
                }
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/PhpUnusedAliasInspection", "buildVisitor"));
    }
}

