/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.DynamicBundle;
import com.intellij.application.options.CodeStyle;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.completion.insert.PhpReferenceInsertHandler;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.formatter.PhpCodeStyleSettings;
import com.jetbrains.php.lang.inspections.PhpFqnInspectionBase;
import com.jetbrains.php.lang.inspections.PhpFullyQualifiedNameUsageInspection;
import com.jetbrains.php.lang.inspections.quickfix.PhpQuickFixBase;
import com.jetbrains.php.lang.intentions.PhpImportClassIntention;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpGroupUseElement;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpNamespaceReference;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.lang.psi.visitors.PhpRecursiveElementVisitor;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.HashSet;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import one.util.streamex.EntryStream;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpUnnecessaryFullyQualifiedNameInspection
extends PhpFqnInspectionBase
implements CleanupLocalInspectionTool {
    private static final PhpRemoveRedundantQualifierQuickFix FIX_ON_NAMESPACE = new PhpRemoveRedundantQualifierQuickFix(PhpUnnecessaryFullyQualifiedNameInspection.getFixName());
    private static final PhpRemoveRedundantQualifierQuickFix FIX_ON_CLASSNAME = new PhpRemoveRedundantQualifierQuickFix(PhpBundle.message("quickfix.remove.unnecessary.qualifier.on.class.name", new Object[0]));
    private static final Key<PhpUnnecessaryFullyQualifiedNameInspection> SHORT_NAME_KEY = Key.create((String)"PhpUnnecessaryFullyQualifiedNameInspection");

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpUnnecessaryFullyQualifiedNameInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpClassReference(ClassReference reference) {
                this.check(PhpPsiUtil.getClassReferenceAt((PsiElement)reference), PhpGroupUseElement.PhpUseKeyword.CLASS);
            }

            public void visitPhpFunctionCall(FunctionReference reference) {
                this.check(PhpPsiUtil.getClassReferenceAt((PsiElement)reference), PhpGroupUseElement.PhpUseKeyword.FUNCTION);
            }

            public void visitPhpConstantReference(ConstantReference reference) {
                this.check(PhpPsiUtil.getClassReferenceAt((PsiElement)reference), PhpGroupUseElement.PhpUseKeyword.CONSTANT);
            }

            public void visitPhpDocType(PhpDocType type) {
                PhpReference reference;
                String simplifiedFqn;
                if (!PhpUnnecessaryFullyQualifiedNameInspection.phpdocUseFqcn(type) && (simplifiedFqn = PhpUnnecessaryFullyQualifiedNameInspection.this.createSimplifiedFQN(reference = PhpPsiUtil.getClassReferenceAt((PsiElement)type), PhpGroupUseElement.PhpUseKeyword.CLASS)) != null) {
                    this.registerWarning(reference, simplifiedFqn, isOnTheFly);
                }
            }

            public void check(@Nullable PhpReference reference, PhpGroupUseElement.PhpUseKeyword keyword) {
                String simplifiedFqn = PhpUnnecessaryFullyQualifiedNameInspection.this.createSimplifiedFQN(reference, keyword);
                if (simplifiedFqn != null) {
                    this.registerWarning(reference, simplifiedFqn, isOnTheFly);
                }
            }

            private void registerWarning(@NotNull PhpReference reference, String simplifiedFqn, boolean isOnTheFly2) {
                Object namespaceReference;
                if (reference == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((namespaceReference = PhpPsiUtil.getChildByCondition((PsiElement)reference, (Condition<? super PsiElement>)PhpNamespaceReference.INSTANCEOF)) != null) {
                    TextRange unnecessaryQualifierRange;
                    String parentNamespace = PhpLangUtil.getParentNamespaceFQN(PhpLangUtil.toFQN(simplifiedFqn));
                    TextRange textRange = unnecessaryQualifierRange = PhpFullyQualifiedNameUsageInspection.isShortName(simplifiedFqn) ? null : TextRange.create((int)0, (int)(namespaceReference.getTextLength() - parentNamespace.length() + 1));
                    if (unnecessaryQualifierRange == null || !unnecessaryQualifierRange.isEmpty()) {
                        ProblemHighlightType type = PhpFullyQualifiedNameUsageInspection.getHighlightType(reference);
                        if (type == ProblemHighlightType.INFORMATION && !isOnTheFly2) {
                            return;
                        }
                        holder.registerProblem(namespaceReference, PhpBundle.message("inspection.unnecessary.qualifier.already.imported.message", new Object[0]), type, unnecessaryQualifierRange, PhpUnnecessaryFullyQualifiedNameInspection.this.getQuickFixes(reference, FIX_ON_NAMESPACE));
                        ASTNode nameNode = reference.getNameNode();
                        if (nameNode != null && isOnTheFly2) {
                            TextRange range = new TextRange(1, nameNode.getTextLength());
                            holder.registerProblem(nameNode.getPsi(), PhpBundle.message("inspection.unnecessary.qualifier.already.imported.message", new Object[0]), ProblemHighlightType.INFORMATION, range, PhpUnnecessaryFullyQualifiedNameInspection.this.getQuickFixes(reference, FIX_ON_CLASSNAME));
                        }
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/jetbrains/php/lang/inspections/PhpUnnecessaryFullyQualifiedNameInspection$1", "registerWarning"));
            }
        };
    }

    @Override
    @NotNull
    protected Key<? extends PhpFqnInspectionBase> getShortNameKey() {
        Key<PhpUnnecessaryFullyQualifiedNameInspection> key = SHORT_NAME_KEY;
        if (key == null) {
            PhpUnnecessaryFullyQualifiedNameInspection.$$$reportNull$$$0(1);
        }
        return key;
    }

    public static boolean phpdocUseFqcn(@NotNull PhpDocType type) {
        if (type == null) {
            PhpUnnecessaryFullyQualifiedNameInspection.$$$reportNull$$$0(2);
        }
        return ((PhpCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)type.getContainingFile(), PhpCodeStyleSettings.class)).PHPDOC_USE_FQCN;
    }

    @Nullable
    private String createSimplifiedFQN(@Nullable PhpReference reference, PhpGroupUseElement.PhpUseKeyword keyword) {
        if (reference == null || !PhpImportClassIntention.canBeImported(reference)) {
            return null;
        }
        String fqn = reference.getFQN();
        if (fqn == null) {
            return null;
        }
        if (StringUtil.isEmpty((String)PhpLangUtil.toShortName(fqn))) {
            return null;
        }
        if (PhpUnnecessaryFullyQualifiedNameInspection.isGlobalNamespaceFqn(fqn) && this.IGNORE_GLOBAL_NAMESPACE) {
            return null;
        }
        if (PhpUnnecessaryFullyQualifiedNameInspection.inCoversDefaultClassTag(reference)) {
            return null;
        }
        PhpPsiElement scope = PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)reference);
        if (!(scope instanceof PhpNamespace || this.ENABLE_IN_FILE_SCOPE && scope instanceof PhpFile)) {
            return null;
        }
        String simplifiedFqn = PhpUnnecessaryFullyQualifiedNameInspection.createSimplifiedFqn(reference, scope);
        if (simplifiedFqn == null || PhpLangUtil.isFqn(simplifiedFqn)) {
            return null;
        }
        Map<String, String> usedAliases = PhpUnnecessaryFullyQualifiedNameInspection.collectAliasesExceptFqn(scope, fqn, keyword);
        if (PhpUnnecessaryFullyQualifiedNameInspection.hasPartialNameConflicts(simplifiedFqn, usedAliases, fqn)) {
            return null;
        }
        if (PhpFullyQualifiedNameUsageInspection.isShortName(simplifiedFqn) != usedAliases.containsKey(StringUtil.toLowerCase((String)PhpLangUtil.toShortName(simplifiedFqn)))) {
            if (keyword == PhpGroupUseElement.PhpUseKeyword.CLASS && (StringUtil.isEmpty((String)simplifiedFqn) || PhpReferenceInsertHandler.SPECIAL_REFERENCES.contains(simplifiedFqn))) {
                return null;
            }
            return simplifiedFqn;
        }
        return null;
    }

    private static boolean hasPartialNameConflicts(String simplifiedFqn, Map<String, String> usedAliases, String originalFQN) {
        String partialNamespaceStart;
        int index = simplifiedFqn.indexOf(92);
        if (index >= 0 && (partialNamespaceStart = usedAliases.get(StringUtil.toLowerCase((String)simplifiedFqn.substring(0, index)))) != null) {
            String importedFQN = partialNamespaceStart + simplifiedFqn.substring(index);
            return !PhpLangUtil.equalsClassNames(importedFQN, originalFQN);
        }
        return false;
    }

    public static boolean inCoversDefaultClassTag(@NotNull PhpReference reference) {
        PhpDocTag docTag;
        if (reference == null) {
            PhpUnnecessaryFullyQualifiedNameInspection.$$$reportNull$$$0(3);
        }
        return (docTag = (PhpDocTag)PhpPsiUtil.getParentByCondition((PsiElement)reference, (Condition<? super PsiElement>)PhpDocTag.INSTANCEOF)) != null && StringUtil.equals((CharSequence)docTag.getName(), (CharSequence)"@coversDefaultClass");
    }

    @Nullable
    public static String createSimplifiedFqn(@NotNull PhpReference reference, PhpPsiElement scopeForUseOperator) {
        String immediateFQN;
        if (reference == null) {
            PhpUnnecessaryFullyQualifiedNameInspection.$$$reportNull$$$0(4);
        }
        return (immediateFQN = PhpCodeInsightUtil.getImmediateFQN(reference)) != null && PhpLangUtil.isFqn(immediateFQN) ? PhpCodeInsightUtil.createQualifiedName(scopeForUseOperator, immediateFQN) : null;
    }

    @NotNull
    public static Map<String, String> collectAliasesExceptFqn(PhpPsiElement scopeForUseOperator, String fqn, PhpGroupUseElement.PhpUseKeyword keyword) {
        Map map = EntryStream.of(PhpCodeInsightUtil.getAliasesInScope(scopeForUseOperator, keyword)).filterValues(aliasFQN -> !aliasFQN.equals(fqn)).mapKeys(StringUtil::toLowerCase).toMap();
        if (map == null) {
            PhpUnnecessaryFullyQualifiedNameInspection.$$$reportNull$$$0(5);
        }
        return map;
    }

    @Override
    public JComponent createOptionsPanel() {
        return new OptionsPanel().getComponent();
    }

    @Nls
    public static String getFixName() {
        return PhpBundle.message("quickfix.remove.unnecessary.qualifier", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpUnnecessaryFullyQualifiedNameInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpUnnecessaryFullyQualifiedNameInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortNameKey";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "collectAliasesExceptFqn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "phpdocUseFqcn";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "inCoversDefaultClassTag";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createSimplifiedFqn";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class OptionsPanel {
        private JPanel myMainPanel;
        private JBCheckBox myEnableFileScopeCheckBox;
        private JBCheckBox myIgnoreGlobalNamespaceCheckBox;

        public OptionsPanel() {
            this.$$$setupUI$$$();
            this.myEnableFileScopeCheckBox.setSelected(PhpUnnecessaryFullyQualifiedNameInspection.this.ENABLE_IN_FILE_SCOPE);
            this.myEnableFileScopeCheckBox.getModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PhpUnnecessaryFullyQualifiedNameInspection.this.ENABLE_IN_FILE_SCOPE = OptionsPanel.this.myEnableFileScopeCheckBox.isSelected();
                }
            });
            this.myIgnoreGlobalNamespaceCheckBox.setSelected(PhpUnnecessaryFullyQualifiedNameInspection.this.IGNORE_GLOBAL_NAMESPACE);
            this.myIgnoreGlobalNamespaceCheckBox.getModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PhpUnnecessaryFullyQualifiedNameInspection.this.IGNORE_GLOBAL_NAMESPACE = OptionsPanel.this.myIgnoreGlobalNamespaceCheckBox.isSelected();
                }
            });
        }

        public JPanel getComponent() {
            return this.myMainPanel;
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JBCheckBox jBCheckBox;
            JBCheckBox jBCheckBox2;
            JPanel jPanel;
            this.myMainPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            this.myEnableFileScopeCheckBox = jBCheckBox2 = new JBCheckBox();
            jBCheckBox2.setSelected(false);
            this.$$$loadButtonText$$$((AbstractButton)jBCheckBox2, DynamicBundle.getBundle((String)"messages/PhpBundle", OptionsPanel.class).getString("inspection.unnecessary.fully.qualified.name.option.enable.file.scope"));
            jPanel.add((Component)jBCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
            this.myIgnoreGlobalNamespaceCheckBox = jBCheckBox = new JBCheckBox();
            this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/PhpBundle", OptionsPanel.class).getString("inspection.unnecessary.fully.qualified.name.option.ignore.global.namespace"));
            jPanel.add((Component)jBCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myMainPanel;
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }

    private static final class PhpRemoveRedundantQualifierQuickFix
    extends PhpQuickFixBase {
        @Nls
        private final String myName;

        private PhpRemoveRedundantQualifierQuickFix(@Nls String name) {
            this.myName = name;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = this.myName;
            if (string == null) {
                PhpRemoveRedundantQualifierQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PhpReference reference;
            if (project == null) {
                PhpRemoveRedundantQualifierQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                PhpRemoveRedundantQualifierQuickFix.$$$reportNull$$$0(2);
            }
            if ((reference = PhpPsiUtil.getClassReferenceAt(descriptor.getPsiElement())) == null) {
                return;
            }
            String fqn = PhpCodeInsightUtil.getImmediateFQN(reference);
            if (fqn == null || !PhpLangUtil.isFqn(fqn)) {
                return;
            }
            PhpPsiElement scopeForUseOperator = PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)reference);
            if (scopeForUseOperator == null) {
                return;
            }
            if (reference instanceof ConstantReference) {
                this.replaceConstantReference(project, scopeForUseOperator, fqn);
            } else if (reference instanceof FunctionReference) {
                this.replaceFunctionReference(project, scopeForUseOperator, fqn);
            } else {
                PhpRemoveRedundantQualifierQuickFix.replaceClassReference(scopeForUseOperator, fqn);
            }
        }

        private void replaceConstantReference(@NotNull Project project, @NotNull PhpPsiElement scopeForUseOperator, final @NotNull String originalFqn) {
            if (project == null) {
                PhpRemoveRedundantQualifierQuickFix.$$$reportNull$$$0(3);
            }
            if (scopeForUseOperator == null) {
                PhpRemoveRedundantQualifierQuickFix.$$$reportNull$$$0(4);
            }
            if (originalFqn == null) {
                PhpRemoveRedundantQualifierQuickFix.$$$reportNull$$$0(5);
            }
            final HashSet references = new HashSet();
            scopeForUseOperator.acceptChildren((PsiElementVisitor)new PhpReferenceInScopeCollector(){

                public void visitPhpConstantReference(ConstantReference reference) {
                    if (PhpLangUtil.equalsClassNames(originalFqn, PhpCodeInsightUtil.getImmediateFQN((PhpReference)reference))) {
                        references.add(reference);
                    }
                }
            });
            String qualifiedName = PhpCodeInsightUtil.createQualifiedName(scopeForUseOperator, originalFqn);
            ConstantReference newConstantReference = PhpPsiElementFactory.createConstantReference(project, qualifiedName);
            CommandProcessor.getInstance().executeCommand(project, () -> ApplicationManager.getApplication().runWriteAction(() -> {
                for (PhpReference reference : references) {
                    reference.replace((PsiElement)newConstantReference);
                }
            }), this.getFamilyName(), null);
        }

        private void replaceFunctionReference(@NotNull Project project, @NotNull PhpPsiElement scopeForUseOperator, final @NotNull String originalFqn) {
            if (project == null) {
                PhpRemoveRedundantQualifierQuickFix.$$$reportNull$$$0(6);
            }
            if (scopeForUseOperator == null) {
                PhpRemoveRedundantQualifierQuickFix.$$$reportNull$$$0(7);
            }
            if (originalFqn == null) {
                PhpRemoveRedundantQualifierQuickFix.$$$reportNull$$$0(8);
            }
            final HashSet references = new HashSet();
            scopeForUseOperator.acceptChildren((PsiElementVisitor)new PhpReferenceInScopeCollector(){

                public void visitPhpFunctionCall(FunctionReference reference) {
                    super.visitPhpFunctionCall(reference);
                    if (PhpLangUtil.equalsClassNames(originalFqn, PhpCodeInsightUtil.getImmediateFQN((PhpReference)reference))) {
                        references.add(reference);
                    }
                }
            });
            String qualifiedName = PhpCodeInsightUtil.createQualifiedName(scopeForUseOperator, originalFqn);
            FunctionReference functionReference = PhpPsiElementFactory.createFunctionReference(project, qualifiedName + "()");
            PhpNamespaceReference newNamespaceReference = (PhpNamespaceReference)PhpPsiUtil.getChildByCondition((PsiElement)functionReference, (Condition<? super PsiElement>)PhpNamespaceReference.INSTANCEOF);
            PsiElement newIdentifier = PhpPsiUtil.getChildOfType((PsiElement)functionReference, PhpTokenTypes.IDENTIFIER);
            assert (newIdentifier != null) : "Failed to find identifier in '" + functionReference.getText() + "'";
            CommandProcessor.getInstance().executeCommand(project, () -> ApplicationManager.getApplication().runWriteAction(() -> {
                for (FunctionReference reference : references) {
                    PsiElement identifier = PhpPsiUtil.getChildOfType((PsiElement)reference, PhpTokenTypes.IDENTIFIER);
                    Object namespaceReference = PhpPsiUtil.getChildByCondition((PsiElement)reference, (Condition<? super PsiElement>)PhpNamespaceReference.INSTANCEOF);
                    if (namespaceReference != null) {
                        if (newNamespaceReference == null) {
                            namespaceReference.getParent().deleteChildRange(namespaceReference, namespaceReference);
                        } else {
                            namespaceReference.replace((PsiElement)newNamespaceReference);
                        }
                    }
                    assert (identifier != null) : "Failed to find identifier in '" + reference.getText() + "'";
                    identifier.replace(newIdentifier);
                }
            }), this.getFamilyName(), null);
        }

        private static void replaceClassReference(@NotNull PhpPsiElement scopeForUseOperator, final @NotNull String originalFqn) {
            if (scopeForUseOperator == null) {
                PhpRemoveRedundantQualifierQuickFix.$$$reportNull$$$0(9);
            }
            if (originalFqn == null) {
                PhpRemoveRedundantQualifierQuickFix.$$$reportNull$$$0(10);
            }
            final HashSet references = new HashSet();
            scopeForUseOperator.acceptChildren((PsiElementVisitor)new PhpReferenceInScopeCollector(){

                public void visitPhpDocType(PhpDocType phpDocType) {
                    super.visitPhpDocType(phpDocType);
                    if (PhpLangUtil.equalsClassNames(originalFqn, PhpCodeInsightUtil.getImmediateFQN((PhpReference)phpDocType)) && !PhpUnnecessaryFullyQualifiedNameInspection.phpdocUseFqcn(phpDocType)) {
                        references.add(phpDocType);
                    }
                }

                public void visitPhpClassReference(ClassReference classReference) {
                    if (PhpLangUtil.equalsClassNames(originalFqn, PhpCodeInsightUtil.getImmediateFQN((PhpReference)classReference))) {
                        references.add(classReference);
                    }
                }
            });
            String qualifiedName = PhpCodeInsightUtil.createQualifiedName(scopeForUseOperator, originalFqn);
            ApplicationManager.getApplication().runWriteAction(() -> {
                for (PhpPsiElement reference : references) {
                    PhpImportClassIntention.replaceClassReference(reference, qualifiedName);
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpUnnecessaryFullyQualifiedNameInspection$PhpRemoveRedundantQualifierQuickFix";
                    break;
                }
                case 1: 
                case 3: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 4: 
                case 7: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scopeForUseOperator";
                    break;
                }
                case 5: 
                case 8: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "originalFqn";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpUnnecessaryFullyQualifiedNameInspection$PhpRemoveRedundantQualifierQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "replaceConstantReference";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "replaceFunctionReference";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "replaceClassReference";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static class PhpReferenceInScopeCollector
        extends PhpRecursiveElementVisitor {
            private PhpReferenceInScopeCollector() {
            }

            public void visitPhpElement(PhpPsiElement element) {
                if (!(PhpCodeInsightUtil.isScopeForUseOperator(element) || element instanceof PhpUse && !((PhpUse)element).isTraitImport())) {
                    super.visitPhpElement(element);
                }
            }
        }
    }
}

