/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.quickfix.PhpUnitCreateTargetClassQuickFix;
import com.jetbrains.php.lang.inspections.quickfix.PhpUnitCreateTargetMethodQuickFix;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.phpunit.PhpUnitTestDescriptor;
import com.jetbrains.php.phpunit.PhpUnitUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class PhpUnitMissingTargetForTestInspection
extends PhpInspection {
    private static final String TEST_PREFIX = "test";

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpUnitMissingTargetForTestInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpClass(PhpClass testClass) {
                if (PhpUnitTestDescriptor.INSTANCE.isTestClassName(testClass.getName()) && PhpUnitUtil.isTestClass(testClass)) {
                    ASTNode nameNode;
                    Collection<PhpClass> targetClasses = PhpUnitMissingTargetForTestInspection.findTargetClasses(testClass);
                    if (testClass.getName().length() > PhpUnitMissingTargetForTestInspection.TEST_PREFIX.length() && targetClasses.isEmpty() && (nameNode = testClass.getNameNode()) != null) {
                        holder.registerProblem(nameNode.getPsi(), PhpBundle.message("inspection.phpunit.missing.target.element.ref", new Object[0]), new LocalQuickFix[]{isOnTheFly ? PhpUnitCreateTargetClassQuickFix.ON_THE_FLY : PhpUnitCreateTargetClassQuickFix.BATCH_MODE});
                    }
                    for (Method method : testClass.getOwnMethods()) {
                        CharSequence methodName = method.getNameCS();
                        if (method instanceof PhpDocMethod || !StringUtil.startsWith((CharSequence)methodName, (CharSequence)PhpUnitMissingTargetForTestInspection.TEST_PREFIX)) continue;
                        this.check(method, targetClasses);
                    }
                }
            }

            private void check(@NotNull Method testMethod, @NotNull Collection<PhpClass> targetClasses) {
                String targetMethodName;
                if (testMethod == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (targetClasses == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (StringUtil.isNotEmpty((String)(targetMethodName = PhpUnitMissingTargetForTestInspection.getTargetMethodName(testMethod)))) {
                    boolean noTargetMethodExists = targetClasses.stream().noneMatch(clazz -> clazz.findOwnMethodByName((CharSequence)targetMethodName) != null);
                    ASTNode nameNode = testMethod.getNameNode();
                    if (nameNode != null && noTargetMethodExists) {
                        holder.registerProblem(nameNode.getPsi(), PhpBundle.message("inspection.phpunit.missing.target.element.ref", new Object[0]), new LocalQuickFix[]{isOnTheFly ? PhpUnitCreateTargetMethodQuickFix.ON_THE_FLY : PhpUnitCreateTargetMethodQuickFix.BATCH_MODE});
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "testMethod";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "targetClasses";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/php/lang/inspections/PhpUnitMissingTargetForTestInspection$1";
                objectArray[2] = "check";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    public static Collection<PhpClass> findTargetClasses(@NotNull PhpClass testClass) {
        if (testClass == null) {
            PhpUnitMissingTargetForTestInspection.$$$reportNull$$$0(1);
        }
        Collection<PhpClass> collection = PhpUnitTestDescriptor.INSTANCE.findClasses(testClass, testClass.getName());
        if (collection == null) {
            PhpUnitMissingTargetForTestInspection.$$$reportNull$$$0(2);
        }
        return collection;
    }

    @NotNull
    public static String getTargetMethodName(@NotNull Method testMethod) {
        if (testMethod == null) {
            PhpUnitMissingTargetForTestInspection.$$$reportNull$$$0(3);
        }
        String string = StringUtil.decapitalize((String)StringUtil.trimStart((String)testMethod.getName(), (String)TEST_PREFIX));
        if (string == null) {
            PhpUnitMissingTargetForTestInspection.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testClass";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpUnitMissingTargetForTestInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testMethod";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpUnitMissingTargetForTestInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findTargetClasses";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetMethodName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findTargetClasses";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTargetMethodName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

