/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.DynamicBundle;
import com.intellij.codeInspection.IntentionAndQuickFixAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlow;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowBuilder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpCustomExitPointRegistry;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCatchConditionInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpConditionInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpEntryPointInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpIncludeInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpVariableDocDeclarationInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpConditionInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpInstructionImpl;
import com.jetbrains.php.codeInsight.dataFlow.PhpDFAMap;
import com.jetbrains.php.codeInsight.dataFlow.reachingDefinition.PhpReachingDefinitionsDFAnalyzer;
import com.jetbrains.php.codeInsight.typeInference.PhpDfaBaseStateConditionDFAnalyzer;
import com.jetbrains.php.codeInsight.typeInference.PhpDfaBasedTypeState;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.type.PhpBooleanConstantValueDfaAnalyzer;
import com.jetbrains.php.lang.intentions.PhpVariableAddPhpDocCommentIntention;
import com.jetbrains.php.lang.intentions.addConstructorParameters.PhpAddConstructorParametersIntention;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpEmpty;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpIsset;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.FunctionImpl;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.refactoring.changeSignature.PhpChangeSignatureProcessor;
import com.jetbrains.php.refactoring.changeSignature.PhpMethodDescriptor;
import com.jetbrains.php.refactoring.changeSignature.PhpParameterInfo;
import gnu.trove.THashSet;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpUndefinedVariableInspection
extends PhpInspection {
    private static final InitializeVarQuickFix INITIALIZE_FIX = new InitializeVarQuickFix();
    public static final String INITIALIZE_FIX_NAME = INITIALIZE_FIX.getName();
    private static final CreateParameterQuickFix CREATE_PARAMETER_FIX = new CreateParameterQuickFix();
    public static final String CREATE_PARAMETER_FIX_NAME = CREATE_PARAMETER_FIX.getName();
    public static final LocalQuickFix[] FIXES = new LocalQuickFix[]{INITIALIZE_FIX};
    public static final LocalQuickFix[] FIXES_AND_CREATE_PARAMETER_FIX = (LocalQuickFix[])ArrayUtil.append((Object[])FIXES, (Object)((Object)CREATE_PARAMETER_FIX));
    public boolean ENABLE_IN_FILE_SCOPE = true;
    public boolean REPORT_CAN_BE_UNDEFINED = true;
    public boolean IGNORE_INCLUDE = false;
    public boolean FILE_SCOPE_HIGHLIGHT_TYPE = true;

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpUndefinedVariableInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpFunction(Function function) {
                Parameter[] parameters;
                Set predefined = null;
                if (function.isClosure()) {
                    if (FunctionImpl.isShortArrowFunction(function)) {
                        return;
                    }
                    PhpUseList useList = (PhpUseList)PhpPsiUtil.getChildByCondition((PsiElement)function, (Condition<? super PsiElement>)PhpUseList.INSTANCEOF);
                    if (useList != null) {
                        List<Variable> variables = PhpPsiUtil.getChildren((PsiElement)useList, (Condition<? super PsiElement>)Variable.INSTANCEOF);
                        for (Variable variable : variables) {
                            CharSequence variableName = variable.getNameCS();
                            if (StringUtil.isEmpty((CharSequence)variableName)) continue;
                            if (predefined == null) {
                                predefined = new THashSet();
                            }
                            predefined.add(variableName);
                        }
                    }
                }
                if ((parameters = function.getParameters()).length == 0) {
                    if (predefined == null) {
                        predefined = function.getPredefinedVariables();
                    }
                } else {
                    if (predefined == null) {
                        predefined = new THashSet();
                    }
                    for (Parameter parameter : parameters) {
                        predefined.add(parameter.getNameCS());
                    }
                }
                PhpUndefinedVariableInspection.this.analyzeScope((PhpScopeHolder)function, predefined, holder, isOnTheFly);
            }

            public void visitPhpMethod(Method method) {
                this.visitPhpFunction((Function)method);
            }

            public void visitPhpFile(PhpFile file) {
                if (PhpUndefinedVariableInspection.this.ENABLE_IN_FILE_SCOPE) {
                    PhpUndefinedVariableInspection.this.analyzeScope((PhpScopeHolder)file, file.getPredefinedVariables(), holder, isOnTheFly);
                } else {
                    super.visitPhpFile(file);
                }
            }

            public void visitPhpNamespace(PhpNamespace namespace) {
                PhpUndefinedVariableInspection.this.analyzeScope((PhpScopeHolder)namespace, namespace.getPredefinedVariables(), holder, isOnTheFly);
            }
        };
    }

    private void analyzeScope(final @NotNull PhpScopeHolder scopeHolder, final @NotNull Set<CharSequence> predefinedVariables, final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (scopeHolder == null) {
            PhpUndefinedVariableInspection.$$$reportNull$$$0(1);
        }
        if (predefinedVariables == null) {
            PhpUndefinedVariableInspection.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            PhpUndefinedVariableInspection.$$$reportNull$$$0(3);
        }
        final PhpControlFlow controlFlow = PhpCustomExitPointRegistry.getControlFlow(scopeHolder);
        PhpControlFlowUtil.processSuccessors((PhpInstruction)controlFlow.getEntryPoint(), false, new PhpInstructionProcessor(){

            public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                PhpPsiElement variableToHighlight;
                PhpAccessInstruction.Access access = instruction.getAccess();
                if (!access.isRead() && access != PhpAccessInstruction.Access.COMPACT_READ_ACCESS) {
                    return true;
                }
                CharSequence variableName = instruction.getVariableName();
                if (PhpLangUtil.equalsVariableNames("this", variableName)) {
                    return true;
                }
                PhpPsiElement anchor = instruction.getAnchor();
                if (PhpWorkaroundUtil.getArrayAccess(instruction).isWrite()) {
                    return true;
                }
                if (PhpUndefinedVariableInspection.isStaticFieldReference((PsiElement)anchor)) {
                    return true;
                }
                if (PhpUndefinedVariableInspection.this.IGNORE_INCLUDE && scopeHolder instanceof PhpFile && anchor instanceof PhpTypedElement && !((PhpTypedElement)anchor).getGlobalType().filterUnknown().isEmpty()) {
                    return true;
                }
                PhpDFAMap<PhpReachingDefinitionsDFAnalyzer.Result> dfaMap = PhpDFAMap.create(new MyDFAnalyzer());
                Ref canBeDefined = new Ref((Object)false);
                Ref canBeUndefined = new Ref((Object)false);
                HashMap<CharSequence, Collection<Object>> dfaStateOfVariables = new HashMap<CharSequence, Collection<Object>>();
                HashSet<TextRange> processedViaDFAConditionsRanges = new HashSet<TextRange>();
                int initialNumber = instruction.num();
                PhpInstructionProcessor processor = this.createProcessor(variableName, dfaMap, (Ref<Boolean>)canBeDefined, (Ref<Boolean>)canBeUndefined, dfaStateOfVariables, processedViaDFAConditionsRanges, initialNumber);
                HashSet unreachableViaDFAInstructions = new HashSet();
                BitSet visited = new BitSet(instruction.num());
                PhpControlFlowUtil.processPredecessors((PhpInstruction)instruction, false, PhpUndefinedVariableInspection.createStrategyWithoutAlwaysFalseConditions(dfaStateOfVariables, processedViaDFAConditionsRanges, unreachableViaDFAInstructions), processor, visited);
                if (!((Boolean)canBeDefined.get()).booleanValue() && !unreachableViaDFAInstructions.isEmpty()) {
                    for (PhpInstruction unreachableInstruction : unreachableViaDFAInstructions) {
                        PhpControlFlowUtil.processPredecessors(unreachableInstruction, false, processor, visited);
                    }
                }
                Object object = variableToHighlight = PhpUndefinedVariableInspection.this.isEncapsVarInString(anchor) ? anchor.getFirstChild().getNextSibling() : anchor;
                if (variableToHighlight == null) {
                    return true;
                }
                if (!((Boolean)canBeDefined.get()).booleanValue()) {
                    if (!PhpUndefinedVariableInspection.isReachableCode(instruction, controlFlow)) {
                        return true;
                    }
                    LocalQuickFix[] fixes = PhpUndefinedVariableInspection.getUndefinedFixes((PsiElement)anchor, scopeHolder, isOnTheFly);
                    holder.registerProblem((PsiElement)variableToHighlight, PhpBundle.message("inspection.undefined.variable.problem1", new Object[0]), fixes);
                } else if (((Boolean)canBeUndefined.get()).booleanValue() && PhpUndefinedVariableInspection.this.REPORT_CAN_BE_UNDEFINED) {
                    if (!PhpUndefinedVariableInspection.isReachableCode(instruction, controlFlow)) {
                        return true;
                    }
                    holder.registerProblem((PsiElement)variableToHighlight, PhpBundle.message("inspection.undefined.variable.problem2", new Object[0]), ProblemHighlightType.WEAK_WARNING, LocalQuickFix.EMPTY_ARRAY);
                }
                return true;
            }

            @NotNull
            private PhpInstructionProcessor createProcessor(final CharSequence variableName, final PhpDFAMap<PhpReachingDefinitionsDFAnalyzer.Result> dfaMap, final Ref<Boolean> canBeDefined, final Ref<Boolean> canBeUndefined, final Map<CharSequence, Collection<Object>> dfaStateOfVariables, final Set<TextRange> processedViaDFAConditionsRanges, final int initialNumber) {
                return new PhpInstructionProcessor(){

                    public boolean processCatchConditionInstruction(PhpCatchConditionInstruction instruction) {
                        return instruction.getResult();
                    }

                    public boolean processAccessVariableInstruction(PhpAccessVariableInstruction curInstruction) {
                        PhpAccessInstruction.Access curAccess = curInstruction.getAccess();
                        if (initialNumber > curInstruction.num() && curAccess.isWrite()) {
                            PhpUndefinedVariableInspection.addState(curInstruction.getVariableName(), dfaStateOfVariables, (Object)PhpBooleanConstantValueDfaAnalyzer.BooleanConstantState.AMBIGUOUS);
                        }
                        if (PhpLangUtil.equalsVariableNames(variableName, curInstruction.getVariableName())) {
                            if (curAccess.isUnset()) {
                                canBeUndefined.set((Object)true);
                            } else {
                                if (curAccess.isLightRead()) {
                                    return true;
                                }
                                if (initialNumber > curInstruction.num() || !curAccess.isRead()) {
                                    canBeDefined.set((Object)true);
                                }
                            }
                            return false;
                        }
                        return true;
                    }

                    public boolean processVariableDocDeclarationInstruction(PhpVariableDocDeclarationInstruction instruction) {
                        if (PhpLangUtil.equalsVariableNames(variableName, instruction.getVariableName())) {
                            canBeDefined.set((Object)true);
                            return false;
                        }
                        return true;
                    }

                    public boolean processEntryPointInstruction(PhpEntryPointInstruction instruction) {
                        if (!PhpUndefinedVariableInspection.isPredefinedVariable(variableName, predefinedVariables)) {
                            canBeUndefined.set((Object)true);
                        } else {
                            canBeDefined.set((Object)true);
                        }
                        return true;
                    }

                    public boolean processIncludeInstruction(PhpIncludeInstruction instruction) {
                        if (!PhpUndefinedVariableInspection.this.IGNORE_INCLUDE) {
                            return super.processIncludeInstruction(instruction);
                        }
                        canBeDefined.set((Object)true);
                        return false;
                    }

                    public boolean processConditionInstruction(PhpConditionInstruction instruction) {
                        PsiElement condition = instruction.getCondition();
                        if (condition == null) {
                            return true;
                        }
                        if (initialNumber > instruction.num()) {
                            PhpUndefinedVariableInspection.addComputedConditions(instruction, dfaStateOfVariables, processedViaDFAConditionsRanges);
                            return ((PhpReachingDefinitionsDFAnalyzer.Result)dfaMap.get(instruction)).apply(variableName, (Ref<Boolean>)canBeDefined, (Ref<Boolean>)canBeUndefined);
                        }
                        return true;
                    }
                };
            }
        });
    }

    private boolean isEncapsVarInString(PhpPsiElement anchor) {
        return anchor.getParent() instanceof StringLiteralExpression && PhpPsiUtil.isOfType(anchor.getFirstChild(), PhpTokenTypes.chLBRACE, PhpTokenTypes.DOLLAR_LBRACE);
    }

    public static void addState(CharSequence variableName, Map<CharSequence, Collection<Object>> dfaStateOfVariables, Object state) {
        Collection computedStates = dfaStateOfVariables.computeIfAbsent(variableName, t -> new HashSet());
        if (computedStates.stream().anyMatch(s -> s != state && s.getClass() == state.getClass())) {
            computedStates.add(PhpBooleanConstantValueDfaAnalyzer.BooleanConstantState.AMBIGUOUS);
        } else {
            computedStates.add(state);
        }
    }

    private static void addComputedConditions(PhpConditionInstruction instruction, Map<CharSequence, Collection<Object>> dfaStateOfVariables, Collection<TextRange> processedViaDFAConditionsRanges) {
        PsiElement condition = instruction.getCondition();
        if (condition == null) {
            return;
        }
        TextRange range = condition.getTextRange();
        if (processedViaDFAConditionsRanges.stream().anyMatch(t -> !t.equals((Object)range) && t.contains(range))) {
            return;
        }
        processedViaDFAConditionsRanges.add(condition.getTextRange());
        PhpBooleanConstantValueDfaAnalyzer analyzer = new PhpBooleanConstantValueDfaAnalyzer(){

            @Override
            @Nullable
            protected Map<String, PhpBooleanConstantValueDfaAnalyzer.BooleanConstantState> performDFAFromBooleanComparison(PsiElement left, PsiElement right, IElementType operationType, boolean result) {
                Map map = (Map)super.performDFAFromBooleanComparison(left, right, operationType, result);
                return result || map == null ? map : StreamEx.of(map.entrySet()).mapToEntry(Map.Entry::getKey, v -> PhpBooleanConstantValueDfaAnalyzer.BooleanConstantState.AMBIGUOUS).toMap();
            }
        };
        Set entries = ((Map)analyzer.performDFA(instruction)).entrySet();
        if (!entries.isEmpty()) {
            for (Map.Entry entry : entries) {
                PhpUndefinedVariableInspection.addState((CharSequence)entry.getKey(), dfaStateOfVariables, entry.getValue());
            }
        } else {
            PhpDfaBaseStateConditionDFAnalyzer.PhpVariableDfaState state = (PhpDfaBaseStateConditionDFAnalyzer.PhpVariableDfaState)((Object)new PhpDfaBaseStateConditionDFAnalyzer(true).performDFA(instruction));
            if (!StringUtil.isEmpty((CharSequence)state.getVariableName())) {
                PhpUndefinedVariableInspection.addState(state.getVariableName(), dfaStateOfVariables, state.getState());
            }
        }
    }

    private static @NotNull PhpControlFlowUtil.AppendPredecessorsStrategy createStrategyWithoutAlwaysFalseConditions(final Map<CharSequence, Collection<Object>> dfaStateOfVariableNames, final Set<TextRange> processedViaDFAConditionsRanges, final Collection<? super PhpInstruction> unreachableViaDFAInstructions) {
        return new PhpControlFlowUtil.AppendPredecessorsStrategy(){

            @Override
            public void appendPredecessors(@NotNull PhpInstruction instruction, @NotNull Collection<PhpInstruction> pool, int initialNumber) {
                if (instruction == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (pool == null) {
                    4.$$$reportNull$$$0(1);
                }
                List predecessors = (List)instruction.getPredecessors();
                PhpControlFlowBuilder.PhpSkippedLoopInstruction skipLoopPredecessor = ((PhpInstructionImpl)instruction).getSkipLoopPredecessor();
                int size = predecessors.size();
                for (int i = 0; i < size; ++i) {
                    PhpInstruction predecessor = (PhpInstruction)predecessors.get(i);
                    if (initialNumber == predecessor.num()) continue;
                    if (predecessor instanceof PhpConditionInstruction && this.predecessorIsAlwaysFalse((PhpConditionInstruction)predecessor) || PhpControlFlowUtil.alwaysNonEmpty(skipLoopPredecessor, predecessor)) {
                        unreachableViaDFAInstructions.add(predecessor);
                        continue;
                    }
                    pool.add(predecessor);
                }
            }

            private boolean predecessorIsAlwaysFalse(PhpConditionInstruction predecessor) {
                PhpDfaBaseStateConditionDFAnalyzer invertedAnalyzer;
                PhpDfaBaseStateConditionDFAnalyzer.PhpVariableDfaState stateOfInvertedInstruction;
                Collection states;
                PsiElement condition = predecessor.getCondition();
                if (condition == null || processedViaDFAConditionsRanges.stream().anyMatch(t -> t.contains(condition.getTextRange()))) {
                    return false;
                }
                PhpBooleanConstantValueDfaAnalyzer analyzer = new PhpBooleanConstantValueDfaAnalyzer();
                Map constStateOfPredecessor = (Map)analyzer.performDFA(predecessor);
                for (Map.Entry predecessorsState : constStateOfPredecessor.entrySet()) {
                    String predecessorVariableName = (String)predecessorsState.getKey();
                    PhpBooleanConstantValueDfaAnalyzer.BooleanConstantState predecessorStateValue = (PhpBooleanConstantValueDfaAnalyzer.BooleanConstantState)((Object)predecessorsState.getValue());
                    PhpBooleanConstantValueDfaAnalyzer.BooleanConstantState aTrue = PhpBooleanConstantValueDfaAnalyzer.BooleanConstantState.TRUE;
                    if (this.isAmbiguous(predecessorVariableName) || (predecessorStateValue != PhpBooleanConstantValueDfaAnalyzer.BooleanConstantState.FALSE || !PhpUndefinedVariableInspection.hasState(predecessorVariableName, (Object)aTrue, dfaStateOfVariableNames)) && (predecessorStateValue != PhpBooleanConstantValueDfaAnalyzer.BooleanConstantState.TRUE || !PhpUndefinedVariableInspection.hasState(predecessorVariableName, (Object)PhpBooleanConstantValueDfaAnalyzer.BooleanConstantState.FALSE, dfaStateOfVariableNames))) continue;
                    return true;
                }
                return !predecessor.getResult() && !(states = (Collection)dfaStateOfVariableNames.getOrDefault((stateOfInvertedInstruction = (PhpDfaBaseStateConditionDFAnalyzer.PhpVariableDfaState)((Object)(invertedAnalyzer = new PhpDfaBaseStateConditionDFAnalyzer(true){

                    @Override
                    @NotNull
                    public PhpDfaBaseStateConditionDFAnalyzer.PhpVariableDfaState and(@NotNull PhpDfaBaseStateConditionDFAnalyzer.PhpVariableDfaState leftOperand, @NotNull PhpDfaBaseStateConditionDFAnalyzer.PhpVariableDfaState rightOperand, boolean conditionResult) {
                        if (leftOperand == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (rightOperand == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        PhpDfaBaseStateConditionDFAnalyzer.PhpVariableDfaState phpVariableDfaState = super.and(leftOperand, rightOperand, !conditionResult);
                        if (phpVariableDfaState == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        return phpVariableDfaState;
                    }

                    @Override
                    @NotNull
                    public PhpDfaBaseStateConditionDFAnalyzer.PhpVariableDfaState or(@NotNull PhpDfaBaseStateConditionDFAnalyzer.PhpVariableDfaState leftOperand, @NotNull PhpDfaBaseStateConditionDFAnalyzer.PhpVariableDfaState rightOperand, boolean conditionResult) {
                        if (leftOperand == null) {
                            1.$$$reportNull$$$0(3);
                        }
                        if (rightOperand == null) {
                            1.$$$reportNull$$$0(4);
                        }
                        PhpDfaBaseStateConditionDFAnalyzer.PhpVariableDfaState phpVariableDfaState = super.or(leftOperand, rightOperand, !conditionResult);
                        if (phpVariableDfaState == null) {
                            1.$$$reportNull$$$0(5);
                        }
                        return phpVariableDfaState;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        RuntimeException runtimeException;
                        Object[] objectArray;
                        Object[] objectArray2;
                        int n2;
                        String string;
                        switch (n) {
                            default: {
                                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                break;
                            }
                            case 2: 
                            case 5: {
                                string = "@NotNull method %s.%s must not return null";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                n2 = 3;
                                break;
                            }
                            case 2: 
                            case 5: {
                                n2 = 2;
                                break;
                            }
                        }
                        Object[] objectArray3 = new Object[n2];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "leftOperand";
                                break;
                            }
                            case 1: 
                            case 4: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "rightOperand";
                                break;
                            }
                            case 2: 
                            case 5: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpUndefinedVariableInspection$4$1";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpUndefinedVariableInspection$4$1";
                                break;
                            }
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[1] = "and";
                                break;
                            }
                            case 5: {
                                objectArray = objectArray2;
                                objectArray2[1] = "or";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray;
                                objectArray[2] = "and";
                                break;
                            }
                            case 2: 
                            case 5: {
                                break;
                            }
                            case 3: 
                            case 4: {
                                objectArray = objectArray;
                                objectArray[2] = "or";
                                break;
                            }
                        }
                        String string2 = String.format(string, objectArray);
                        switch (n) {
                            default: {
                                runtimeException = new IllegalArgumentException(string2);
                                break;
                            }
                            case 2: 
                            case 5: {
                                runtimeException = new IllegalStateException(string2);
                                break;
                            }
                        }
                        throw runtimeException;
                    }
                }).performDFA(new PhpConditionInstructionImpl(predecessor.getCondition(), true)))).getVariableName(), Collections.emptySet())).isEmpty() && ContainerUtil.all((Collection)states, prevState -> prevState instanceof PhpDfaBasedTypeState && ((PhpDfaBasedTypeState)prevState).coveredBy(condition.getProject(), (PhpDfaBasedTypeState)stateOfInvertedInstruction.getState(), true));
            }

            private boolean isAmbiguous(CharSequence variableName) {
                return PhpUndefinedVariableInspection.hasState(variableName, (Object)PhpBooleanConstantValueDfaAnalyzer.BooleanConstantState.AMBIGUOUS, dfaStateOfVariableNames) || PhpUndefinedVariableInspection.hasState(variableName, PhpDfaBasedTypeState.AMBIGUOUS, dfaStateOfVariableNames) || PhpUndefinedVariableInspection.hasState(variableName, (Object)PhpBooleanConstantValueDfaAnalyzer.BooleanConstantState.TRUE, dfaStateOfVariableNames) && PhpUndefinedVariableInspection.hasState(variableName, (Object)PhpBooleanConstantValueDfaAnalyzer.BooleanConstantState.FALSE, dfaStateOfVariableNames);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "instruction";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "pool";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/php/lang/inspections/PhpUndefinedVariableInspection$4";
                objectArray[2] = "appendPredecessors";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static boolean hasState(CharSequence variableName, Object state, Map<CharSequence, Collection<Object>> dfaStateOfVariableNames) {
        return ((Collection)dfaStateOfVariableNames.getOrDefault(variableName, Collections.emptySet())).contains(state);
    }

    private static boolean isStaticFieldReference(@Nullable PsiElement element) {
        PsiElement parent;
        if (element instanceof Variable && (parent = element.getParent()) instanceof FieldReference) {
            List children = PhpPsiUtil.getChildren(parent, (Condition<? super PsiElement>)Variable.INSTANCEOF);
            if (children.size() == 2 && children.get(1) == element) {
                return !PhpPsiUtil.isOfType(((PsiElement)children.get(1)).getPrevSibling(), PhpTokenTypes.ARROW);
            }
            return false;
        }
        return false;
    }

    private static boolean isReachableCode(@NotNull PhpAccessVariableInstruction instruction, @NotNull PhpControlFlow controlFlow) {
        if (instruction == null) {
            PhpUndefinedVariableInspection.$$$reportNull$$$0(4);
        }
        if (controlFlow == null) {
            PhpUndefinedVariableInspection.$$$reportNull$$$0(5);
        }
        return PhpControlFlowUtil.isPredecessor((PhpInstruction)instruction, (PhpInstruction)controlFlow.getEntryPoint());
    }

    public static LocalQuickFix @NotNull [] getUndefinedFixes(PsiElement anchor, @Nullable PhpScopeHolder scopeHolder, boolean isOnTheFly) {
        if (!isOnTheFly) {
            if (LocalQuickFix.EMPTY_ARRAY == null) {
                PhpUndefinedVariableInspection.$$$reportNull$$$0(6);
            }
            return LocalQuickFix.EMPTY_ARRAY;
        }
        if (scopeHolder instanceof Function) {
            if (((Function)scopeHolder).isClosure() && !FunctionImpl.isShortArrowFunction((Function)scopeHolder)) {
                LocalQuickFix[] localQuickFixArray = (LocalQuickFix[])ArrayUtil.append((Object[])FIXES_AND_CREATE_PARAMETER_FIX, (Object)((Object)new AddToUseQuickFix(anchor, (Function)scopeHolder)));
                if (localQuickFixArray == null) {
                    PhpUndefinedVariableInspection.$$$reportNull$$$0(7);
                }
                return localQuickFixArray;
            }
            if (FIXES_AND_CREATE_PARAMETER_FIX == null) {
                PhpUndefinedVariableInspection.$$$reportNull$$$0(8);
            }
            return FIXES_AND_CREATE_PARAMETER_FIX;
        }
        if (FIXES == null) {
            PhpUndefinedVariableInspection.$$$reportNull$$$0(9);
        }
        return FIXES;
    }

    private static boolean isPredefinedVariable(@NotNull CharSequence variableName, @NotNull Set<CharSequence> predefinedVariables) {
        if (variableName == null) {
            PhpUndefinedVariableInspection.$$$reportNull$$$0(10);
        }
        if (predefinedVariables == null) {
            PhpUndefinedVariableInspection.$$$reportNull$$$0(11);
        }
        return PhpUndefinedVariableInspection.isPredefinedVariable(variableName) || predefinedVariables.contains(variableName);
    }

    private static boolean isPredefinedVariable(@NotNull CharSequence variableName) {
        if (variableName == null) {
            PhpUndefinedVariableInspection.$$$reportNull$$$0(12);
        }
        return PhpLangUtil.isSuperGlobal(variableName) || PhpLangUtil.isMagicPredefinedVariable(variableName);
    }

    private static boolean isCoalesceVariable(@Nullable PsiElement element) {
        if (element instanceof ArrayAccessExpression || element instanceof FieldReference || element instanceof Variable) {
            PsiElement parent = element.getParent();
            return PhpPsiUtil.isOfType(parent, PhpElementTypes.COALESCE_EXPRESSION) && parent instanceof BinaryExpression && ((BinaryExpression)parent).getLeftOperand() == element;
        }
        return false;
    }

    @Override
    public JComponent createOptionsPanel() {
        return new OptionsPanel().getComponent();
    }

    @NotNull
    protected static PhpUseList createUseList(@NotNull Project project, Variable ... variables) {
        if (project == null) {
            PhpUndefinedVariableInspection.$$$reportNull$$$0(13);
        }
        String variablesList = Arrays.stream(variables).map(v -> "$" + v.getName()).collect(Collectors.joining(","));
        String useListString = "function() use(" + variablesList + ") {}";
        PhpUseList useList = PhpPsiElementFactory.createFromText(project, PhpUseList.class, useListString);
        assert (useList != null);
        PhpUseList phpUseList = useList;
        if (phpUseList == null) {
            PhpUndefinedVariableInspection.$$$reportNull$$$0(14);
        }
        return phpUseList;
    }

    public static void addUseListWithVariables(@NotNull Project project, Function function, Variable ... variables) {
        PsiElement anchor;
        if (project == null) {
            PhpUndefinedVariableInspection.$$$reportNull$$$0(15);
        }
        if ((anchor = PhpPsiUtil.getChildOfType((PsiElement)function, PhpTokenTypes.chRPAREN)) == null) {
            anchor = PhpPsiUtil.getChildOfType((PsiElement)function, PhpTokenTypes.chLPAREN);
        }
        if (anchor == null) {
            anchor = PhpPsiUtil.getChildOfType((PsiElement)function, PhpTokenTypes.kwFUNCTION);
        }
        assert (anchor != null);
        PhpUseList phpUseList = PhpUndefinedVariableInspection.createUseList(project, variables);
        function.addAfter((PsiElement)phpUseList, anchor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeHolder";
                break;
            }
            case 2: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predefinedVariables";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controlFlow";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpUndefinedVariableInspection";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableName";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpUndefinedVariableInspection";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getUndefinedFixes";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createUseList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "analyzeScope";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isReachableCode";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: {
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isPredefinedVariable";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createUseList";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addUseListWithVariables";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class AddToUseQuickFix
    extends LocalQuickFixOnPsiElement {
        private AddToUseQuickFix(PsiElement anchor, Function holder) {
            super(anchor, (PsiElement)holder);
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = this.getText();
            if (string == null) {
                AddToUseQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @IntentionName
        @NotNull
        public String getText() {
            String string = PhpBundle.message("quickfix.add.to.use", new Object[0]);
            if (string == null) {
                AddToUseQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                AddToUseQuickFix.$$$reportNull$$$0(2);
            }
            if (file == null) {
                AddToUseQuickFix.$$$reportNull$$$0(3);
            }
            if (startElement == null) {
                AddToUseQuickFix.$$$reportNull$$$0(4);
            }
            if (endElement == null) {
                AddToUseQuickFix.$$$reportNull$$$0(5);
            }
            Function function = (Function)endElement;
            Variable variable = (Variable)startElement;
            assert (function.isClosure());
            PhpUseList useList = (PhpUseList)PhpPsiUtil.getChildByCondition((PsiElement)function, (Condition<? super PsiElement>)PhpUseList.INSTANCEOF);
            if (useList != null) {
                PsiElement firstChild = useList.getChildren()[0];
                PsiElement openParen = PhpPsiUtil.getChildOfType((PsiElement)useList, PhpTokenTypes.chLPAREN);
                if (openParen != null && firstChild instanceof Variable) {
                    PsiElement comma = PhpPsiElementFactory.createComma(project);
                    comma = openParen.getParent().addAfter(comma, openParen);
                    Variable newUseParameter = PhpPsiElementFactory.createVariable(project, variable.getName(), true);
                    comma.getParent().addBefore((PsiElement)newUseParameter, comma);
                } else {
                    useList.replace((PsiElement)PhpUndefinedVariableInspection.createUseList(project, variable));
                }
            } else {
                PhpUndefinedVariableInspection.addUseListWithVariables(project, function, variable);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpUndefinedVariableInspection$AddToUseQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpUndefinedVariableInspection$AddToUseQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class CreateParameterQuickFix
    extends IntentionAndQuickFixAction {
        public static final Runnable DO_NOTHING = () -> {};

        @NotNull
        public String getName() {
            String string = CreateParameterQuickFix.getNameText();
            if (string == null) {
                CreateParameterQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = CreateParameterQuickFix.getNameText();
            if (string == null) {
                CreateParameterQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, PsiFile file, @Nullable Editor editor) {
            Variable variable;
            if (project == null) {
                CreateParameterQuickFix.$$$reportNull$$$0(2);
            }
            if ((variable = PhpVariableAddPhpDocCommentIntention.findVariable(file, editor)) == null) {
                return;
            }
            PhpUseList useList = (PhpUseList)PsiTreeUtil.getParentOfType((PsiElement)variable, PhpUseList.class);
            Function function = CreateParameterQuickFix.getTargetFunction(variable, useList);
            PhpParameterInfo newParameter = new PhpParameterInfo(-1, variable.getName());
            if (!CreateParameterQuickFix.isAvailable(variable)) {
                PhpMethodDescriptor functionDescriptor = new PhpMethodDescriptor(function);
                List<PhpParameterInfo> functionDescriptorParameters = functionDescriptor.getParameters();
                functionDescriptorParameters.add(newParameter);
                if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
                    this.emulateDialogInteractionInTests(functionDescriptor, functionDescriptorParameters);
                }
                PhpAddConstructorParametersIntention.addParameterUsingChangeSignature(project, functionDescriptor, functionDescriptorParameters, DO_NOTHING, variable);
                return;
            }
            assert (function != null);
            if (!CommonRefactoringUtil.checkReadOnlyStatus((PsiElement)function)) {
                return;
            }
            WriteAction.run(() -> PhpChangeSignatureProcessor.addParameterToFunctionSignature(project, function, Collections.singletonList(newParameter)));
        }

        protected void emulateDialogInteractionInTests(PhpMethodDescriptor functionDescriptor, List<PhpParameterInfo> functionDescriptorParameters) {
        }

        @Nullable
        private static Function getTargetFunction(Variable variable, PhpUseList useList) {
            Function function = (Function)PsiTreeUtil.getParentOfType((PsiElement)variable, Function.class);
            if (useList != null) {
                function = (Function)PhpPsiUtil.getParentByCondition((PsiElement)function, (Condition<? super PsiElement>)Function.INSTANCEOF);
            }
            return function;
        }

        private static boolean isAvailable(@NotNull Variable variable) {
            if (variable == null) {
                CreateParameterQuickFix.$$$reportNull$$$0(3);
            }
            Function function = (Function)PsiTreeUtil.getParentOfType((PsiElement)variable, Function.class, (boolean)true);
            PhpUseList useList = (PhpUseList)PhpPsiUtil.getParentByCondition((PsiElement)variable, (Condition<? super PsiElement>)PhpUseList.INSTANCEOF);
            if (useList != null) {
                function = (Function)PhpPsiUtil.getParentByCondition((PsiElement)function, (Condition<? super PsiElement>)Function.INSTANCEOF);
            }
            if (function == null) {
                return false;
            }
            Query query = ReferencesSearch.search((PsiElement)function, (SearchScope)GlobalSearchScope.allScope((Project)function.getProject()));
            PsiReference functionReference = (PsiReference)query.findFirst();
            return functionReference == null;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, PsiFile file) {
            if (project == null) {
                CreateParameterQuickFix.$$$reportNull$$$0(4);
            }
            return PhpVariableAddPhpDocCommentIntention.findVariable(file, editor) != null;
        }

        @IntentionFamilyName
        @IntentionName
        private static String getNameText() {
            return PhpBundle.message("quickfix.create.parameter", new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpUndefinedVariableInspection$CreateParameterQuickFix";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpUndefinedVariableInspection$CreateParameterQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class InitializeVarQuickFix
    implements LocalQuickFix {
        private InitializeVarQuickFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("initialize.var.quick.fix.family.name", new Object[0]);
            if (string == null) {
                InitializeVarQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                InitializeVarQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                InitializeVarQuickFix.$$$reportNull$$$0(2);
            }
            PsiElement variable = descriptor.getPsiElement();
            StringBuilder builder = new StringBuilder();
            builder.append("$");
            builder.append(variable instanceof Variable ? ((Variable)variable).getName() : PhpCodeInsightUtil.toString(variable));
            builder.append("=;");
            Statement statement = PhpCodeEditUtil.putStatementBefore(variable, PhpPsiElementFactory.createFromText(variable.getProject(), Statement.class, builder.toString()));
            PsiElement semicolon = PhpPsiUtil.getChildOfType((PsiElement)statement, PhpTokenTypes.opSEMICOLON);
            if (semicolon != null) {
                Navigatable openFileDescriptor = PsiNavigationSupport.getInstance().createNavigatable(project, statement.getContainingFile().getVirtualFile(), semicolon.getTextRange().getStartOffset());
                openFileDescriptor.navigate(true);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpUndefinedVariableInspection$InitializeVarQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpUndefinedVariableInspection$InitializeVarQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public class OptionsPanel {
        private JPanel myOptionsPanel;
        private JCheckBox myReportCanBeUndefinedCheckBox;
        private JCheckBox myEnableInFileScopeCheckBox;
        private JCheckBox myIgnoreIncludeCheckBox;

        public OptionsPanel() {
            this.$$$setupUI$$$();
            this.myReportCanBeUndefinedCheckBox.setSelected(PhpUndefinedVariableInspection.this.REPORT_CAN_BE_UNDEFINED);
            this.myReportCanBeUndefinedCheckBox.getModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PhpUndefinedVariableInspection.this.REPORT_CAN_BE_UNDEFINED = OptionsPanel.this.myReportCanBeUndefinedCheckBox.isSelected();
                }
            });
            this.myEnableInFileScopeCheckBox.setSelected(PhpUndefinedVariableInspection.this.ENABLE_IN_FILE_SCOPE);
            this.myEnableInFileScopeCheckBox.getModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PhpUndefinedVariableInspection.this.ENABLE_IN_FILE_SCOPE = OptionsPanel.this.myEnableInFileScopeCheckBox.isSelected();
                }
            });
            this.myIgnoreIncludeCheckBox.setSelected(PhpUndefinedVariableInspection.this.IGNORE_INCLUDE);
            this.myIgnoreIncludeCheckBox.getModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PhpUndefinedVariableInspection.this.IGNORE_INCLUDE = OptionsPanel.this.myIgnoreIncludeCheckBox.isSelected();
                }
            });
        }

        public JPanel getComponent() {
            return this.myOptionsPanel;
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JCheckBox jCheckBox;
            JCheckBox jCheckBox2;
            JCheckBox jCheckBox3;
            JPanel jPanel;
            this.myOptionsPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
            this.myEnableInFileScopeCheckBox = jCheckBox3 = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox3, DynamicBundle.getBundle((String)"messages/PhpBundle", OptionsPanel.class).getString("inspection.undefined.variable.option.description.enable.in.file.scope"));
            jPanel.add((Component)jCheckBox3, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myIgnoreIncludeCheckBox = jCheckBox2 = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle((String)"messages/PhpBundle", OptionsPanel.class).getString("inspection.undefined.variable.option.description.ignore.include"));
            jPanel.add((Component)jCheckBox2, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myReportCanBeUndefinedCheckBox = jCheckBox = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/PhpBundle", OptionsPanel.class).getString("inspection.undefined.variable.option.description.report.can.be.undefined"));
            jPanel.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myOptionsPanel;
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }

    private static class MyDFAnalyzer
    extends PhpReachingDefinitionsDFAnalyzer {
        private MyDFAnalyzer() {
        }

        @Override
        @NotNull
        public PhpReachingDefinitionsDFAnalyzer.Result performDFA(@Nullable PsiElement condition, boolean result) {
            if (condition instanceof PhpIsset) {
                PhpReachingDefinitionsDFAnalyzer.Result dfaResult = new PhpReachingDefinitionsDFAnalyzer.Result();
                if (result) {
                    MyDFAnalyzer.fillDefinedVariables(dfaResult, ((PhpIsset)condition).getVariables());
                }
                PhpReachingDefinitionsDFAnalyzer.Result result2 = dfaResult;
                if (result2 == null) {
                    MyDFAnalyzer.$$$reportNull$$$0(0);
                }
                return result2;
            }
            if (condition instanceof PhpEmpty) {
                PhpReachingDefinitionsDFAnalyzer.Result dfaResult = new PhpReachingDefinitionsDFAnalyzer.Result();
                if (!result) {
                    MyDFAnalyzer.fillDefinedVariables(dfaResult, ((PhpEmpty)condition).getVariables());
                }
                PhpReachingDefinitionsDFAnalyzer.Result result3 = dfaResult;
                if (result3 == null) {
                    MyDFAnalyzer.$$$reportNull$$$0(1);
                }
                return result3;
            }
            if (result && condition instanceof Variable) {
                PhpReachingDefinitionsDFAnalyzer.Result dfaResult = new PhpReachingDefinitionsDFAnalyzer.Result();
                Variable variable = (Variable)condition;
                CharSequence variableName = variable.getNameCS();
                if (!StringUtil.isEmpty((CharSequence)variableName)) {
                    dfaResult.addDefined(variableName);
                }
                PhpReachingDefinitionsDFAnalyzer.Result result4 = dfaResult;
                if (result4 == null) {
                    MyDFAnalyzer.$$$reportNull$$$0(2);
                }
                return result4;
            }
            if (result && PhpUndefinedVariableInspection.isCoalesceVariable(condition)) {
                final PhpReachingDefinitionsDFAnalyzer.Result dfaResult = new PhpReachingDefinitionsDFAnalyzer.Result();
                condition.accept((PsiElementVisitor)new PhpElementVisitor(){

                    public void visitPhpArrayAccessExpression(ArrayAccessExpression expression) {
                        PhpPsiElement value = expression.getValue();
                        if (value != null) {
                            value.accept((PsiElementVisitor)this);
                        }
                    }

                    public void visitPhpFieldReference(FieldReference fieldReference) {
                        PhpExpression reference = fieldReference.getClassReference();
                        if (reference != null) {
                            reference.accept((PsiElementVisitor)this);
                        }
                    }

                    public void visitPhpVariable(Variable variable) {
                        String variableName = variable.getName();
                        if (StringUtil.isNotEmpty((String)variableName)) {
                            dfaResult.addDefined(variableName);
                        }
                    }
                });
                PhpReachingDefinitionsDFAnalyzer.Result result5 = dfaResult;
                if (result5 == null) {
                    MyDFAnalyzer.$$$reportNull$$$0(3);
                }
                return result5;
            }
            PhpReachingDefinitionsDFAnalyzer.Result result6 = (PhpReachingDefinitionsDFAnalyzer.Result)super.performDFA(condition, result);
            if (result6 == null) {
                MyDFAnalyzer.$$$reportNull$$$0(4);
            }
            return result6;
        }

        private static void fillDefinedVariables(PhpReachingDefinitionsDFAnalyzer.Result dfaResult, PhpExpression[] variables) {
            for (PhpExpression expression : variables) {
                String variableName = MyDFAnalyzer.extractVariableName((PsiElement)expression);
                if (!StringUtil.isNotEmpty((String)variableName)) continue;
                dfaResult.addDefined(variableName);
            }
        }

        private static String extractVariableName(PsiElement expression) {
            if (expression instanceof Variable) {
                return ((Variable)expression).getName();
            }
            if (expression instanceof ArrayAccessExpression) {
                return MyDFAnalyzer.extractVariableName((PsiElement)((ArrayAccessExpression)expression).getValue());
            }
            if (expression instanceof FieldReference) {
                return MyDFAnalyzer.extractVariableName((PsiElement)((FieldReference)expression).getClassReference());
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/lang/inspections/PhpUndefinedVariableInspection$MyDFAnalyzer", "performDFA"));
        }
    }
}

