/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.ResolveResult;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCallInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.dataFlow.reachingDefinition.PhpDFAUtil;
import com.jetbrains.php.codeInsight.dataFlow.reachingDefinition.PhpReachingDefinitionsDFAnalyzer;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.PhpRenameWrongReferenceQuickFix;
import com.jetbrains.php.lang.inspections.PhpSimpleFunctionDefinedDFAnalyzer;
import com.jetbrains.php.lang.inspections.quickfix.PhpImportFunctionQuickFix;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;

public class PhpUndefinedFunctionInspection
extends PhpInspection {
    private static final LocalQuickFix[] FIXES = new LocalQuickFix[]{PhpImportFunctionQuickFix.INSTANCE};
    public static final String FUNCTION_EXISTS = "function_exists";
    public static final PhpReachingDefinitionsDFAnalyzer DF_ANALYZER = new PhpSimpleFunctionDefinedDFAnalyzer("function_exists");

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpUndefinedFunctionInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpFunctionCall(FunctionReference reference) {
                String name = reference.getName();
                if (StringUtil.isEmptyOrSpaces((String)name)) {
                    return;
                }
                ASTNode nameNode = reference.getNameNode();
                if (nameNode == null) {
                    return;
                }
                ResolveResult[] results = ((PsiPolyVariantReference)reference.getReference()).multiResolve(false);
                if (results.length == 0) {
                    Ref canBeDefined = Ref.create((Object)false);
                    Ref canBeUndefined = Ref.create((Object)false);
                    PhpUndefinedFunctionInspection.processDfaReachability(reference, (Ref<Boolean>)canBeDefined, (Ref<Boolean>)canBeUndefined);
                    if (!((Boolean)canBeDefined.get()).booleanValue()) {
                        holder.registerProblem(nameNode.getPsi(), PhpUndefinedFunctionInspection.getPROBLEM_1(), PhpRenameWrongReferenceQuickFix.appendQuickFix((PhpReference)reference, FIXES));
                    } else if (((Boolean)canBeUndefined.get()).booleanValue()) {
                        holder.registerProblem(nameNode.getPsi(), PhpUndefinedFunctionInspection.getPROBLEM_2(), new LocalQuickFix[0]);
                    }
                }
            }
        };
    }

    public static void processDfaReachability(FunctionReference reference, Ref<Boolean> canBeDefined, Ref<Boolean> canBeUndefined) {
        PhpCallInstruction instruction = PhpControlFlowUtil.getCallInstruction(reference);
        String name = reference.getName();
        if (instruction != null && name != null) {
            PhpDFAUtil.performReachingDefinitions((PhpInstruction)instruction, canBeDefined, canBeUndefined, name, DF_ANALYZER);
        }
    }

    @InspectionMessage
    private static String getPROBLEM_1() {
        return PhpBundle.message("inspection.undefined.function.problem1", new Object[0]);
    }

    @InspectionMessage
    private static String getPROBLEM_2() {
        return PhpBundle.message("inspection.undefined.function.problem2", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/PhpUndefinedFunctionInspection", "buildVisitor"));
    }
}

