/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.DynamicBundle;
import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessFieldByVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpArrayAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpConditionInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpEntryPointInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.dataFlow.reachingDefinition.PhpReachingDefinitionDFAnalyzer;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpRenameWrongReferenceQuickFix;
import com.jetbrains.php.lang.inspections.PhpUndefinedMemberInspection;
import com.jetbrains.php.lang.inspections.PhpUndefinedMethodInspection;
import com.jetbrains.php.lang.inspections.quickfix.PhpAddFieldDeclarationQuickFix;
import com.jetbrains.php.lang.inspections.quickfix.PhpAddPropertyQuickFix;
import com.jetbrains.php.lang.inspections.quickfix.PhpQuickFixBase;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpEmpty;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpIsset;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.impl.FieldReferenceImpl;
import com.jetbrains.php.lang.psi.elements.impl.MemberReferenceImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpClassImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpUndefinedFieldInspection
extends PhpUndefinedMemberInspection {
    @IntentionName
    public static final String ADD_PROPERTY_FIX_NAME = PhpBundle.message("add.property", new Object[0]);
    private static final PhpAddPropertyQuickFix ADD_PROPERTY_FIX = new PhpAddPropertyQuickFix();
    private static final LocalQuickFix[] FIXES = new LocalQuickFix[]{PhpAddFieldDeclarationQuickFix.INSTANCE, ADD_PROPERTY_FIX};
    private static final PhpType STD_CLASS = new PhpType().add("\\stdClass");
    private static final PhpType ALLOWED_CLASSES = new PhpType().add("\\ArrayObject").add("\\SimpleXMLElement");
    public boolean NOTIFY_ACCESS_VIA_MAGIC_METHOD = true;
    public boolean NOTIFY_DYNAMIC_DECLARATION = true;

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpUndefinedFieldInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpClass(PhpClass clazz) {
                if (PhpUndefinedFieldInspection.this.isNotifyDynamicDeclaration()) {
                    Field[] fields;
                    for (Field field : fields = clazz.getOwnFields()) {
                        PsiElement psi;
                        if (!(field instanceof PhpClassImpl.MyRenamableFakePsiElement) || !((psi = field.getNavigationElement()) instanceof FieldReference) || ((FieldReference)psi).resolve() != field) continue;
                        LocalQuickFix[] fixes = PhpUndefinedFieldInspection.isClassQuickFixApplicable(clazz.getProject(), psi) ? FIXES : LocalQuickFix.EMPTY_ARRAY;
                        ASTNode node = ((FieldReference)psi).getNameNode();
                        if (node == null || node.getPsi().getContainingFile() != holder.getFile()) continue;
                        holder.registerProblem(node.getPsi(), PhpUndefinedFieldInspection.getPROBLEM_2(), ProblemHighlightType.WEAK_WARNING, fixes);
                    }
                }
            }

            public void visitPhpFieldReference(FieldReference reference) {
                ASTNode nameNode = reference.getNameNode();
                if (nameNode == null || this.isDynamicFieldReference(nameNode) || PhpPsiUtil.classConstantReferenceViaVariable(reference)) {
                    return;
                }
                Project project = holder.getProject();
                PhpExpression classReference = reference.getClassReference();
                PsiElement psi = nameNode.getPsi();
                if (MemberReferenceImpl.getDepth(classReference) == 100) {
                    holder.registerProblem(psi, PhpBundle.message("inspection.message.call.chain.too.long.to.analyse.break.it.into.fragments.up.to.calls", 100), ProblemHighlightType.WEAK_WARNING, new LocalQuickFix[0]);
                    return;
                }
                if (classReference instanceof PhpReference && !PhpUndefinedFieldInspection.noResolvedDeclarationExists((PhpReference)classReference)) {
                    PhpType type = classReference.getGlobalType();
                    PhpIndex index = PhpIndex.getInstance((Project)project);
                    if (!PhpUndefinedFieldInspection.this.isWarnOnMixed() && STD_CLASS.isConvertibleFrom(type, index)) {
                        return;
                    }
                    if (!type.isEmpty() && !PhpType.isSubType((PhpType)PhpType.MIXED, (PhpType)type) && ALLOWED_CLASSES.isConvertibleFrom(type, index)) {
                        return;
                    }
                    if (PhpUndefinedFieldInspection.this.shouldNotProcessForType(type)) {
                        return;
                    }
                    PhpAccessFieldByVariableInstruction fieldInstruction = PhpControlFlowUtil.getAccessInstruction((PhpPsiElement)reference, PhpAccessFieldByVariableInstruction.class);
                    if (fieldInstruction != null && fieldInstruction.getAccess().isLightRead()) {
                        return;
                    }
                    if (PhpUndefinedFieldInspection.noResolvedDeclarationExists((PhpReference)reference)) {
                        Ref canBeUndefined;
                        if (!PhpUndefinedFieldInspection.this.isWarnOnMixed() && PhpUndefinedMethodInspection.stringDefinedViaClassExists(classReference)) {
                            return;
                        }
                        Ref canBeDefined = new Ref((Object)false);
                        PhpUndefinedMethodInspection.Reachability reachability = PhpUndefinedFieldInspection.getReachability(reference, (Ref<Boolean>)canBeDefined, (Ref<Boolean>)(canBeUndefined = new Ref((Object)false)));
                        if (reachability == PhpUndefinedMethodInspection.Reachability.DEFINED) {
                            return;
                        }
                        if (reference.getReferenceType() == PhpModifier.State.DYNAMIC) {
                            PhpAccessInstruction.Access access = PhpCodeInsightUtil.getAccess((PhpPsiElement)reference);
                            if (access.isWrite() && PhpUndefinedFieldInspection.isExplicitlyNotDefined(reference)) {
                                return;
                            }
                            if (PhpCodeInsightUtil.hasMagicMethod(type, index, access.isWrite() ? "__set" : "__get") || PhpUndefinedFieldInspection.isTraitWithMagicMethodsInAllUsages(type, index, reference.isWriteAccess() ? "__set" : "__get")) {
                                LocalQuickFix[] fixes;
                                LocalQuickFix[] localQuickFixArray = fixes = PhpUndefinedFieldInspection.isClassQuickFixApplicable(project, psi) ? PhpRenameWrongReferenceQuickFix.appendQuickFix((PhpReference)reference, FIXES) : LocalQuickFix.EMPTY_ARRAY;
                                if (PhpUndefinedFieldInspection.this.isNotifyAccessViaMagicMethod()) {
                                    holder.registerProblem(psi, PhpUndefinedFieldInspection.getPROBLEM_1(), ProblemHighlightType.WEAK_WARNING, fixes);
                                }
                                return;
                            }
                            if (access.isWrite() && !access.isRead()) {
                                if (PhpUndefinedFieldInspection.this.isNotifyDynamicDeclaration()) {
                                    LocalQuickFix[] fixes;
                                    LocalQuickFix[] localQuickFixArray = fixes = PhpUndefinedFieldInspection.isClassQuickFixApplicable(project, psi) ? PhpRenameWrongReferenceQuickFix.appendQuickFix((PhpReference)reference, FIXES) : LocalQuickFix.EMPTY_ARRAY;
                                    if (psi.getContainingFile() == holder.getFile()) {
                                        holder.registerProblem(psi, PhpUndefinedFieldInspection.getPROBLEM_2(), ProblemHighlightType.WEAK_WARNING, fixes);
                                    }
                                }
                                return;
                            }
                            if (access.isRead() && canBeDefined.get() == Boolean.TRUE && canBeUndefined.get() == Boolean.TRUE) {
                                holder.registerProblem(psi, PhpBundle.message("inspection.probably.undefined.property", new Object[0]), ProblemHighlightType.WEAK_WARNING, new LocalQuickFix[0]);
                                return;
                            }
                        }
                        holder.registerProblem(this.createDescriptor(psi, reference, reachability, type));
                    }
                }
            }

            private ProblemDescriptor createDescriptor(PsiElement nameIdentifier, FieldReference methodReference, PhpUndefinedMethodInspection.Reachability reachability, PhpType type) {
                LocalQuickFix[] fixes = PhpUndefinedFieldInspection.isClassQuickFixApplicable(nameIdentifier.getProject(), nameIdentifier) ? PhpRenameWrongReferenceQuickFix.appendQuickFix((PhpReference)methodReference, FIXES) : LocalQuickFix.EMPTY_ARRAY;
                int reachabilityChoice = reachability == PhpUndefinedMethodInspection.Reachability.MIGHT_BE_DEFINED ? 1 : 0;
                String template = isOnTheFly ? PhpBundle.message("property.is.undefined.in.class", type.toStringRelativized(methodReference.getNamespaceName()), reachabilityChoice) : PhpBundle.message("property.is.undefined", reachabilityChoice);
                ProblemHighlightType highlightType = reachability == PhpUndefinedMethodInspection.Reachability.MIGHT_BE_DEFINED ? ProblemHighlightType.WEAK_WARNING : ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
                return InspectionManager.getInstance((Project)nameIdentifier.getProject()).createProblemDescriptor(nameIdentifier, template, isOnTheFly, fixes, highlightType);
            }

            private boolean isDynamicFieldReference(@NotNull ASTNode nameNode) {
                if (nameNode == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (PhpPsiUtil.isOfType(nameNode, PhpStubElementTypes.VARIABLE)) {
                    PsiElement prevSibling = nameNode.getPsi().getPrevSibling();
                    if (PhpPsiUtil.isOfType(prevSibling, PhpTokenTypes.SCOPE_RESOLUTION)) {
                        PsiElement child = PhpPsiUtil.getChildOfType(nameNode.getPsi(), PhpStubElementTypes.VARIABLE);
                        return child != null;
                    }
                    return true;
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameNode", "com/jetbrains/php/lang/inspections/PhpUndefinedFieldInspection$1", "isDynamicFieldReference"));
            }
        };
    }

    private static boolean isExplicitlyNotDefined(FieldReference reference) {
        PhpExpression classReference = reference.getClassReference();
        if (classReference == null) {
            return false;
        }
        Ref canBeDefined = new Ref((Object)false);
        Ref canBeUndefined = new Ref((Object)false);
        PhpUndefinedFieldInspection.processDfaReachability(reference, (Ref<Boolean>)canBeDefined, (Ref<Boolean>)canBeUndefined, new MyReachingDefinitionDFAnalyzer((PsiElement)classReference, reference.getName(), null){

            @Override
            @NotNull
            public PhpReachingDefinitionDFAnalyzer.Result performDFA(@NotNull PhpConditionInstruction instruction) {
                if (instruction == null) {
                    2.$$$reportNull$$$0(0);
                }
                PhpReachingDefinitionDFAnalyzer.Result result = this.performDFA(instruction.getCondition(), !instruction.getResult());
                if (result == null) {
                    2.$$$reportNull$$$0(1);
                }
                return result;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "instruction";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpUndefinedFieldInspection$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpUndefinedFieldInspection$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "performDFA";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "performDFA";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        return (Boolean)canBeDefined.get() != false && (Boolean)canBeUndefined.get() == false;
    }

    public static boolean isTraitWithMagicMethodsInAllUsages(@NotNull PhpType type, @NotNull PhpIndex index, @NotNull String magicMethod) {
        List traitUsages;
        if (type == null) {
            PhpUndefinedFieldInspection.$$$reportNull$$$0(1);
        }
        if (index == null) {
            PhpUndefinedFieldInspection.$$$reportNull$$$0(2);
        }
        if (magicMethod == null) {
            PhpUndefinedFieldInspection.$$$reportNull$$$0(3);
        }
        if ((traitUsages = type.getTypes().stream().flatMap(t -> index.getTraitsByFQN(t).stream()).flatMap(trait -> index.getTraitUsages(trait).stream()).collect(Collectors.toList())).isEmpty()) {
            return false;
        }
        return traitUsages.stream().map(PhpTypedElement::getType).allMatch(ut -> PhpCodeInsightUtil.hasMagicMethod(ut, index, magicMethod));
    }

    public static void processDfaReachability(FieldReference reference, Ref<Boolean> canBeDefined, Ref<Boolean> canBeUndefined) {
        PhpExpression classReference = reference.getClassReference();
        if (classReference == null) {
            return;
        }
        PhpUndefinedFieldInspection.processDfaReachability(reference, canBeDefined, canBeUndefined, new MyReachingDefinitionDFAnalyzer((PsiElement)classReference, reference.getName(), null));
    }

    public static void processDfaReachability(FieldReference reference, Ref<Boolean> canBeDefined, Ref<Boolean> canBeUndefined, MyReachingDefinitionDFAnalyzer analyzer) {
        PhpAccessFieldByVariableInstruction instruction = PhpControlFlowUtil.getAccessInstruction((PhpPsiElement)reference, PhpAccessFieldByVariableInstruction.class);
        if (instruction != null) {
            if (instruction.getAccess().isLightRead()) {
                canBeDefined.set((Object)true);
                canBeUndefined.set((Object)false);
                return;
            }
            PhpExpression classReference = reference.getClassReference();
            if (classReference == null) {
                return;
            }
            String fieldName = reference.getName();
            PhpUndefinedFieldInspection.processReachability(classReference, fieldName, (PhpInstruction)instruction, canBeDefined, canBeUndefined, null, analyzer);
        }
    }

    @NotNull
    public static PhpUndefinedMethodInspection.Reachability getReachability(FieldReference reference, Ref<Boolean> canBeDefined, Ref<Boolean> canBeUndefined) {
        PhpExpression classReference = reference.getClassReference();
        if (classReference == null) {
            PhpUndefinedMethodInspection.Reachability reachability = PhpUndefinedMethodInspection.Reachability.UNDEFINED;
            if (reachability == null) {
                PhpUndefinedFieldInspection.$$$reportNull$$$0(4);
            }
            return reachability;
        }
        PhpUndefinedFieldInspection.processDfaReachability(reference, canBeDefined, canBeUndefined);
        if (((Boolean)canBeDefined.get()).booleanValue() && !((Boolean)canBeUndefined.get()).booleanValue()) {
            PhpUndefinedMethodInspection.Reachability reachability = PhpUndefinedMethodInspection.Reachability.DEFINED;
            if (reachability == null) {
                PhpUndefinedFieldInspection.$$$reportNull$$$0(5);
            }
            return reachability;
        }
        PhpAccessInstruction classReferenceAccessInstruction = PhpControlFlowUtil.getAccessInstruction((PhpPsiElement)classReference, PhpAccessInstruction.class);
        String fieldName = reference.getName();
        if (fieldName != null) {
            PhpUndefinedMethodInspection.Reachability reachability = PhpUndefinedMethodInspection.performReachingDefinition(new PhpFieldExistsReachingDFAnalyzer(classReference, fieldName), classReferenceAccessInstruction);
            if (reachability == null) {
                PhpUndefinedFieldInspection.$$$reportNull$$$0(6);
            }
            return reachability;
        }
        PhpUndefinedMethodInspection.Reachability reachability = PhpUndefinedMethodInspection.Reachability.UNDEFINED;
        if (reachability == null) {
            PhpUndefinedFieldInspection.$$$reportNull$$$0(7);
        }
        return reachability;
    }

    public static boolean noResolvedDeclarationExists(PhpReference reference) {
        Object[] elements = reference.multiResolve(false);
        return elements.length == 0 || ContainerUtil.and((Object[])elements, e -> e.getElement() instanceof FieldReferenceImpl.DynamicallyDeclaredField);
    }

    public static void processReachability(@NotNull PhpExpression classReference, @Nullable String fieldName, PhpInstruction instruction, Ref<Boolean> canBeDefined, Ref<Boolean> canBeUndefined, @Nullable Consumer<FieldReference> fieldNameProcessor) {
        if (classReference == null) {
            PhpUndefinedFieldInspection.$$$reportNull$$$0(8);
        }
        PhpUndefinedFieldInspection.processReachability(classReference, fieldName, instruction, canBeDefined, canBeUndefined, fieldNameProcessor, new MyReachingDefinitionDFAnalyzer((PsiElement)classReference, fieldName, fieldNameProcessor));
    }

    private static void processReachability(final @NotNull PhpExpression classReference, final @Nullable String fieldName, PhpInstruction instruction, final Ref<Boolean> canBeDefined, final Ref<Boolean> canBeUndefined, final @Nullable Consumer<FieldReference> fieldNameProcessor, final MyReachingDefinitionDFAnalyzer analyzer) {
        if (classReference == null) {
            PhpUndefinedFieldInspection.$$$reportNull$$$0(9);
        }
        PhpControlFlowUtil.processPredecessorsIgnoreInitialBackEdges(instruction, false, new PhpInstructionProcessor(){

            public boolean processConditionInstruction(PhpConditionInstruction conditionInstruction) {
                return conditionInstruction.getCondition() == null || ((PhpReachingDefinitionDFAnalyzer.Result)analyzer.performDFA(conditionInstruction)).apply((Ref<Boolean>)canBeDefined, (Ref<Boolean>)canBeUndefined);
            }

            public boolean processEntryPointInstruction(PhpEntryPointInstruction instruction) {
                canBeUndefined.set((Object)true);
                return true;
            }

            public boolean processAccessFieldByVariableInstruction(PhpAccessFieldByVariableInstruction instruction) {
                FieldReference writeFieldRef;
                PhpAccessInstruction.Access access = instruction.getAccess();
                return !access.isWrite() && !access.isWriteRef() || (writeFieldRef = (FieldReference)ObjectUtils.tryCast((Object)instruction.getAnchor(), FieldReference.class)) == null || this.processWriteFieldRef(writeFieldRef);
            }

            private boolean processWriteFieldRef(FieldReference writeFieldRef) {
                PhpExpression writeClassRef = writeFieldRef.getClassReference();
                if (writeClassRef != null && PsiEquivalenceUtil.areElementsEquivalent((PsiElement)classReference, (PsiElement)writeClassRef)) {
                    if (fieldNameProcessor != null) {
                        fieldNameProcessor.accept(writeFieldRef);
                    }
                    if (fieldName != null && PhpLangUtil.equalsClassNames(writeFieldRef.getName(), fieldName)) {
                        canBeDefined.set((Object)true);
                        return false;
                    }
                }
                return true;
            }

            public boolean processArrayAccessInstruction(PhpArrayAccessInstruction instruction) {
                PhpAccessInstruction.Access access = instruction.getAccess();
                if (access.isWrite() || access.isWriteRef()) {
                    FieldReference writeFieldRef;
                    ArrayAccessExpression arrayAccess = (ArrayAccessExpression)ObjectUtils.tryCast((Object)instruction.getAnchor(), ArrayAccessExpression.class);
                    FieldReference fieldReference = writeFieldRef = arrayAccess != null ? (FieldReference)ObjectUtils.tryCast((Object)arrayAccess.getValue(), FieldReference.class) : null;
                    if (writeFieldRef != null && !this.processWriteFieldRef(writeFieldRef)) {
                        return false;
                    }
                }
                return true;
            }
        });
    }

    private boolean isNotifyAccessViaMagicMethod() {
        return this.NOTIFY_ACCESS_VIA_MAGIC_METHOD;
    }

    private boolean isNotifyDynamicDeclaration() {
        return this.NOTIFY_DYNAMIC_DECLARATION;
    }

    @Override
    public void resetOptions() {
        super.resetOptions();
        this.NOTIFY_ACCESS_VIA_MAGIC_METHOD = false;
        this.NOTIFY_DYNAMIC_DECLARATION = false;
        this.WARN_ON_MIXED = false;
    }

    @Override
    public JComponent createOptionsPanel() {
        return new OptionsPanel().getComponent();
    }

    private static boolean isClassQuickFixApplicable(Project project, PsiElement element) {
        MemberReference reference = (MemberReference)PsiTreeUtil.getParentOfType((PsiElement)element, MemberReference.class, (boolean)false);
        if (reference == null) {
            return false;
        }
        PhpClass klass = PhpQuickFixBase.resolveClass(reference, true);
        if (klass == null) {
            return false;
        }
        return ModuleUtilCore.projectContainsFile((Project)project, (VirtualFile)klass.getContainingFile().getVirtualFile(), (boolean)false);
    }

    @InspectionMessage
    private static String getPROBLEM_1() {
        return PhpBundle.message("inspection.undefined.field.problem1", new Object[0]);
    }

    @InspectionMessage
    private static String getPROBLEM_2() {
        return PhpBundle.message("inspection.undefined.field.problem2", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "magicMethod";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpUndefinedFieldInspection";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpUndefinedFieldInspection";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getReachability";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isTraitWithMagicMethodsInAllUsages";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processReachability";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class PhpFieldExistsReachingDFAnalyzer
    extends PhpUndefinedMethodInspection.PhpEntityDefinedViaFunctionCallDFAnalyzer {
        public PhpFieldExistsReachingDFAnalyzer(PhpExpression classReference, String name) {
            super(classReference, name);
        }

        @Override
        @NotNull
        protected String getDefiningFunctionName() {
            return "property_exists";
        }
    }

    private static class MyReachingDefinitionDFAnalyzer
    extends PhpReachingDefinitionDFAnalyzer {
        @NotNull
        private final PsiElement myReference;
        private final String myName;
        @Nullable
        private final Consumer<FieldReference> myFieldNameProcessor;

        private MyReachingDefinitionDFAnalyzer(@NotNull PsiElement classReference, @Nullable String fieldName, @Nullable Consumer<FieldReference> fieldNameProcessor) {
            if (classReference == null) {
                MyReachingDefinitionDFAnalyzer.$$$reportNull$$$0(0);
            }
            this.myReference = classReference;
            this.myName = fieldName;
            this.myFieldNameProcessor = fieldNameProcessor;
        }

        @Override
        @NotNull
        public PhpReachingDefinitionDFAnalyzer.Result performDFA(@Nullable PsiElement condition, boolean result) {
            if (condition instanceof PhpIsset) {
                PhpReachingDefinitionDFAnalyzer.Result dfaResult = new PhpReachingDefinitionDFAnalyzer.Result();
                if (result) {
                    for (PhpExpression expression : ((PhpIsset)condition).getVariables()) {
                        if (!this.processExpression(dfaResult, expression)) break;
                    }
                }
                PhpReachingDefinitionDFAnalyzer.Result result2 = dfaResult;
                if (result2 == null) {
                    MyReachingDefinitionDFAnalyzer.$$$reportNull$$$0(1);
                }
                return result2;
            }
            if (condition instanceof PhpEmpty) {
                PhpReachingDefinitionDFAnalyzer.Result dfaResult = new PhpReachingDefinitionDFAnalyzer.Result();
                if (!result) {
                    for (PhpExpression expression : ((PhpEmpty)condition).getVariables()) {
                        if (!this.processExpression(dfaResult, expression)) break;
                    }
                }
                PhpReachingDefinitionDFAnalyzer.Result result3 = dfaResult;
                if (result3 == null) {
                    MyReachingDefinitionDFAnalyzer.$$$reportNull$$$0(2);
                }
                return result3;
            }
            PhpReachingDefinitionDFAnalyzer.Result result4 = (PhpReachingDefinitionDFAnalyzer.Result)super.performDFA(condition, result);
            if (result4 == null) {
                MyReachingDefinitionDFAnalyzer.$$$reportNull$$$0(3);
            }
            return result4;
        }

        private boolean processExpression(PhpReachingDefinitionDFAnalyzer.Result dfaResult, PhpExpression expression) {
            PhpExpression issetClassReference;
            if (expression instanceof FieldReference && (issetClassReference = ((FieldReference)expression).getClassReference()) != null && PsiEquivalenceUtil.areElementsEquivalent((PsiElement)issetClassReference, (PsiElement)this.myReference)) {
                String issetFieldName = expression.getName();
                if (this.myFieldNameProcessor != null) {
                    this.myFieldNameProcessor.accept((FieldReference)expression);
                }
                if (this.myName != null && PhpLangUtil.equalsClassNames(this.myName, issetFieldName)) {
                    dfaResult.setDefined(true);
                    return false;
                }
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classReference";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpUndefinedFieldInspection$MyReachingDefinitionDFAnalyzer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpUndefinedFieldInspection$MyReachingDefinitionDFAnalyzer";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "performDFA";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public class OptionsPanel {
        private JPanel myOptionsPanel;
        private JBCheckBox myNotifyAccessMagicCheckBox;
        private JBCheckBox myNotifyDynamicDeclarationCheckBox;
        private JCheckBox myWarnOnMixed;

        public OptionsPanel() {
            this.$$$setupUI$$$();
            this.myNotifyAccessMagicCheckBox.setSelected(PhpUndefinedFieldInspection.this.NOTIFY_ACCESS_VIA_MAGIC_METHOD);
            this.myNotifyAccessMagicCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PhpUndefinedFieldInspection.this.NOTIFY_ACCESS_VIA_MAGIC_METHOD = OptionsPanel.this.myNotifyAccessMagicCheckBox.isSelected();
                }
            });
            this.myNotifyDynamicDeclarationCheckBox.setSelected(PhpUndefinedFieldInspection.this.NOTIFY_DYNAMIC_DECLARATION);
            this.myNotifyDynamicDeclarationCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PhpUndefinedFieldInspection.this.NOTIFY_DYNAMIC_DECLARATION = OptionsPanel.this.myNotifyDynamicDeclarationCheckBox.isSelected();
                }
            });
            this.myWarnOnMixed.setSelected(PhpUndefinedFieldInspection.this.WARN_ON_MIXED);
            this.myWarnOnMixed.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PhpUndefinedFieldInspection.this.WARN_ON_MIXED = OptionsPanel.this.myWarnOnMixed.isSelected();
                }
            });
        }

        public JPanel getComponent() {
            return this.myOptionsPanel;
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JCheckBox jCheckBox;
            JBCheckBox jBCheckBox;
            JBCheckBox jBCheckBox2;
            JPanel jPanel;
            this.myOptionsPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            Spacer spacer = new Spacer();
            jPanel2.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
            this.myNotifyAccessMagicCheckBox = jBCheckBox2 = new JBCheckBox();
            this.$$$loadButtonText$$$((AbstractButton)jBCheckBox2, DynamicBundle.getBundle((String)"messages/PhpBundle", OptionsPanel.class).getString("inspection.undefined.field.notify.access.magic.method"));
            jPanel2.add((Component)jBCheckBox2, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
            Spacer spacer2 = new Spacer();
            jPanel.add((Component)spacer2, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            this.myNotifyDynamicDeclarationCheckBox = jBCheckBox = new JBCheckBox();
            this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/PhpBundle", OptionsPanel.class).getString("inspection.undefined.field.notify.dynamic.declaration"));
            jPanel3.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
            Spacer spacer3 = new Spacer();
            jPanel3.add((Component)spacer3, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
            this.myWarnOnMixed = jCheckBox = new JCheckBox();
            jCheckBox.setSelected(false);
            this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/PhpBundle", OptionsPanel.class).getString("inspection.undefined.member.warnOnMixed"));
            jPanel.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myOptionsPanel;
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }
}

