/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.ResolveResult;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessConstantInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.dataFlow.reachingDefinition.PhpDFAUtil;
import com.jetbrains.php.codeInsight.dataFlow.reachingDefinition.PhpReachingDefinitionsDFAnalyzer;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.PhpSimpleFunctionDefinedDFAnalyzer;
import com.jetbrains.php.lang.inspections.quickfix.PhpImportConstantQuickFix;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;

public class PhpUndefinedConstantInspection
extends PhpInspection {
    private static final LocalQuickFix[] FIXES = new LocalQuickFix[]{PhpImportConstantQuickFix.INSTANCE};
    public static final String DEFINED = "defined";
    public static final PhpReachingDefinitionsDFAnalyzer DF_ANALYZER = new PhpSimpleFunctionDefinedDFAnalyzer("defined");

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpUndefinedConstantInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpConstantReference(ConstantReference reference) {
                String name = reference.getName();
                if (StringUtil.isEmptyOrSpaces((String)name)) {
                    return;
                }
                ASTNode nameNode = reference.getNameNode();
                if (nameNode == null) {
                    return;
                }
                if (PhpLangUtil.isBuiltInConstant(name)) {
                    return;
                }
                ResolveResult[] results = ((PsiPolyVariantReference)reference.getReference()).multiResolve(false);
                if (results.length == 0) {
                    Ref canBeDefined = Ref.create((Object)false);
                    Ref canBeUndefined = Ref.create((Object)false);
                    PhpUndefinedConstantInspection.processDfaReachability(reference, (Ref<Boolean>)canBeDefined, (Ref<Boolean>)canBeUndefined);
                    if (!((Boolean)canBeDefined.get()).booleanValue()) {
                        holder.registerProblem(nameNode.getPsi(), PhpUndefinedConstantInspection.getPROBLEM_1(), FIXES);
                    } else if (((Boolean)canBeUndefined.get()).booleanValue()) {
                        holder.registerProblem(nameNode.getPsi(), PhpUndefinedConstantInspection.getPROBLEM_2(), new LocalQuickFix[0]);
                    }
                }
            }
        };
    }

    public static void processDfaReachability(ConstantReference reference, Ref<Boolean> canBeDefined, Ref<Boolean> canBeUndefined) {
        PhpAccessConstantInstruction instruction = PhpControlFlowUtil.getAccessInstruction((PhpPsiElement)reference, PhpAccessConstantInstruction.class);
        String name = reference.getName();
        if (instruction != null && name != null) {
            PhpDFAUtil.performReachingDefinitions((PhpInstruction)instruction, canBeDefined, canBeUndefined, name, DF_ANALYZER);
        }
    }

    @InspectionMessage
    private static String getPROBLEM_1() {
        return PhpBundle.message("inspection.undefined.constant.problem1", new Object[0]);
    }

    @InspectionMessage
    private static String getPROBLEM_2() {
        return PhpBundle.message("inspection.undefined.constant.problem2", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/PhpUndefinedConstantInspection", "buildVisitor"));
    }
}

