/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.DynamicBundle;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpFieldType;
import com.jetbrains.php.lang.psi.elements.PhpParameterType;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpReturnType;
import com.jetbrains.php.lang.psi.elements.PhpTypeDeclaration;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;

public abstract class PhpUndefinedClassInspectionBase
extends PhpInspection {
    public boolean DONT_INSPECT_DOCS = false;

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpUndefinedClassInspectionBase.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpDocType(PhpDocType type) {
                if (PhpUndefinedClassInspectionBase.this.isInspectDocs()) {
                    return;
                }
                ASTNode nameNode = type.getNameNode();
                if (nameNode == null) {
                    return;
                }
                String name = type.getName();
                assert (name != null);
                PhpType phpType = type.getGlobalType();
                if (PhpType.isArray((PhpType)phpType) && PsiTreeUtil.findChildOfType((PsiElement)type, PhpDocType.class) != null) {
                    return;
                }
                if (StringUtil.startsWithChar((CharSequence)(name = StringUtil.trimEnd((String)name, (String)"[]")), (char)'$') || PhpUndefinedClassInspectionBase.isPrimitiveType(phpType)) {
                    return;
                }
                PsiElement anchor = nameNode.getPsi();
                ResolveResult[] results = ((PsiPolyVariantReference)type.getReference()).multiResolve(false);
                PhpUndefinedClassInspectionBase.this.checkClassResolveResult((PhpReference)type, name, anchor, results, holder, isOnTheFly);
            }

            public void visitPhpClassReference(ClassReference reference) {
                ASTNode nameNode = reference.getNameNode();
                if (nameNode == null) {
                    return;
                }
                String name = reference.getName();
                assert (name != null);
                if (StringUtil.startsWithChar((CharSequence)name, (char)'$')) {
                    return;
                }
                PsiElement parent = reference.getParent();
                Project project = reference.getProject();
                if (parent instanceof PhpTypeDeclaration && PhpUndefinedClassInspectionBase.isSuitableTypeDeclarationForPosition(project, (PhpTypeDeclaration)parent, name) || PhpType.isPrimitiveType((String)name) && (parent instanceof PhpTypeDeclaration && PhpUndefinedClassInspectionBase.primitiveTypesMightBeInTypeDeclaration((PhpTypeDeclaration)parent, name) || PhpPsiUtil.getParentByCondition((PsiElement)reference, true, (Condition<? super PsiElement>)PhpDocComment.INSTANCEOF) != null)) {
                    return;
                }
                PsiElement anchor = nameNode.getPsi();
                if (parent instanceof PhpUse) {
                    String fqn = reference.getFQN();
                    if (PhpIndex.getInstance((Project)project).getChildNamespacesByParentName(fqn + "\\").size() > 0) {
                        return;
                    }
                    if (PhpIndex.getInstance((Project)project).getNamespacesByName(fqn).size() > 0) {
                        return;
                    }
                }
                ResolveResult[] results = ((PsiPolyVariantReference)reference.getReference()).multiResolve(false);
                PhpUndefinedClassInspectionBase.this.checkClassResolveResult((PhpReference)reference, name, anchor, results, holder, isOnTheFly);
            }
        };
    }

    protected abstract void checkClassResolveResult(PhpReference var1, String var2, PsiElement var3, ResolveResult[] var4, @NotNull ProblemsHolder var5, boolean var6);

    private static boolean isPrimitiveType(PhpType type) {
        return !type.isEmpty() && type.filterOut(t -> PhpType.isPrimitiveType((String)PhpType.unpluralize((String)t))).isEmpty();
    }

    private static boolean primitiveTypesMightBeInTypeDeclaration(PhpTypeDeclaration typeDeclaration, String name) {
        PhpType type = new PhpType().add(name);
        if (PhpType.VOID.equals((Object)type) && PhpLanguageFeature.RETURN_VOID.isSupported(typeDeclaration.getProject())) {
            return true;
        }
        return PhpUndefinedClassInspectionBase.isFalseOrNullCanBeUsedInTypeDeclaration(typeDeclaration, name);
    }

    public static boolean isFalseOrNullCanBeUsedInTypeDeclaration(@NotNull PhpTypeDeclaration typeDeclaration, @NotNull String name) {
        PhpType type;
        if (typeDeclaration == null) {
            PhpUndefinedClassInspectionBase.$$$reportNull$$$0(1);
        }
        if (name == null) {
            PhpUndefinedClassInspectionBase.$$$reportNull$$$0(2);
        }
        if (!PhpType.FALSE.equals((Object)(type = new PhpType().add(name))) && !PhpType.NULL.equals((Object)type)) {
            return false;
        }
        return typeDeclaration.getClassReferences().size() > 1 || PhpLanguageFeature.UNION_TYPES.isSupported(typeDeclaration.getProject());
    }

    public static boolean isSuitableTypeDeclarationForPosition(Project project, @NotNull PhpTypeDeclaration position, String typeDecl) {
        if (position == null) {
            PhpUndefinedClassInspectionBase.$$$reportNull$$$0(3);
        }
        return position instanceof PhpParameterType && PhpLangUtil.isParameterTypeHint(typeDecl, project) || position instanceof PhpReturnType && PhpLangUtil.isReturnTypeHint(typeDecl, project) && (!"static".equalsIgnoreCase(typeDecl) || PhpPsiUtil.getParentByCondition((PsiElement)position, (Condition<? super PsiElement>)PhpClass.INSTANCEOF) != null) || position instanceof PhpFieldType && PhpUndefinedClassInspectionBase.isFieldTypeHint(project, typeDecl);
    }

    public boolean isInspectDocs() {
        return this.DONT_INSPECT_DOCS;
    }

    @Override
    public JComponent createOptionsPanel() {
        return new OptionsPanel().getComponent();
    }

    private static boolean isFieldTypeHint(@NotNull Project project, @NotNull String name) {
        if (project == null) {
            PhpUndefinedClassInspectionBase.$$$reportNull$$$0(4);
        }
        if (name == null) {
            PhpUndefinedClassInspectionBase.$$$reportNull$$$0(5);
        }
        return !PhpType.isCallableType((String)PhpLangUtil.toFQN(name)) && PhpLangUtil.isParameterTypeHint(name, project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeDeclaration";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpUndefinedClassInspectionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isFalseOrNullCanBeUsedInTypeDeclaration";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isSuitableTypeDeclarationForPosition";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isFieldTypeHint";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public class OptionsPanel {
        private JPanel myOptionsPanel;
        private JCheckBox myDontInspectDocs;

        public OptionsPanel() {
            this.$$$setupUI$$$();
            this.myDontInspectDocs.setSelected(PhpUndefinedClassInspectionBase.this.DONT_INSPECT_DOCS);
            ChangeListener listener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PhpUndefinedClassInspectionBase.this.DONT_INSPECT_DOCS = OptionsPanel.this.myDontInspectDocs.isSelected();
                }
            };
            this.myDontInspectDocs.getModel().addChangeListener(listener);
        }

        public JPanel getComponent() {
            return this.myOptionsPanel;
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JCheckBox jCheckBox;
            JPanel jPanel;
            this.myOptionsPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
            this.myDontInspectDocs = jCheckBox = new JCheckBox();
            jCheckBox.setSelected(false);
            this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/PhpBundle", OptionsPanel.class).getString("inspection.undefined.class.ignore.phpdoc"));
            jPanel.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myOptionsPanel;
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }
}

