/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.dataFlow.reachingDefinition.PhpDFAUtil;
import com.jetbrains.php.codeInsight.dataFlow.reachingDefinition.PhpReachingDefinitionsDFAnalyzer;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.lang.inspections.PhpFqnSimpleFunctionDefinedDfaAnalyzer;
import com.jetbrains.php.lang.inspections.PhpUndefinedClassInspectionBase;
import com.jetbrains.php.lang.inspections.quickfix.PhpImportClassQuickFix;
import com.jetbrains.php.lang.inspections.quickfix.createClass.PhpCreateClassQuickFix;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import java.util.Collection;
import java.util.Comparator;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;

public class PhpUndefinedClassInspection
extends PhpUndefinedClassInspectionBase {
    private static final PhpReachingDefinitionsDFAnalyzer DF_ANALYZER = new PhpFqnSimpleFunctionDefinedDfaAnalyzer("class_exists");

    @Override
    protected void checkClassResolveResult(PhpReference reference, String name, PsiElement anchor, ResolveResult[] results, @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpUndefinedClassInspection.$$$reportNull$$$0(0);
        }
        if (results.length == 0) {
            if (reference instanceof ClassReference) {
                Ref canBeDefined = Ref.create((Object)false);
                Ref canBeUndefined = Ref.create((Object)false);
                PhpUndefinedClassInspection.processDfaReachability((ClassReference)reference, (Ref<Boolean>)canBeDefined, (Ref<Boolean>)canBeUndefined);
                if (((Boolean)canBeDefined.get()).booleanValue() && !((Boolean)canBeUndefined.get()).booleanValue()) {
                    return;
                }
            }
            holder.registerProblem(anchor, PhpBundle.message("inspection.php.undefined.class.description2", new Object[0]), PhpUndefinedClassInspection.getUndefinedClassFixes(reference, isOnTheFly));
        }
    }

    public static void processDfaReachability(ClassReference reference, Ref<Boolean> canBeDefined, Ref<Boolean> canBeUndefined) {
        PhpInstruction instruction = PhpUndefinedClassInspection.findNearestInstruction((PsiElement)reference);
        String name = reference.getFQN();
        if (instruction != null && name != null) {
            PhpDFAUtil.performReachingDefinitions(instruction, canBeDefined, canBeUndefined, name, DF_ANALYZER);
        }
    }

    public static PhpInstruction findNearestInstruction(PsiElement anchor) {
        PhpInstruction[] instructions;
        PhpScopeHolder scopeHolder = PhpPsiUtil.getScopeHolder(anchor);
        if (scopeHolder == null) {
            return null;
        }
        TreeSet<PhpInstruction> nearestInstruction = new TreeSet<PhpInstruction>(Comparator.comparingInt(i -> i.getAnchor() != null ? i.getAnchor().getTextRange().getLength() : Integer.MAX_VALUE));
        for (PhpInstruction instruction : instructions = scopeHolder.getControlFlow().getInstructions()) {
            if (!PsiTreeUtil.isAncestor((PsiElement)instruction.getAnchor(), (PsiElement)anchor, (boolean)false)) continue;
            nearestInstruction.add(instruction);
        }
        return (PhpInstruction)ContainerUtil.getFirstItem(nearestInstruction);
    }

    private static LocalQuickFix @NotNull [] getUndefinedClassFixes(@NotNull PhpReference reference, boolean isOnTheFly) {
        if (reference == null) {
            PhpUndefinedClassInspection.$$$reportNull$$$0(1);
        }
        SmartList fixes = new SmartList();
        Collection<PhpClass> candidates = PhpImportClassQuickFix.INSTANCE.getCandidates(reference.getProject(), reference);
        if (candidates.size() > 0 && (isOnTheFly || candidates.size() == 1)) {
            fixes.add(PhpImportClassQuickFix.INSTANCE);
        }
        if (isOnTheFly && (!PhpCreateClassQuickFix.isClassReferenceToTrait(reference) || PhpLanguageFeature.TRAITS.isSupported(reference.getProject()))) {
            fixes.add(candidates.isEmpty() ? PhpCreateClassQuickFix.INSTANCE : PhpCreateClassQuickFix.LOW_PRIORITY_INSTANCE);
        }
        LocalQuickFix[] localQuickFixArray = fixes.toArray(LocalQuickFix.EMPTY_ARRAY);
        if (localQuickFixArray == null) {
            PhpUndefinedClassInspection.$$$reportNull$$$0(2);
        }
        return localQuickFixArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpUndefinedClassInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpUndefinedClassInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getUndefinedClassFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkClassResolveResult";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getUndefinedClassFixes";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

