/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.dataFlow.reachingDefinition.PhpDFAUtil;
import com.jetbrains.php.codeInsight.dataFlow.reachingDefinition.PhpReachingDefinitionsDFAnalyzer;
import com.jetbrains.php.lang.PhpCodeUtil;
import com.jetbrains.php.lang.inspections.PhpFqnSimpleFunctionDefinedDfaAnalyzer;
import com.jetbrains.php.lang.inspections.PhpUndefinedClassInspection;
import com.jetbrains.php.lang.inspections.PhpUndefinedFieldInspection;
import com.jetbrains.php.lang.inspections.PhpUndefinedMemberInspection;
import com.jetbrains.php.lang.inspections.quickfix.PhpQuickFixBase;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

public class PhpUndefinedClassConstantInspection
extends PhpUndefinedMemberInspection {
    private static final AddConstantDeclarationQuickFix FIX = new AddConstantDeclarationQuickFix();
    private static final LocalQuickFix[] FIXES = new LocalQuickFix[]{FIX};
    private static final PhpReachingDefinitionsDFAnalyzer DF_ANALYZER = new PhpFqnSimpleFunctionDefinedDfaAnalyzer("defined");

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpUndefinedClassConstantInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpClassConstantReference(ClassConstantReference reference) {
                this.checkConstantReference((MemberReference)reference, reference.getClassReference(), classReference -> !PhpUndefinedFieldInspection.noResolvedDeclarationExists(classReference));
            }

            public void visitPhpFieldReference(FieldReference fieldReference) {
                if (!PhpPsiUtil.classConstantReferenceViaVariable(fieldReference)) {
                    return;
                }
                this.checkConstantReference((MemberReference)fieldReference, fieldReference.getClassReference(), x$0 -> PhpUndefinedClassConstantInspection.classReferenceIsResolved(x$0));
            }

            private void checkConstantReference(MemberReference reference, PhpExpression classReference, Predicate<PhpReference> classReferenceIsResolved) {
                ASTNode nameNode = reference.getNameNode();
                if (nameNode == null || nameNode.getElementType() == PhpTokenTypes.kwCLASS) {
                    return;
                }
                if (classReference instanceof PhpReference && classReferenceIsResolved.test((PhpReference)classReference) && reference.multiResolve(false).length == 0) {
                    Ref canBeUndefined = new Ref((Object)false);
                    Ref canBeDefined = new Ref((Object)false);
                    PhpUndefinedClassConstantInspection.performDfaReachability(reference, (PhpReference)classReference, (Ref<Boolean>)canBeDefined, (Ref<Boolean>)canBeUndefined);
                    if (((Boolean)canBeDefined.get()).booleanValue() && !((Boolean)canBeUndefined.get()).booleanValue()) {
                        return;
                    }
                    Project project = reference.getProject();
                    PhpType type = classReference.getGlobalType();
                    String template = isOnTheFly ? PhpBundle.message("constant.ref.not.found.in", type.toStringRelativized(reference.getNamespaceName())) : PhpBundle.message("inspection.message.constant.ref.not.found", new Object[0]);
                    LocalQuickFix[] fixes = PhpQuickFixBase.resolveClass(reference, false) != null ? FIXES : LocalQuickFix.EMPTY_ARRAY;
                    holder.registerProblem(nameNode.getPsi(), template, fixes);
                }
            }
        };
    }

    public static void performDfaReachability(MemberReference reference, PhpReference classReference, Ref<Boolean> canBeDefined, Ref<Boolean> canBeUndefined) {
        PhpInstruction instruction = PhpUndefinedClassInspection.findNearestInstruction((PsiElement)reference);
        String name = reference.getName();
        if (instruction != null && name != null) {
            PhpDFAUtil.performReachingDefinitions(instruction, canBeDefined, canBeUndefined, classReference.getFQN() + "::" + name, DF_ANALYZER);
        }
    }

    private static boolean classReferenceIsResolved(@NotNull PhpReference reference) {
        if (reference == null) {
            PhpUndefinedClassConstantInspection.$$$reportNull$$$0(1);
        }
        PhpIndex index = PhpIndex.getInstance((Project)reference.getProject());
        return reference.getGlobalType().getTypes().stream().anyMatch(type -> !index.getAnyByFQN(type).isEmpty());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpUndefinedClassConstantInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "classReferenceIsResolved";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class AddConstantDeclarationQuickFix
    extends PhpQuickFixBase {
        AddConstantDeclarationQuickFix() {
        }

        @NotNull
        public String getName() {
            String string = PhpBundle.message("add.constant.declaration.quick.fix.text", new Object[0]);
            if (string == null) {
                AddConstantDeclarationQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                AddConstantDeclarationQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element;
            MemberReference reference;
            PhpClass klass;
            if (project == null) {
                AddConstantDeclarationQuickFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                AddConstantDeclarationQuickFix.$$$reportNull$$$0(3);
            }
            if ((klass = AddConstantDeclarationQuickFix.resolveClass(reference = (MemberReference)PsiTreeUtil.getParentOfType((PsiElement)(element = descriptor.getPsiElement()), MemberReference.class, (boolean)false), false)) != null) {
                ASTNode semicolon;
                PsiElement problem = descriptor.getPsiElement();
                Field field = PhpPsiElementFactory.createFromText(klass.getProject(), Field.class, "class c { const " + problem.getText() + " = ;}");
                assert (field != null);
                PsiElement inserted = PhpCodeEditUtil.insertClassMember(klass, field.getParent());
                ASTNode insertedNode = inserted.getNode();
                if (insertedNode != null && insertedNode.getElementType() == PhpElementTypes.CLASS_CONSTANTS && (semicolon = insertedNode.findChildByType(PhpTokenTypes.opSEMICOLON)) != null) {
                    PhpCodeUtil.openRelatedFile(project, semicolon.getPsi());
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpUndefinedClassConstantInspection$AddConstantDeclarationQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpUndefinedClassConstantInspection$AddConstantDeclarationQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

