/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.intentions.array.PhpConvertToShortArraySyntaxIntention;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;

public class PhpTraditionalSyntaxArrayLiteralInspection
extends PhpInspection {
    public static final LocalQuickFix[] FIXES = new LocalQuickFix[]{new PhpConvertToShortArrayQuickFix()};

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpTraditionalSyntaxArrayLiteralInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpArrayCreationExpression(ArrayCreationExpression expression) {
                PsiElement arrayKw;
                PhpLanguageLevel preferableLanguageLevel;
                if (!expression.isShortSyntax() && PhpTraditionalSyntaxArrayLiteralInspection.isTopMost(expression) && (preferableLanguageLevel = PhpProjectConfigurationFacade.getInstance(expression.getProject()).getLanguageLevel()).hasFeature(PhpLanguageFeature.SHORT_ARRAY_SYNTAX) && PhpPsiUtil.isOfType(arrayKw = expression.getFirstChild(), PhpTokenTypes.kwARRAY)) {
                    holder.registerProblem(arrayKw, PhpTraditionalSyntaxArrayLiteralInspection.getProblemDescription(), FIXES);
                }
            }
        };
    }

    private static boolean isTopMost(ArrayCreationExpression expression) {
        return PhpPsiUtil.getParentByCondition((PsiElement)expression, (Condition<? super PsiElement>)((Condition)element -> element instanceof ArrayCreationExpression && !((ArrayCreationExpression)element).isShortSyntax())) == null;
    }

    @InspectionMessage
    private static String getProblemDescription() {
        return PhpBundle.message("inspection.traditional.syntax.array.literal.detected", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/PhpTraditionalSyntaxArrayLiteralInspection", "buildVisitor"));
    }

    static class PhpConvertToShortArrayQuickFix
    implements LocalQuickFix {
        private final PhpConvertToShortArraySyntaxIntention converter = new PhpConvertToShortArraySyntaxIntention();

        PhpConvertToShortArrayQuickFix() {
        }

        @NotNull
        public String getName() {
            String string = PhpBundle.message("intention.name.convert.array.syntax.to.short", new Object[0]);
            if (string == null) {
                PhpConvertToShortArrayQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.converter.getFamilyName();
            if (string == null) {
                PhpConvertToShortArrayQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                PhpConvertToShortArrayQuickFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                PhpConvertToShortArrayQuickFix.$$$reportNull$$$0(3);
            }
            Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
            PsiElement element = descriptor.getPsiElement();
            if (element != null) {
                this.converter.invoke(project, editor, element);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpTraditionalSyntaxArrayLiteralInspection$PhpConvertToShortArrayQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpTraditionalSyntaxArrayLiteralInspection$PhpConvertToShortArrayQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

