/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.DynamicBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.fields.IntegerField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.refactoring.PhpRefactoringUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpTooManyParametersInspection
extends PhpInspection {
    private static final int DEFAULT_BRANCH_LIMIT = 5;
    public int limit = 5;
    public boolean ignoreConstructors = true;

    @Override
    @Nullable
    public JComponent createOptionsPanel() {
        return new OptionsPanel().getComponent();
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpTooManyParametersInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpFunction(Function function) {
                if (function instanceof Method) {
                    return;
                }
                if (function.getParameters().length > PhpTooManyParametersInspection.this.limit) {
                    PsiElement kwFunction;
                    PsiElement nameIdentifier = function.getNameIdentifier();
                    if (nameIdentifier != null) {
                        holder.registerProblem(nameIdentifier, PhpTooManyParametersInspection.getMessage(), new LocalQuickFix[0]);
                    } else if (function.isClosure() && (kwFunction = PhpPsiUtil.getChildOfType((PsiElement)function, PhpTokenTypes.kwFUNCTION)) != null && kwFunction.getContainingFile() == holder.getFile()) {
                        holder.registerProblem(kwFunction, PhpTooManyParametersInspection.getMessage(), new LocalQuickFix[0]);
                    }
                }
            }

            public void visitPhpClass(PhpClass clazz) {
                Method[] methods;
                for (Method it : methods = clazz.getOwnMethods()) {
                    PhpTooManyParametersInspection.this.processMethod(it, holder);
                }
            }
        };
    }

    private void processMethod(Method method, ProblemsHolder holder) {
        PsiElement nameIdentifier;
        if (this.ignoreConstructors && PhpRefactoringUtil.isElementConstructor((PsiElement)method)) {
            return;
        }
        if (method.getParameters().length > this.limit && (nameIdentifier = method.getNameIdentifier()) != null) {
            holder.registerProblem(nameIdentifier, PhpTooManyParametersInspection.getMessage(), new LocalQuickFix[0]);
        }
    }

    @InspectionMessage
    public static String getMessage() {
        return PhpBundle.message("inspection.too.many.parameters", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/PhpTooManyParametersInspection", "buildVisitor"));
    }

    public class OptionsPanel {
        private JBCheckBox myIgnoreConstructorCheckBox;
        private IntegerField myNumberOfParamsField;
        private JPanel myMainPanel;

        public OptionsPanel() {
            this.$$$setupUI$$$();
            this.myNumberOfParamsField.setValue(Integer.valueOf(PhpTooManyParametersInspection.this.limit));
            this.myNumberOfParamsField.getValueEditor().addListener(newValue -> {
                PhpTooManyParametersInspection.this.limit = this.myNumberOfParamsField.getValue();
            });
            this.myIgnoreConstructorCheckBox.setSelected(PhpTooManyParametersInspection.this.ignoreConstructors);
            this.myIgnoreConstructorCheckBox.getModel().addChangeListener(e -> {
                PhpTooManyParametersInspection.this.ignoreConstructors = this.myIgnoreConstructorCheckBox.isSelected();
            });
        }

        public JComponent getComponent() {
            return this.myMainPanel;
        }

        private /* synthetic */ void $$$setupUI$$$() {
            IntegerField integerField;
            JBCheckBox jBCheckBox;
            JPanel jPanel;
            this.myMainPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 3, 0, 2, 1, 6, null, null, null));
            Spacer spacer2 = new Spacer();
            jPanel.add((Component)spacer2, new GridConstraints(0, 2, 1, 2, 0, 1, 6, 1, null, null, null));
            this.myIgnoreConstructorCheckBox = jBCheckBox = new JBCheckBox();
            jPanel.add((Component)jBCheckBox, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, null, null));
            JLabel jLabel = new JLabel();
            this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/PhpBundle", OptionsPanel.class).getString("inspection.too.many.parameters.ignore.constructors"));
            jPanel.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            JLabel jLabel2 = new JLabel();
            this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/PhpBundle", OptionsPanel.class).getString("inspection.too.many.parameters.max.number.of.parameters"));
            jPanel.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myNumberOfParamsField = integerField = new IntegerField();
            jPanel.add((Component)integerField, new GridConstraints(0, 1, 1, 1, 0, 0, 3, 3, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myMainPanel;
        }

        private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            jLabel.setText(stringBuffer.toString());
            if (bl) {
                jLabel.setDisplayedMnemonic(c);
                jLabel.setDisplayedMnemonicIndex(n);
            }
        }
    }
}

