/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.util.EditorHelper;
import com.intellij.json.psi.JsonElementGenerator;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonPsiUtil;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.gist.GistManager;
import com.intellij.util.gist.PsiFileGist;
import com.intellij.util.io.BooleanDataDescriptor;
import com.intellij.util.io.DataExternalizer;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.composer.ComposerConfigUtils;
import com.jetbrains.php.composer.ComposerDataService;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.config.composer.LanguageLevelComposerParser;
import java.util.Objects;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpSwitchComposerLanguageLevelQuickFix
implements LocalQuickFix {
    protected final PhpLanguageLevel myTargetLevel;
    @Nls
    protected final String myMessage;
    private static final String GIST_ID = "PhpComposerLanguageLevelVersionCanBeReplaced";
    private static final int VERSION = 1;
    private static final PsiFileGist<Boolean> COMPOSER_LANGUAGE_LEVEL_VERSION_CAN_BE_REPLACED = GistManager.getInstance().newPsiFileGist("PhpComposerLanguageLevelVersionCanBeReplaced", 1, (DataExternalizer)BooleanDataDescriptor.INSTANCE, file -> {
        JsonProperty property = PhpSwitchComposerLanguageLevelQuickFix.findPhpProperty(file);
        if (property == null) {
            return false;
        }
        JsonStringLiteral propertyValue = (JsonStringLiteral)ObjectUtils.tryCast((Object)property.getValue(), JsonStringLiteral.class);
        if (propertyValue == null) {
            return false;
        }
        String data = propertyValue.getValue();
        LanguageLevelComposerParser.ParsedComposerLanguageLevel singleLanguageLevel = LanguageLevelComposerParser.parseSingleLanguageLevel(data);
        return singleLanguageLevel != null && singleLanguageLevel.isConcreteVersionSpecified() && singleLanguageLevel.isInclusiveHigher();
    });

    protected PhpSwitchComposerLanguageLevelQuickFix(PhpLanguageLevel level, @Nls String message) {
        this.myTargetLevel = level;
        this.myMessage = message;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = this.myMessage;
        if (string == null) {
            PhpSwitchComposerLanguageLevelQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    protected void doFix(@NotNull JsonProperty phpRequireProperty, @NotNull JsonStringLiteral phpRequirePropertyValue) {
        LanguageLevelComposerParser.ParsedComposerLanguageLevel level;
        if (phpRequireProperty == null) {
            PhpSwitchComposerLanguageLevelQuickFix.$$$reportNull$$$0(1);
        }
        if (phpRequirePropertyValue == null) {
            PhpSwitchComposerLanguageLevelQuickFix.$$$reportNull$$$0(2);
        }
        if ((level = LanguageLevelComposerParser.parseSingleLanguageLevel(phpRequirePropertyValue.getValue())) == null) {
            return;
        }
        JsonStringLiteral updatedVersionLiteral = new JsonElementGenerator(phpRequireProperty.getProject()).createStringLiteral(level.getPrefix() + this.myTargetLevel.getPresentableName());
        phpRequirePropertyValue.replace((PsiElement)updatedVersionLiteral);
    }

    @Nullable
    public static JsonProperty findPhpProperty(PsiFile file) {
        JsonObject requirePropertyBody;
        if (!(file instanceof JsonFile)) {
            return null;
        }
        JsonObject jsonObject = (JsonObject)ObjectUtils.tryCast((Object)file.getFirstChild(), JsonObject.class);
        if (jsonObject == null) {
            return null;
        }
        JsonProperty requireProperty = PhpSwitchComposerLanguageLevelQuickFix.findPropertyByAnyName(jsonObject, "require");
        JsonObject jsonObject2 = requirePropertyBody = requireProperty != null ? (JsonObject)ObjectUtils.tryCast((Object)requireProperty.getValue(), JsonObject.class) : null;
        if (requirePropertyBody == null) {
            return null;
        }
        return PhpSwitchComposerLanguageLevelQuickFix.findPropertyByAnyName(requirePropertyBody, ComposerConfigUtils.PHP_PROPERTIES_NAMES);
    }

    @Nullable
    private static JsonProperty findPropertyByAnyName(JsonObject jsonObject, String ... names) {
        return StreamEx.of((Object[])names).map(arg_0 -> ((JsonObject)jsonObject).findProperty(arg_0)).findFirst(Objects::nonNull).orElse(null);
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        JsonProperty property;
        if (project == null) {
            PhpSwitchComposerLanguageLevelQuickFix.$$$reportNull$$$0(3);
        }
        if (descriptor == null) {
            PhpSwitchComposerLanguageLevelQuickFix.$$$reportNull$$$0(4);
        }
        if ((property = PhpSwitchComposerLanguageLevelQuickFix.getComposerPhpLevelProperty(project)) == null) {
            return;
        }
        JsonStringLiteral propertyValue = (JsonStringLiteral)ObjectUtils.tryCast((Object)property.getValue(), JsonStringLiteral.class);
        if (propertyValue == null) {
            return;
        }
        this.doFix(property, propertyValue);
    }

    @Nullable
    public static JsonProperty getComposerPhpLevelProperty(@NotNull Project project) {
        VirtualFile file;
        if (project == null) {
            PhpSwitchComposerLanguageLevelQuickFix.$$$reportNull$$$0(5);
        }
        if ((file = ComposerDataService.getInstance(project).getConfigFile()) == null) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        return PhpSwitchComposerLanguageLevelQuickFix.findPhpProperty(psiFile);
    }

    @NotNull
    private static LocalQuickFix getManualInstance(@NotNull PhpLanguageLevel level) {
        if (level == null) {
            PhpSwitchComposerLanguageLevelQuickFix.$$$reportNull$$$0(6);
        }
        return new PhpSwitchComposerLanguageLevelManuallyQuickFix(level, PhpBundle.message("inspection.language.level.quick.fix.switch.language.level.in.composer.manually.0", level.getPresentableName()));
    }

    @NotNull
    private static LocalQuickFix getInstance(@NotNull PhpLanguageLevel level) {
        if (level == null) {
            PhpSwitchComposerLanguageLevelQuickFix.$$$reportNull$$$0(7);
        }
        return new PhpSwitchComposerLanguageLevelQuickFix(level, PhpBundle.message("inspection.language.level.quick.fix.switch.language.level.in.composer.0", level.getPresentableName()));
    }

    private static boolean composerLanguageLevelCanBeSafelyReplaced(@NotNull Project project) {
        VirtualFile virtualFileConfig;
        if (project == null) {
            PhpSwitchComposerLanguageLevelQuickFix.$$$reportNull$$$0(8);
        }
        PsiFile file = (virtualFileConfig = ComposerDataService.getInstance(project).getConfigFile()) != null ? PsiManager.getInstance((Project)project).findFile(virtualFileConfig) : null;
        return file != null && COMPOSER_LANGUAGE_LEVEL_VERSION_CAN_BE_REPLACED.getFileData(file) == Boolean.TRUE;
    }

    public static LocalQuickFix getInstance(@NotNull Project project, @NotNull PhpLanguageLevel preferableLanguageLevel, boolean onTheFly) {
        if (project == null) {
            PhpSwitchComposerLanguageLevelQuickFix.$$$reportNull$$$0(9);
        }
        if (preferableLanguageLevel == null) {
            PhpSwitchComposerLanguageLevelQuickFix.$$$reportNull$$$0(10);
        }
        if (PhpSwitchComposerLanguageLevelQuickFix.composerLanguageLevelCanBeSafelyReplaced(project)) {
            return PhpSwitchComposerLanguageLevelQuickFix.getInstance(preferableLanguageLevel);
        }
        return onTheFly ? PhpSwitchComposerLanguageLevelQuickFix.getManualInstance(preferableLanguageLevel) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpSwitchComposerLanguageLevelQuickFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpRequireProperty";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpRequirePropertyValue";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preferableLanguageLevel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpSwitchComposerLanguageLevelQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doFix";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getComposerPhpLevelProperty";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getManualInstance";
                break;
            }
            case 7: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "composerLanguageLevelCanBeSafelyReplaced";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PhpSwitchComposerLanguageLevelManuallyQuickFix
    extends PhpSwitchComposerLanguageLevelQuickFix {
        protected PhpSwitchComposerLanguageLevelManuallyQuickFix(PhpLanguageLevel targetLevel, @Nls String message) {
            super(targetLevel, message);
        }

        @Override
        protected void doFix(@NotNull JsonProperty phpRequireProperty, @NotNull JsonStringLiteral phpRequirePropertyValue) {
            Editor editor;
            if (phpRequireProperty == null) {
                PhpSwitchComposerLanguageLevelManuallyQuickFix.$$$reportNull$$$0(0);
            }
            if (phpRequirePropertyValue == null) {
                PhpSwitchComposerLanguageLevelManuallyQuickFix.$$$reportNull$$$0(1);
            }
            if ((editor = EditorHelper.openInEditor((PsiElement)phpRequireProperty)) == null) {
                return;
            }
            WriteAction.run(() -> this.runLiveTemplateOnPhpProperty(phpRequireProperty, phpRequirePropertyValue, editor));
        }

        private void runLiveTemplateOnPhpProperty(JsonProperty property, JsonStringLiteral propertyValue, Editor editor) {
            String text = propertyValue.getText();
            if (text.length() <= 2) {
                return;
            }
            TemplateBuilderImpl builder = new TemplateBuilderImpl((PsiElement)property);
            builder.replaceElement((PsiElement)propertyValue, TextRange.create((int)1, (int)(text.length() - 1)), (Expression)this.getExpression(text));
            TemplateManager.getInstance((Project)property.getProject()).startTemplate(editor, builder.buildInlineTemplate());
        }

        @NotNull
        private ConstantNode getExpression(String text) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return new ConstantNode(this.myTargetLevel.getPresentableName());
            }
            ConstantNode constantNode = new ConstantNode(JsonPsiUtil.stripQuotes((String)text)).withLookupStrings(new String[]{this.myTargetLevel.getPresentableName()});
            if (constantNode == null) {
                PhpSwitchComposerLanguageLevelManuallyQuickFix.$$$reportNull$$$0(2);
            }
            return constantNode;
        }

        public boolean startInWriteAction() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "phpRequireProperty";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "phpRequirePropertyValue";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpSwitchComposerLanguageLevelQuickFix$PhpSwitchComposerLanguageLevelManuallyQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpSwitchComposerLanguageLevelQuickFix$PhpSwitchComposerLanguageLevelManuallyQuickFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExpression";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "doFix";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

