/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.DynamicBundle;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.ui.LevelChooserAction;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.php.lang.inspections.PhpInspection;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class PhpStaticVsDynamicInspectionBase
extends PhpInspection {
    public boolean SHOW_FOR_MAGIC = true;
    public String MAGIC_HIGHLIGHT_LEVEL_NAME;

    public PhpStaticVsDynamicInspectionBase() {
        this.MAGIC_HIGHLIGHT_LEVEL_NAME = HighlightSeverity.WEAK_WARNING.myName;
    }

    public boolean isShowForMagic() {
        return this.SHOW_FOR_MAGIC;
    }

    HighlightSeverity getMagicLevel() {
        return InspectionProfileManager.getInstance().getSeverityRegistrar().getSeverity(this.MAGIC_HIGHLIGHT_LEVEL_NAME);
    }

    ProblemHighlightType getMagicHighlightType() {
        HighlightSeverity level = this.getMagicLevel();
        return PhpStaticVsDynamicInspectionBase.getProblemHighlightType(level);
    }

    public static ProblemHighlightType getProblemHighlightType(HighlightSeverity level) {
        if (level == HighlightSeverity.ERROR) {
            return ProblemHighlightType.GENERIC_ERROR;
        }
        if (level == HighlightSeverity.WARNING) {
            return ProblemHighlightType.WARNING;
        }
        if (level == HighlightSeverity.WEAK_WARNING) {
            return ProblemHighlightType.WEAK_WARNING;
        }
        if (level == HighlightSeverity.INFORMATION) {
            return ProblemHighlightType.INFORMATION;
        }
        return ProblemHighlightType.INFORMATION;
    }

    void setMagicLevel(HighlightDisplayLevel level) {
        this.MAGIC_HIGHLIGHT_LEVEL_NAME = level.getSeverity().myName;
    }

    @Override
    public JComponent createOptionsPanel() {
        return new OptionsPanel(this).getComponent();
    }

    public class OptionsPanel {
        private LevelChooserAction mySeverityLevelChooser;
        private JPanel myOptionsPanel;
        private JCheckBox myDowngradeSeverity;
        private JPanel mySeverityPanel;
        private final PhpStaticVsDynamicInspectionBase myInspection;

        public OptionsPanel(PhpStaticVsDynamicInspectionBase inspection) {
            this.myInspection = inspection;
            this.$$$setupUI$$$();
            this.myDowngradeSeverity.setSelected(PhpStaticVsDynamicInspectionBase.this.SHOW_FOR_MAGIC);
            this.myDowngradeSeverity.getModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PhpStaticVsDynamicInspectionBase.this.SHOW_FOR_MAGIC = OptionsPanel.this.myDowngradeSeverity.isSelected();
                }
            });
            this.mySeverityLevelChooser.setChosen(this.myInspection.getMagicLevel());
        }

        private void createUIComponents() {
            this.mySeverityPanel = new JPanel();
            this.mySeverityPanel.setLayout(new BorderLayout());
            this.mySeverityLevelChooser = new LevelChooserAction(InspectionProfileManager.getInstance().getSeverityRegistrar()){

                protected void onChosen(HighlightSeverity severity) {
                    OptionsPanel.this.myInspection.setMagicLevel(HighlightDisplayLevel.find((HighlightSeverity)severity));
                }
            };
            this.mySeverityPanel.add(this.mySeverityLevelChooser.createCustomComponent(this.mySeverityLevelChooser.getTemplatePresentation(), "unknown"));
        }

        public JPanel getComponent() {
            return this.myOptionsPanel;
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JCheckBox jCheckBox;
            JPanel jPanel;
            this.createUIComponents();
            this.myOptionsPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
            this.myDowngradeSeverity = jCheckBox = new JCheckBox();
            jCheckBox.setSelected(false);
            this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/PhpBundle", OptionsPanel.class).getString("inspection.severity.with.magic"));
            jPanel.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 2, 0, 2, 1, 6, null, null, null));
            JPanel jPanel2 = this.mySeverityPanel;
            jPanel.add((Component)jPanel2, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
            Spacer spacer2 = new Spacer();
            jPanel.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myOptionsPanel;
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }
}

