/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.impl.PhpPromotedFieldParameterImpl;
import com.jetbrains.php.refactoring.PhpRefactoringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpReplacePromotedFieldWithTraditionalQuickFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    protected PhpReplacePromotedFieldWithTraditionalQuickFix(@Nullable Parameter element) {
        super((PsiElement)element);
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            PhpReplacePromotedFieldWithTraditionalQuickFix.$$$reportNull$$$0(0);
        }
        if (file == null) {
            PhpReplacePromotedFieldWithTraditionalQuickFix.$$$reportNull$$$0(1);
        }
        if (startElement == null) {
            PhpReplacePromotedFieldWithTraditionalQuickFix.$$$reportNull$$$0(2);
        }
        if (endElement == null) {
            PhpReplacePromotedFieldWithTraditionalQuickFix.$$$reportNull$$$0(3);
        }
        PhpPromotedFieldParameterImpl promotedField = (PhpPromotedFieldParameterImpl)startElement;
        PhpModifier modifier = promotedField.getModifier();
        PhpClass containingClass = (PhpClass)PhpPsiUtil.getParentByCondition(startElement, (Condition<? super PsiElement>)PhpClass.INSTANCEOF);
        PsiElement visibility = PhpPsiUtil.getChildOfType(startElement, PhpTokenTypes.tsVISIBILITY_MODIFIERS);
        if (visibility == null || containingClass == null) {
            return;
        }
        PsiElement defaultValue = promotedField.getDefaultValue();
        String fieldName = promotedField.getName();
        PhpPsiElement traditionalField = PhpPsiElementFactory.createClassField(project, modifier, fieldName, defaultValue != null ? defaultValue.getText() : null, PhpRefactoringUtil.createFieldTypeDeclaration(project, promotedField.getDeclaredType(), (PsiElement)containingClass));
        PhpCodeEditUtil.insertClassMember(containingClass, (PsiElement)traditionalField);
        visibility.delete();
        Object gs = PhpPsiUtil.getChildByCondition(PhpPsiUtil.getParentByCondition((PsiElement)promotedField, (Condition<? super PsiElement>)Method.INSTANCEOF), (Condition<? super PsiElement>)GroupStatement.INSTANCEOF);
        assert (gs != null);
        AssignmentExpression assignmentExpression = PhpPsiElementFactory.createPhpPsiFromText(project, AssignmentExpression.class, String.format("$this->%s =%s $%s;", fieldName, promotedField.isPassByRef() ? "&" : "", fieldName));
        gs.addAfter(assignmentExpression.getParent(), gs.getFirstChild());
    }

    @IntentionName
    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            PhpReplacePromotedFieldWithTraditionalQuickFix.$$$reportNull$$$0(4);
        }
        return string;
    }

    @IntentionFamilyName
    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("intention.family.name.replace.with.traditional.property.declaration", new Object[0]);
        if (string == null) {
            PhpReplacePromotedFieldWithTraditionalQuickFix.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpReplacePromotedFieldWithTraditionalQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpReplacePromotedFieldWithTraditionalQuickFix";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

