/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.elements.TernaryExpression;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpReplaceNestedTernaryExpressionQuickFixBase
extends LocalQuickFixOnPsiElement {
    protected PhpReplaceNestedTernaryExpressionQuickFixBase(@NotNull TernaryExpression element) {
        if (element == null) {
            PhpReplaceNestedTernaryExpressionQuickFixBase.$$$reportNull$$$0(0);
        }
        super((PsiElement)element);
    }

    @NotNull
    public String getText() {
        String text;
        TernaryExpression element = (TernaryExpression)ObjectUtils.tryCast((Object)this.myStartElement.getElement(), TernaryExpression.class);
        if (element != null && (text = this.getAssociativeTernaryExpressionText(element)) != null) {
            String string = PhpBundle.message("replace.with.0", StringUtil.first((String)text.replaceAll("[\t\n]", ""), (int)25, (boolean)true));
            if (string == null) {
                PhpReplaceNestedTernaryExpressionQuickFixBase.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = this.getFamilyName();
        if (string == null) {
            PhpReplaceNestedTernaryExpressionQuickFixBase.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        TernaryExpression expression;
        if (project == null) {
            PhpReplaceNestedTernaryExpressionQuickFixBase.$$$reportNull$$$0(3);
        }
        if (file == null) {
            PhpReplaceNestedTernaryExpressionQuickFixBase.$$$reportNull$$$0(4);
        }
        if (startElement == null) {
            PhpReplaceNestedTernaryExpressionQuickFixBase.$$$reportNull$$$0(5);
        }
        if (endElement == null) {
            PhpReplaceNestedTernaryExpressionQuickFixBase.$$$reportNull$$$0(6);
        }
        if ((expression = (TernaryExpression)ObjectUtils.tryCast((Object)startElement, TernaryExpression.class)) == null) {
            return;
        }
        String newExpressionText = this.getAssociativeTernaryExpressionText(expression);
        if (newExpressionText == null) {
            return;
        }
        expression.replace((PsiElement)PhpPsiElementFactory.createPhpPsiFromText(expression.getProject(), TernaryExpression.class, newExpressionText));
    }

    @Nullable
    protected abstract String getAssociativeTernaryExpressionText(TernaryExpression var1);

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("quickfix.replace.nested.ternary.expression", this.getAssociativity());
        if (string == null) {
            PhpReplaceNestedTernaryExpressionQuickFixBase.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    protected abstract String getAssociativity();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpReplaceNestedTernaryExpressionQuickFixBase";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpReplaceNestedTernaryExpressionQuickFixBase";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 7: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

