/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpRenameWrongReferenceQuickFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private static final String CURRENT_VAR = "CURRENT_VAR";
    private static final String OTHER_VAR = "OTHER_VAR";

    public PhpRenameWrongReferenceQuickFix(@Nullable PsiElement element) {
        super(element);
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            PhpRenameWrongReferenceQuickFix.$$$reportNull$$$0(0);
        }
        if (file == null) {
            PhpRenameWrongReferenceQuickFix.$$$reportNull$$$0(1);
        }
        if (startElement == null) {
            PhpRenameWrongReferenceQuickFix.$$$reportNull$$$0(2);
        }
        if (endElement == null) {
            PhpRenameWrongReferenceQuickFix.$$$reportNull$$$0(3);
        }
        if (editor == null) {
            return;
        }
        PhpReference reference = (PhpReference)startElement;
        PhpScopeHolder scopeHolder = PhpPsiUtil.getScopeHolder((PsiElement)reference);
        if (scopeHolder == null) {
            return;
        }
        List sameReferences = ContainerUtil.filter((Collection)PsiTreeUtil.findChildrenOfType((PsiElement)scopeHolder, reference.getClass()), r -> r.getClass() == reference.getClass() && PhpRenameWrongReferenceQuickFix.isSameReference(r, reference));
        Template template = PhpRenameWrongReferenceQuickFix.buildTemplate(scopeHolder, editor, reference, sameReferences);
        if (template == null) {
            return;
        }
        TemplateManager.getInstance((Project)project).startTemplate(editor, template);
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            PhpRenameWrongReferenceQuickFix.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("php.rename.wrong.reference.quick.fix.family.name", new Object[0]);
        if (string == null) {
            PhpRenameWrongReferenceQuickFix.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nullable
    private static Template buildTemplate(PhpScopeHolder scopeHolder, Editor editor, PhpReference originalReference, Collection<PhpReference> referencesWithSameClass) {
        PsiElement nameNode = PhpRenameWrongReferenceQuickFix.extractElementToRename(originalReference);
        if (nameNode == null) {
            return null;
        }
        TemplateBuilderImpl builder = new TemplateBuilderImpl((PsiElement)scopeHolder);
        ConstantNode expression = new ConstantNode(StringUtil.notNullize((String)originalReference.getName())).withLookupStrings(PhpRenameWrongReferenceQuickFix.getClassReferenceMembersNames(originalReference));
        for (PhpReference reference : referencesWithSameClass) {
            PsiElement element = PhpRenameWrongReferenceQuickFix.extractElementToRename(reference);
            if (element == null) continue;
            if (reference.equals(originalReference)) {
                builder.replaceElement(element, CURRENT_VAR, (Expression)expression, true);
                continue;
            }
            builder.replaceElement(element, OTHER_VAR, CURRENT_VAR, false);
        }
        editor.getCaretModel().moveToOffset(scopeHolder.getTextRange().getStartOffset());
        return builder.buildInlineTemplate();
    }

    private static String[] getClassReferenceMembersNames(PhpReference originalReference) {
        PhpExpression classReference;
        PhpExpression phpExpression = classReference = originalReference instanceof MemberReference ? ((MemberReference)originalReference).getClassReference() : null;
        if (classReference == null) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        PhpIndex index = PhpIndex.getInstance((Project)classReference.getProject());
        return (String[])((StreamEx)((StreamEx)StreamEx.of((Collection)classReference.getGlobalType().getTypes()).filter(PhpLangUtil::isFqn)).flatMap(fqn -> index.getAnyByFQN(fqn).stream()).flatMap(aClass -> Arrays.stream(originalReference instanceof MethodReference ? aClass.getOwnMethods() : aClass.getOwnFields())).map(rec$ -> ((PhpNamedElement)rec$).getName()).distinct()).toArray(String.class);
    }

    @Nullable
    private static PsiElement extractElementToRename(PhpReference reference) {
        ASTNode node = reference.getNameNode();
        return node != null ? node.getPsi() : null;
    }

    private static boolean isSameReference(PhpReference first, PhpReference second) {
        PsiElement f = first.getFirstChild();
        PsiElement s = second.getFirstChild();
        while (f != null) {
            if (s == null) {
                return true;
            }
            if (!PsiEquivalenceUtil.areElementsEquivalent((PsiElement)f, (PsiElement)s)) {
                return false;
            }
            if (f.getNode() == first.getNameNode() || s.getNode() == second.getNode()) {
                return true;
            }
            f = PhpPsiUtil.getNextSiblingIgnoreWhitespace(f, true);
            s = PhpPsiUtil.getNextSiblingIgnoreWhitespace(s, true);
        }
        return s != null;
    }

    public static LocalQuickFix @NotNull [] appendQuickFix(PhpReference reference, LocalQuickFix[] fixes) {
        LocalQuickFix[] localQuickFixArray = (LocalQuickFix[])ArrayUtil.append((Object[])fixes, (Object)((Object)new PhpRenameWrongReferenceQuickFix((PsiElement)reference)));
        if (localQuickFixArray == null) {
            PhpRenameWrongReferenceQuickFix.$$$reportNull$$$0(6);
        }
        return localQuickFixArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpRenameWrongReferenceQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpRenameWrongReferenceQuickFix";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "appendQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

