/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.changeSignature.CallerChooserBase;
import com.intellij.refactoring.changeSignature.MemberNodeBase;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpRemoveMethodWithPropagationQuickFix;
import com.jetbrains.php.lang.inspections.PhpSafeDeleteCallerChooserBase;
import com.jetbrains.php.lang.inspections.PhpUnusedParameterInspection;
import com.jetbrains.php.lang.inspections.quickfix.PhpRemoveParametersQuickFix;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.refactoring.PhpFunctionCodeGenerator;
import com.jetbrains.php.refactoring.changeSignature.PhpMethodNode;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JTree;
import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

class PhpRemoveParameterWithPropagationQuickFix
implements LocalQuickFix {
    PhpRemoveParameterWithPropagationQuickFix() {
    }

    @NotNull
    public String getFamilyName() {
        String string = PhpUnusedParameterInspection.REMOVE_PARAMETER.getFamilyName();
        if (string == null) {
            PhpRemoveParameterWithPropagationQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getName() {
        String string = PhpUnusedParameterInspection.REMOVE_PARAMETER.getName();
        if (string == null) {
            PhpRemoveParameterWithPropagationQuickFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            PhpRemoveParameterWithPropagationQuickFix.$$$reportNull$$$0(2);
        }
        if (descriptor == null) {
            PhpRemoveParameterWithPropagationQuickFix.$$$reportNull$$$0(3);
        }
        Parameter parameter = (Parameter)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), Parameter.class);
        List<Parameter> additionalParametersToRemove = PhpRemoveParameterWithPropagationQuickFix.getParametersSafeToDeleteAfterRemovalOfParameter(parameter);
        LinkedHashSet<Parameter> parametersToDelete = new LinkedHashSet<Parameter>();
        parametersToDelete.add(parameter);
        if (!additionalParametersToRemove.isEmpty()) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                parametersToDelete.addAll(additionalParametersToRemove);
            } else {
                CallerChooserBase<Parameter> callerChooser = PhpRemoveParameterWithPropagationQuickFix.createCallerChooser(project, parameter, parametersToDelete);
                TreeUtil.expand((JTree)callerChooser.getTree(), (int)2);
                if (!callerChooser.showAndGet()) {
                    return;
                }
            }
        }
        parametersToDelete.forEach(PhpRemoveParameterWithPropagationQuickFix::removeParameter);
    }

    private static void removeParameter(Parameter p) {
        Function function = (Function)PhpPsiUtil.getParentByCondition((PsiElement)p, (Condition<? super PsiElement>)Function.INSTANCEOF);
        if (function == null) {
            return;
        }
        PhpRemoveParametersQuickFix.removeParameters(function, Collections.singleton(p));
    }

    private static CallerChooserBase<Parameter> createCallerChooser(final Project project, Parameter parameter, Collection<Parameter> children) {
        return new PhpSafeDeleteCallerChooserBase<Parameter>(parameter, project, PhpBundle.message("dialog.title.select.parameters.to.propagate.safe.delete", new Object[0]), children::addAll){

            @Override
            protected MemberNodeBase<Parameter> createNode(Parameter element, HashSet<Parameter> called, Runnable cancelCallback) {
                return new PhpSafeDeleteParameterNode(project, element, called, cancelCallback);
            }

            protected Parameter[] findDeepestSuperMethods(Parameter method1) {
                return Parameter.EMPTY_ARRAY;
            }
        };
    }

    private static List<Parameter> getParametersSafeToDeleteAfterRemovalOfParameter(Parameter parameter) {
        Method method = (Method)PhpPsiUtil.getParentByCondition((PsiElement)parameter, (Condition<? super PsiElement>)Method.INSTANCEOF);
        if (method == null) {
            return Collections.emptyList();
        }
        PhpClass containingClass = method.getContainingClass();
        if (containingClass == null) {
            return Collections.emptyList();
        }
        Collection usedMethodReferencesInClassMethods = Arrays.stream(containingClass.getOwnMethods()).filter(m -> method != m && m.getAccess().isPrivate()).flatMap(m -> PhpRemoveParameterWithPropagationQuickFix.methodUsages(method, m)).collect(Collectors.toCollection(LinkedHashSet::new));
        return (List)((StreamEx)EntryStream.of(PhpRemoveParameterWithPropagationQuickFix.groupByContainingMethods(usedMethodReferencesInClassMethods)).mapToValue((containingMethod, calls) -> PhpRemoveParameterWithPropagationQuickFix.collectParametersUsedOnlyInCalls((Function)containingMethod, PhpRemoveParameterWithPropagationQuickFix.getParametersUsages(parameter, calls))).filterValues(parameters -> !parameters.isEmpty()).flatMapValues(Collection::stream).values().distinct()).collect(Collectors.toList());
    }

    private static Map<Method, List<FunctionReference>> groupByContainingMethods(Collection<FunctionReference> functionReferences) {
        return StreamEx.of(functionReferences.stream()).groupingBy(f -> (Method)PhpPsiUtil.getParentByCondition((PsiElement)f, (Condition<? super PsiElement>)Method.INSTANCEOF));
    }

    private static Stream<FunctionReference> methodUsages(Method method, Method methodToFindUsagesIn) {
        LinkedHashSet res = new LinkedHashSet();
        PhpRemoveMethodWithPropagationQuickFix.PhpSafeDeleteMemberNode.processCandidatesUsagesInMethod(methodToFindUsagesIn, Collections.singleton(method), e -> {
            if (e instanceof FunctionReference) {
                res.add((FunctionReference)e);
            }
        });
        return res.stream();
    }

    private static Collection<Variable> getParametersUsages(Parameter parameter, Collection<FunctionReference> calls) {
        Function function = (Function)PhpPsiUtil.getParentByCondition((PsiElement)parameter, (Condition<? super PsiElement>)Function.INSTANCEOF);
        assert (function != null);
        int parameterIndex = ArrayUtil.indexOf((Object[])function.getParameters(), (Object)parameter);
        return (Collection)((StreamEx)((StreamEx)StreamEx.of(calls).flatMap(f -> Arrays.stream(f.getParameters())).select(Variable.class).filter(v -> PhpWorkaroundUtil.resolveMappedParameterIndex((PsiElement)v) == parameterIndex)).distinct()).collect(Collectors.toList());
    }

    private static Collection<Parameter> collectParametersUsedOnlyInCalls(Function method, Collection<Variable> usagesInCalls) {
        Set usedVariableNames = ContainerUtil.map2Set(usagesInCalls, PhpNamedElement::getName);
        return Arrays.stream(method.getParameters()).filter(p -> usedVariableNames.contains(p.getName())).filter(p -> PhpRemoveParameterWithPropagationQuickFix.usedOnlyInCalls(p, method, usagesInCalls)).collect(Collectors.toList());
    }

    private static boolean usedOnlyInCalls(final Parameter p, Function method, final Collection<Variable> calls) {
        final Ref usedInCalls = new Ref((Object)false);
        final Ref usedOutsideCalls = new Ref((Object)false);
        PhpControlFlowUtil.processSuccessors((PhpInstruction)method.getControlFlow().getEntryPoint(), false, new PhpControlFlowUtil.PhpClosureVisitingInstructionProcessor(){

            public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                if (PhpLangUtil.equalsVariableNames(instruction.getVariableName(), p.getName())) {
                    PhpAccessInstruction.Access access = instruction.getAccess();
                    if (access.isWrite() || access.isWriteRef()) {
                        return false;
                    }
                    if (!calls.contains(instruction.getAnchor()) || access.isReadRef()) {
                        usedOutsideCalls.set((Object)true);
                        return false;
                    }
                    usedInCalls.set((Object)true);
                }
                return super.processAccessVariableInstruction(instruction);
            }
        });
        return (Boolean)usedInCalls.get() != false && (Boolean)usedOutsideCalls.get() == false;
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpRemoveParameterWithPropagationQuickFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpRemoveParameterWithPropagationQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PhpSafeDeleteParameterNode
    extends MemberNodeBase<Parameter> {
        private PhpSafeDeleteParameterNode(Project project, Parameter parameter, HashSet<Parameter> called, Runnable callback) {
            super((PsiElement)parameter, called, project, callback);
        }

        protected MemberNodeBase<Parameter> createNode(Parameter caller, HashSet<Parameter> called) {
            return new PhpSafeDeleteParameterNode(this.myProject, caller, called, this.myCancelCallback);
        }

        protected List<Parameter> computeCallers() {
            return PhpRemoveParameterWithPropagationQuickFix.getParametersSafeToDeleteAfterRemovalOfParameter((Parameter)this.getMember());
        }

        protected void customizeRendererText(ColoredTreeCellRenderer renderer) {
            Function function = (Function)PhpPsiUtil.getParentByCondition(this.getMember(), (Condition<? super PsiElement>)Function.INSTANCEOF);
            PhpMethodNode.doRenderMethod(renderer, function, this.isEnabled(), new PhpFunctionCodeGenerator.PhpFunctionDeclarationGenerator(){

                @Override
                protected Parameter[] getParameters(@NotNull Function function) {
                    if (function == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return new Parameter[]{(Parameter)this.getMember()};
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/jetbrains/php/lang/inspections/PhpRemoveParameterWithPropagationQuickFix$PhpSafeDeleteParameterNode$1", "getParameters"));
                }
            });
        }
    }
}

