/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.google.common.base.Predicates;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiEditorUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessFieldByVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.findUsages.PhpGotoTargetRendererProvider;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.PhpUndefinedFieldInspection;
import com.jetbrains.php.lang.inspections.PhpUndefinedMethodInspection;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.impl.MemberReferenceImpl;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.ListCellRenderer;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PhpPossiblePolymorphicInvocationInspection
extends PhpInspection {
    private static final LocalQuickFix[] FIXES = new LocalQuickFix[]{PhpFindClassesWithoutMemberInHierarchyQuickFix.INSTANCE};

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpPossiblePolymorphicInvocationInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpMethodReference(MethodReference reference) {
                PhpAccessInstruction instruction;
                PhpUndefinedMethodInspection.PhpMethodExistsReachingDFAnalyzer analyzer;
                String methodName = reference.getName();
                PhpExpression classReference = reference.getClassReference();
                if (classReference != null && methodName != null && PhpUndefinedMethodInspection.performReachingDefinition(analyzer = new PhpUndefinedMethodInspection.PhpMethodExistsReachingDFAnalyzer(classReference, methodName), instruction = PhpControlFlowUtil.getAccessInstruction((PhpPsiElement)analyzer.myClassReference, PhpAccessInstruction.class)) == PhpUndefinedMethodInspection.Reachability.DEFINED) {
                    return;
                }
                this.check((MemberReference)reference);
            }

            public void visitPhpFieldReference(FieldReference fieldReference) {
                PhpAccessFieldByVariableInstruction instruction = PhpControlFlowUtil.getAccessInstruction((PhpPsiElement)fieldReference, PhpAccessFieldByVariableInstruction.class);
                if (instruction != null && instruction.getAccess().isLightRead()) {
                    return;
                }
                if (PhpUndefinedFieldInspection.getReachability(fieldReference, (Ref<Boolean>)new Ref((Object)false), (Ref<Boolean>)new Ref((Object)false)) == PhpUndefinedMethodInspection.Reachability.DEFINED) {
                    return;
                }
                this.check((MemberReference)fieldReference);
            }

            private void check(@NotNull MemberReference memberReference) {
                List<PhpClass> classesWithAmbiguousPolymorphicDeclaration;
                ASTNode node;
                if (memberReference == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((node = memberReference.getNameNode()) == null) {
                    return;
                }
                if (MemberReferenceImpl.resolveInHierarchy(memberReference).isEmpty() && !(classesWithAmbiguousPolymorphicDeclaration = PhpPossiblePolymorphicInvocationInspection.getClassesWithAmbiguousPolymorphicDeclaration(memberReference)).isEmpty()) {
                    String message = classesWithAmbiguousPolymorphicDeclaration.size() == 1 ? PhpBundle.message("potentially.polymorphic.call.single.subclass", ((PhpClass)classesWithAmbiguousPolymorphicDeclaration.iterator().next()).getName()) : PhpBundle.message("potentially.polymorphic.call.multiple.subclasses", new Object[0]);
                    LocalQuickFix[] fixes = isOnTheFly && classesWithAmbiguousPolymorphicDeclaration.size() > 1 ? FIXES : LocalQuickFix.EMPTY_ARRAY;
                    holder.registerProblem(node.getPsi(), message, fixes);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberReference", "com/jetbrains/php/lang/inspections/PhpPossiblePolymorphicInvocationInspection$1", "check"));
            }
        };
    }

    private static List<PhpClass> getClassesWithAmbiguousPolymorphicDeclaration(@NotNull MemberReference memberReference) {
        PhpExpression classReference;
        if (memberReference == null) {
            PhpPossiblePolymorphicInvocationInspection.$$$reportNull$$$0(1);
        }
        if ((classReference = memberReference.getClassReference()) == null || classReference instanceof ClassReference && PhpLangUtil.isStaticReference((ClassReference)classReference)) {
            return Collections.emptyList();
        }
        Project project = memberReference.getProject();
        PhpIndex index = PhpIndex.getInstance((Project)project);
        return classReference.getGlobalType().getTypes().stream().flatMap(fqn -> index.getAnyByFQN(fqn).stream()).flatMap(phpClass -> PhpPossiblePolymorphicInvocationInspection.hasAmbiguousPolymorphicDeclaration(phpClass, memberReference)).distinct().collect(Collectors.toList());
    }

    private static Stream<PhpClass> hasAmbiguousPolymorphicDeclaration(PhpClass aClass, MemberReference memberReference) {
        if (MemberReferenceImpl.lookInSubclasses(aClass.getProject(), memberReference, aClass.getFQN()).limit(1L).count() < 1L) {
            return Stream.empty();
        }
        if (!aClass.isAbstract()) {
            return Stream.of(aClass);
        }
        return ((StreamEx)StreamEx.of((Collection)PhpIndex.getInstance((Project)aClass.getProject()).getAllSubclasses(aClass.getFQN())).filter((Predicate)Predicates.not(PhpClass::isAbstract))).filter(subClass -> ((MemberReferenceImpl)memberReference).resolveMember((PhpClass)subClass, false).isEmpty());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberReference";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpPossiblePolymorphicInvocationInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getClassesWithAmbiguousPolymorphicDeclaration";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class PhpFindClassesWithoutMemberInHierarchyQuickFix
    implements LocalQuickFix {
        private static final LocalQuickFix INSTANCE = new PhpFindClassesWithoutMemberInHierarchyQuickFix();

        private PhpFindClassesWithoutMemberInHierarchyQuickFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("find.classes.without.member", new Object[0]);
            if (string == null) {
                PhpFindClassesWithoutMemberInHierarchyQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            MemberReference memberReference;
            if (project == null) {
                PhpFindClassesWithoutMemberInHierarchyQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                PhpFindClassesWithoutMemberInHierarchyQuickFix.$$$reportNull$$$0(2);
            }
            if ((memberReference = (MemberReference)PhpPsiUtil.getParentByCondition(descriptor.getStartElement(), (Condition<? super PsiElement>)MemberReference.INSTANCEOF)) == null) {
                return;
            }
            Editor editor = PsiEditorUtil.findEditor((PsiElement)memberReference);
            if (editor == null) {
                return;
            }
            JBPopupFactory.getInstance().createPopupChooserBuilder(PhpPossiblePolymorphicInvocationInspection.getClassesWithAmbiguousPolymorphicDeclaration(memberReference)).setRenderer((ListCellRenderer)((Object)new PhpGotoTargetRendererProvider.PhpNamedElementPsiElementListCellRenderer(false))).setItemChosenCallback(e -> e.navigate(true)).setTitle(PhpBundle.message("classes.without.member", memberReference.getName())).createPopup().showInBestPositionFor(editor);
        }

        public boolean startInWriteAction() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpPossiblePolymorphicInvocationInspection$PhpFindClassesWithoutMemberInHierarchyQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpPossiblePolymorphicInvocationInspection$PhpFindClassesWithoutMemberInHierarchyQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

