/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.ParameterListOwner;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.TernaryExpression;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.refactoring.introduce.PhpIntroduceBaseHandler;
import com.jetbrains.php.refactoring.introduce.introduceVariable.PhpIntroduceVariableHandler;
import gnu.trove.TIntHashSet;
import java.util.function.Supplier;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpPassByRefInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpPassByRefInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpFunctionCall(FunctionReference reference) {
                this.checkCall((ParameterListOwner)reference, () -> (Function)reference.resolve());
            }

            public void visitPhpMethodReference(MethodReference reference) {
                this.checkCall((ParameterListOwner)reference, () -> (Function)reference.resolve());
            }

            public void visitPhpNewExpression(NewExpression expression) {
                this.checkCall((ParameterListOwner)expression, () -> this.resolveNewExpression(expression));
            }

            public void visitPhpAssignmentExpression(AssignmentExpression assignmentExpression) {
                PhpPsiElement value;
                if (PhpWorkaroundUtil.isAssignByReference(assignmentExpression) && (value = assignmentExpression.getValue()) != null && !PhpPassByRefInspection.canBePassByReference((PsiElement)value)) {
                    holder.registerProblem((PsiElement)value, PhpBundle.message("inspection.message.only.variables.can.be.passed.by.reference", new Object[0]), PhpPassByRefInspection.amendExtractVariableFix(PhpRemoveRefFromAssignmentQuickFix.INSTANCE, isOnTheFly));
                }
            }

            public void visitPhpReturn(PhpReturn returnStatement) {
                Function function = (Function)PhpPsiUtil.getParentByCondition((PsiElement)returnStatement, (Condition<? super PsiElement>)Function.INSTANCEOF);
                if (function == null || !function.isReturningByReference()) {
                    return;
                }
                PsiElement argument = returnStatement.getArgument();
                if (argument != null && !PhpPassByRefInspection.canBePassByReference(argument)) {
                    holder.registerProblem(argument, PhpBundle.message("inspection.php.pass.by.ref.description", new Object[0]), PhpPassByRefInspection.amendExtractVariableFix(new PhpRemoveRefFromFunctionDeclarationQuickFix(function.getName()), isOnTheFly));
                }
            }

            @Nullable
            private Method resolveNewExpression(NewExpression expression) {
                ClassReference classReference = expression.getClassReference();
                if (classReference == null) {
                    return null;
                }
                PsiElement resolve = classReference.resolve();
                if (resolve == null) {
                    return null;
                }
                return resolve instanceof Method ? (Method)resolve : (resolve instanceof PhpClass && resolve.isValid() ? ((PhpClass)resolve).getConstructor() : null);
            }

            private void checkCall(@NotNull ParameterListOwner reference, @NotNull Supplier<Function> functionSupplier) {
                String fqn;
                PsiElement[] arguments;
                TIntHashSet cantBePassedByReferenceArguments;
                if (reference == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (functionSupplier == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((cantBePassedByReferenceArguments = PhpPassByRefInspection.collectCantBePassedByReferencesArgumentsIndices(arguments = reference.getParameters())).isEmpty()) {
                    return;
                }
                Function function = functionSupplier.get();
                if (function != null && ((fqn = function.getFQN()).equals("\\array_multisort") || fqn.equals("\\extract"))) {
                    return;
                }
                Parameter[] parameters = function != null ? function.getParameters() : Parameter.EMPTY_ARRAY;
                int length = Math.min(parameters.length, arguments.length);
                for (int i = 0; i < length; ++i) {
                    if (!cantBePassedByReferenceArguments.contains(i) || !parameters[i].isPassByRef()) continue;
                    holder.registerProblem(arguments[i], PhpBundle.message("inspection.message.only.variables.can.be.passed.by.reference", new Object[0]), PhpPassByRefInspection.amendExtractVariableFix(new PhpRemovePassByRefFromParameterQuickFix(parameters[i].getName()), isOnTheFly));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "reference";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "functionSupplier";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/php/lang/inspections/PhpPassByRefInspection$1";
                objectArray[2] = "checkCall";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static LocalQuickFix[] amendExtractVariableFix(LocalQuickFix fix, boolean isOnTheFly) {
        LocalQuickFix[] localQuickFixArray;
        if (isOnTheFly) {
            LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[2];
            localQuickFixArray2[0] = fix;
            localQuickFixArray = localQuickFixArray2;
            localQuickFixArray2[1] = PhpExtractVariableQuickFix.INSTANCE;
        } else {
            LocalQuickFix[] localQuickFixArray3 = new LocalQuickFix[1];
            localQuickFixArray = localQuickFixArray3;
            localQuickFixArray3[0] = fix;
        }
        return localQuickFixArray;
    }

    @NotNull
    private static TIntHashSet collectCantBePassedByReferencesArgumentsIndices(PsiElement[] arguments) {
        TIntHashSet cantBePassedByReferenceArguments = new TIntHashSet(arguments.length);
        for (int i = 0; i < arguments.length; ++i) {
            PsiElement argument = arguments[i];
            if (argument instanceof AssignmentExpression && PhpWorkaroundUtil.isAssignByReference((AssignmentExpression)argument) || PhpPassByRefInspection.canBePassByReference(argument)) continue;
            cantBePassedByReferenceArguments.add(i);
        }
        TIntHashSet tIntHashSet = cantBePassedByReferenceArguments;
        if (tIntHashSet == null) {
            PhpPassByRefInspection.$$$reportNull$$$0(1);
        }
        return tIntHashSet;
    }

    public static boolean canBePassByReference(@Nullable PsiElement parameter) {
        FieldReference reference;
        if (parameter == null || parameter.getTextLength() <= 0) {
            return true;
        }
        if (PhpPsiUtil.isOfType(parameter.getPrevSibling(), PhpTokenTypes.opVARIADIC)) {
            return true;
        }
        if (parameter instanceof UnaryExpression) {
            PsiElement operation = ((UnaryExpression)parameter).getOperation();
            IElementType elementType = PsiUtilCore.getElementType((PsiElement)operation);
            return elementType == PhpTokenTypes.kwCLONE || elementType == PhpTokenTypes.opSILENCE || (elementType == PhpTokenTypes.opDECREMENT || elementType == PhpTokenTypes.opINCREMENT) && operation == parameter.getFirstChild();
        }
        if (parameter instanceof TernaryExpression) {
            TernaryExpression ternaryExpression = (TernaryExpression)parameter;
            PhpPsiElement trueVariant = ternaryExpression.getTrueVariant();
            PhpPsiElement falseVariant = ternaryExpression.getFalseVariant();
            return PhpPassByRefInspection.canBePassByReference((PsiElement)trueVariant) && PhpPassByRefInspection.canBePassByReference((PsiElement)falseVariant);
        }
        if (parameter instanceof MemberReference && ((MemberReference)parameter).hasNullSafeDereference()) {
            return false;
        }
        if (parameter instanceof FieldReference && (!(reference = (FieldReference)parameter).isConstant() || reference.getReferenceType().isDynamic())) {
            return true;
        }
        if (parameter instanceof FunctionReference) {
            Object[] elements = ((FunctionReference)parameter).multiResolve(false);
            if (elements.length == 0) {
                return true;
            }
            return StreamEx.of((Object[])elements).map(ResolveResult::getElement).select(Function.class).anyMatch(Function::isReturningByReference);
        }
        return parameter instanceof Variable || parameter instanceof NewExpression || parameter instanceof ArrayAccessExpression;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpPassByRefInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpPassByRefInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "collectCantBePassedByReferencesArgumentsIndices";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class PhpRemoveRefFromFunctionDeclarationQuickFix
    implements LocalQuickFix {
        private final String myFunctionName;

        private PhpRemoveRefFromFunctionDeclarationQuickFix(String functionName) {
            this.myFunctionName = functionName;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getName() {
            String string = PhpBundle.message("remove.from.function.0.declaration", this.myFunctionName);
            if (string == null) {
                PhpRemoveRefFromFunctionDeclarationQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("php.remove.ref.from.function.declaration.quick.fix.family.name", new Object[0]);
            if (string == null) {
                PhpRemoveRefFromFunctionDeclarationQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            Function function;
            if (project == null) {
                PhpRemoveRefFromFunctionDeclarationQuickFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                PhpRemoveRefFromFunctionDeclarationQuickFix.$$$reportNull$$$0(3);
            }
            if ((function = (Function)PhpPsiUtil.getParentByCondition(descriptor.getStartElement(), (Condition<? super PsiElement>)Function.INSTANCEOF)) == null) {
                return;
            }
            PsiElement passByRefToken = PhpPsiUtil.getChildOfType((PsiElement)function, PhpTokenTypes.opBIT_AND);
            if (passByRefToken != null) {
                passByRefToken.delete();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpPassByRefInspection$PhpRemoveRefFromFunctionDeclarationQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpPassByRefInspection$PhpRemoveRefFromFunctionDeclarationQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PhpRemoveRefFromAssignmentQuickFix
    implements LocalQuickFix {
        static final LocalQuickFix INSTANCE = new PhpRemoveRefFromAssignmentQuickFix();

        private PhpRemoveRefFromAssignmentQuickFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("php.remove.ref.from.assignment.quick.fix.family.name", new Object[0]);
            if (string == null) {
                PhpRemoveRefFromAssignmentQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            AssignmentExpression assignmentExpression;
            PsiElement refAssignment;
            if (project == null) {
                PhpRemoveRefFromAssignmentQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                PhpRemoveRefFromAssignmentQuickFix.$$$reportNull$$$0(2);
            }
            PsiElement psiElement = refAssignment = (assignmentExpression = (AssignmentExpression)PhpPsiUtil.getParentByCondition(descriptor.getStartElement(), (Condition<? super PsiElement>)AssignmentExpression.INSTANCEOF)) != null ? PhpPsiUtil.getChildOfType((PsiElement)assignmentExpression, PhpTokenTypes.tsASGN_OPS) : null;
            if (refAssignment != null) {
                PsiElement assignToken = PhpPsiUtil.getChildOfType((PsiElement)PhpPsiElementFactory.createStatement(project, "$a = $b").getFirstPsiChild(), PhpTokenTypes.opASGN);
                assert (assignToken != null);
                refAssignment.replace(assignToken);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpPassByRefInspection$PhpRemoveRefFromAssignmentQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpPassByRefInspection$PhpRemoveRefFromAssignmentQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PhpExtractVariableQuickFix
    implements LocalQuickFix {
        private static final LocalQuickFix INSTANCE = new PhpExtractVariableQuickFix();

        private PhpExtractVariableQuickFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = RefactoringBundle.message((String)"introduce.variable.title");
            if (string == null) {
                PhpExtractVariableQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element;
            Editor editor;
            if (project == null) {
                PhpExtractVariableQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                PhpExtractVariableQuickFix.$$$reportNull$$$0(2);
            }
            if ((editor = PsiEditorUtil.findEditor((PsiElement)(element = descriptor.getStartElement()))) == null) {
                return;
            }
            PhpIntroduceVariableHandler handler = new PhpIntroduceVariableHandler();
            try {
                handler.invoke(handler.getIntroduceContext(editor, element));
            }
            catch (PhpIntroduceBaseHandler.RefactoringErrorException refactoringErrorException) {
                // empty catch block
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpPassByRefInspection$PhpExtractVariableQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpPassByRefInspection$PhpExtractVariableQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class PhpRemovePassByRefFromParameterQuickFix
    implements LocalQuickFix {
        private final String myParameterName;

        private PhpRemovePassByRefFromParameterQuickFix(String parameterName) {
            this.myParameterName = parameterName;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("php.remove.pass.by.ref.from.parameter.quick.fix.family.name", new Object[0]);
            if (string == null) {
                PhpRemovePassByRefFromParameterQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getName() {
            String string = PhpBundle.message("remove.from.the.parameter.0", this.myParameterName);
            if (string == null) {
                PhpRemovePassByRefFromParameterQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement passByRefToken;
            ParameterList parameterList;
            if (project == null) {
                PhpRemovePassByRefFromParameterQuickFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                PhpRemovePassByRefFromParameterQuickFix.$$$reportNull$$$0(3);
            }
            if ((parameterList = (ParameterList)PhpPsiUtil.getParentByCondition(descriptor.getStartElement(), (Condition<? super PsiElement>)ParameterList.INSTANCEOF)) == null) {
                return;
            }
            int index = PhpWorkaroundUtil.getArgumentIndex(descriptor.getStartElement(), parameterList);
            if (index < 0) {
                return;
            }
            FunctionReference reference = (FunctionReference)ObjectUtils.tryCast((Object)parameterList.getParent(), FunctionReference.class);
            if (reference == null) {
                return;
            }
            Function function = (Function)ObjectUtils.tryCast((Object)reference.resolve(), Function.class);
            if (function == null) {
                return;
            }
            Parameter parameter = function.getParameter(index);
            PsiElement psiElement = passByRefToken = parameter != null ? PhpPsiUtil.getChildOfType((PsiElement)parameter, PhpTokenTypes.opBIT_AND) : null;
            if (passByRefToken != null) {
                passByRefToken.delete();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpPassByRefInspection$PhpRemovePassByRefFromParameterQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpPassByRefInspection$PhpRemovePassByRefFromParameterQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

