/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.PhpReplaceNestedTernaryExpressionWithLeftAssociativeExpressionQuickFix;
import com.jetbrains.php.lang.inspections.PhpReplaceNestedTernaryExpressionWithRightAssociativeExpressionQuickFix;
import com.jetbrains.php.lang.psi.elements.TernaryExpression;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpNestedTernaryExpressionUsageInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpNestedTernaryExpressionUsageInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpTernaryExpression(TernaryExpression expression) {
                TernaryExpression nestedTernaryExpression = (TernaryExpression)ObjectUtils.tryCast((Object)expression.getFalseVariant(), TernaryExpression.class);
                if (nestedTernaryExpression == null || expression.isShort() && nestedTernaryExpression.isShort()) {
                    return;
                }
                PhpReplaceNestedTernaryExpressionWithLeftAssociativeExpressionQuickFix leftAssociativeExpression = new PhpReplaceNestedTernaryExpressionWithLeftAssociativeExpressionQuickFix(expression);
                PhpReplaceNestedTernaryExpressionWithRightAssociativeExpressionQuickFix rightAssociativeExpression = new PhpReplaceNestedTernaryExpressionWithRightAssociativeExpressionQuickFix(expression);
                holder.registerProblem((PsiElement)expression, PhpBundle.message("inspection.nested.ternary.expression", new Object[0]), new LocalQuickFix[]{leftAssociativeExpression, rightAssociativeExpression});
            }
        };
    }

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP740;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/PhpNestedTernaryExpressionUsageInspection", "buildVisitor"));
    }
}

