/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpCustomExitPointRegistry;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpStatementInstruction;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpCase;
import com.jetbrains.php.lang.psi.elements.PhpSwitch;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;

public class PhpMissingBreakStatementInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpMissingBreakStatementInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpSwitch(final PhpSwitch switchStatement) {
                PhpScopeHolder scopeHolder = PhpPsiUtil.getScopeHolder((PsiElement)switchStatement);
                if (scopeHolder == null) {
                    return;
                }
                final TextRange switchStatementTextRange = switchStatement.getTextRange();
                for (final PhpCase aCase : switchStatement.getAllCases()) {
                    PhpStatementInstruction firstStatementInstruction;
                    Statement caseGroupStatement = aCase.getStatement();
                    Statement firstStatement = (Statement)PsiTreeUtil.findChildOfType((PsiElement)caseGroupStatement, Statement.class);
                    if (firstStatement == null || (firstStatementInstruction = PhpControlFlowUtil.getStatementInstruction(PhpCustomExitPointRegistry.getControlFlow(scopeHolder), firstStatement)) == null) continue;
                    PhpControlFlowUtil.processSuccessors((PhpInstruction)firstStatementInstruction, false, new PhpInstructionProcessor(){

                        public boolean processStatementInstruction(PhpStatementInstruction instruction) {
                            Statement curStatement = instruction.getStatement();
                            if (curStatement == switchStatement) {
                                return false;
                            }
                            TextRange curStatementTextRange = curStatement.getTextRange();
                            if (!aCase.getTextRange().contains(curStatementTextRange)) {
                                if (switchStatementTextRange.contains(curStatementTextRange)) {
                                    holder.registerProblem(aCase.getFirstChild(), PhpMissingBreakStatementInspection.getProblemDescription(), new LocalQuickFix[]{PhpAddBreakStatementQuickFix.INSTANCE});
                                }
                                return false;
                            }
                            return true;
                        }
                    });
                }
            }
        };
    }

    @InspectionMessage
    public static String getProblemDescription() {
        return PhpBundle.message("inspection.missing.break.statement.problem", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/PhpMissingBreakStatementInspection", "buildVisitor"));
    }

    private static class PhpAddBreakStatementQuickFix
    implements LocalQuickFix {
        static final LocalQuickFix INSTANCE = new PhpAddBreakStatementQuickFix();

        private PhpAddBreakStatementQuickFix() {
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.add.break.as.last.statement", new Object[0]);
            if (string == null) {
                PhpAddBreakStatementQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PhpCase aCase;
            Statement statement;
            if (project == null) {
                PhpAddBreakStatementQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                PhpAddBreakStatementQuickFix.$$$reportNull$$$0(2);
            }
            if ((statement = (aCase = (PhpCase)descriptor.getStartElement().getParent()).getStatement()) == null) {
                return;
            }
            statement.add(PhpPsiElementFactory.createFromText(project, PhpElementTypes.BREAK, "break;"));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpMissingBreakStatementInspection$PhpAddBreakStatementQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpMissingBreakStatementInspection$PhpAddBreakStatementQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

