/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.DynamicBundle;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveResult;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.parameterCountMismatch.PhpChangeFunctionSignatureFromUsageQuickFix;
import com.jetbrains.php.lang.inspections.parameterCountMismatch.PhpFuncGetArgUsageProvider;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpAttribute;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.Collections;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpMethodParametersCountMismatchInspection
extends PhpInspection {
    public boolean DISABLE_FOR__PARAMETER = true;
    public boolean DISABLE_FOR_FUNC_ARG = true;

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpMethodParametersCountMismatchInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpNewExpression(NewExpression expression) {
                ClassReference classReference;
                ClassReference classReference2 = classReference = expression != null ? expression.getClassReference() : null;
                if (classReference == null) {
                    PhpClass anonymousClass;
                    PhpClass phpClass = anonymousClass = expression != null ? (PhpClass)ObjectUtils.tryCast((Object)expression.getFirstPsiChild(), PhpClass.class) : null;
                    if (anonymousClass != null) {
                        this.inspect(expression.getParameterList(), Collections.singleton(anonymousClass));
                    }
                    return;
                }
                this.inspect((PhpReference)expression.getClassReference(), expression.getParameterList());
            }

            public void visitPhpAttribute(PhpAttribute attribute) {
                this.inspect((PhpReference)attribute.getClassReference(), attribute.getParameterList());
            }

            public void visitPhpFunctionCall(FunctionReference reference) {
                this.inspect((PhpReference)reference, reference.getParameterList());
            }

            private void inspect(@Nullable PhpReference reference, @Nullable ParameterList argumentsList) {
                if (reference == null || argumentsList == null) {
                    return;
                }
                this.inspect(argumentsList, ContainerUtil.map((Object[])reference.multiResolve(false), ResolveResult::getElement));
            }

            private void inspect(@Nullable ParameterList argumentsList, Collection<PsiElement> resolvedElements) {
                if (argumentsList != null && !resolvedElements.isEmpty() && ContainerUtil.all(resolvedElements, e -> this.argumentCountMismatch(argumentsList, (PsiElement)e))) {
                    int parametersCount = resolvedElements.stream().mapToInt(e -> e instanceof Function ? ((Function)e).getParameters().length : 0).min().orElse(-1);
                    String message = PhpBundle.message("inspection.method.parameters.count.mismatch", argumentsList.getParameters().length, parametersCount);
                    holder.registerProblem(PhpChangeFunctionSignatureFromUsageQuickFix.getDescriptor((PsiElement)argumentsList, message, isOnTheFly));
                }
            }

            private boolean argumentCountMismatch(@NotNull ParameterList argumentsList, @Nullable PsiElement element) {
                if (argumentsList == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (element instanceof PhpClass) {
                    return this.argumentCountMismatch(argumentsList, (Function)((PhpClass)element).getConstructor());
                }
                if (element instanceof Function) {
                    return this.argumentCountMismatch(argumentsList, (Function)element);
                }
                return false;
            }

            private boolean argumentCountMismatch(@NotNull ParameterList argumentsList, @Nullable Function function) {
                Parameter[] parameters;
                int numberOfParametersInDeclaration;
                int numberOfParametersInCall;
                if (argumentsList == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((numberOfParametersInCall = argumentsList.getParameters().length) <= (numberOfParametersInDeclaration = (parameters = function != null ? function.getParameters() : Parameter.EMPTY_ARRAY).length)) {
                    return false;
                }
                if (numberOfParametersInDeclaration > 0) {
                    if (PhpMethodParametersCountMismatchInspection.this.DISABLE_FOR__PARAMETER && parameters[numberOfParametersInDeclaration - 1].getName().equals("_")) {
                        return false;
                    }
                    if (parameters[numberOfParametersInDeclaration - 1].isVariadic()) {
                        return false;
                    }
                }
                return !PhpMethodParametersCountMismatchInspection.this.DISABLE_FOR_FUNC_ARG || function == null || !PhpFuncGetArgUsageProvider.containsGetArgFunctionUsage(function);
            }

            public void visitPhpMethodReference(MethodReference reference) {
                this.visitPhpFunctionCall((FunctionReference)reference);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentsList", "com/jetbrains/php/lang/inspections/PhpMethodParametersCountMismatchInspection$1", "argumentCountMismatch"));
            }
        };
    }

    @Override
    public JComponent createOptionsPanel() {
        return new OptionsPanel().getComponent();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/PhpMethodParametersCountMismatchInspection", "buildVisitor"));
    }

    public class OptionsPanel {
        private JBCheckBox myDisableForLastParameter;
        private JPanel myPanel;
        private JBCheckBox myDisableForForFunctionContainingFuncNumCall;

        public OptionsPanel() {
            this.$$$setupUI$$$();
            this.myDisableForForFunctionContainingFuncNumCall.setSelected(PhpMethodParametersCountMismatchInspection.this.DISABLE_FOR_FUNC_ARG);
            this.myDisableForForFunctionContainingFuncNumCall.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PhpMethodParametersCountMismatchInspection.this.DISABLE_FOR_FUNC_ARG = OptionsPanel.this.myDisableForForFunctionContainingFuncNumCall.isSelected();
                }
            });
            this.myDisableForLastParameter.setSelected(PhpMethodParametersCountMismatchInspection.this.DISABLE_FOR__PARAMETER);
            this.myDisableForLastParameter.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PhpMethodParametersCountMismatchInspection.this.DISABLE_FOR__PARAMETER = OptionsPanel.this.myDisableForLastParameter.isSelected();
                }
            });
        }

        public JPanel getComponent() {
            return this.myPanel;
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JBCheckBox jBCheckBox;
            JBCheckBox jBCheckBox2;
            JPanel jPanel;
            this.myPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
            this.myDisableForLastParameter = jBCheckBox2 = new JBCheckBox();
            this.$$$loadButtonText$$$((AbstractButton)jBCheckBox2, DynamicBundle.getBundle((String)"messages/PhpBundle", OptionsPanel.class).getString("inspection.method.parameters.count.mismatch.option.ignore.underscore"));
            jPanel.add((Component)jBCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myDisableForForFunctionContainingFuncNumCall = jBCheckBox = new JBCheckBox();
            this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/PhpBundle", OptionsPanel.class).getString("inspection.method.parameters.count.mismatch.option.ignore.func.get.arg"));
            jPanel.add((Component)jBCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myPanel;
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }
}

