/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.composer.ComposerDataService;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.config.PhpLanguageFeatureUsagesTracker;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.config.PhpProjectConfigurable;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.annotator.PhpDeleteElementQuickFix;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.PhpInspectionsUtil;
import com.jetbrains.php.lang.inspections.PhpLanguageFeatureUsageVisitor;
import com.jetbrains.php.lang.inspections.PhpRemoveNumericLiteralsSeparatorsQuickFix;
import com.jetbrains.php.lang.inspections.PhpReplacePromotedFieldWithTraditionalQuickFix;
import com.jetbrains.php.lang.inspections.PhpReplaceWithTernaryExpressionQuickFix;
import com.jetbrains.php.lang.inspections.PhpSwitchComposerLanguageLevelQuickFix;
import com.jetbrains.php.lang.inspections.controlFlow.PhpSideEffectDetector;
import com.jetbrains.php.lang.inspections.quickfix.PhpIntroduceCatchVariableQuickFix;
import com.jetbrains.php.lang.inspections.quickfix.PhpSwitchLanguageLevelQuickFix;
import com.jetbrains.php.lang.intentions.PhpConvertShortArrowFunctionToClosureIntention;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.ArrayIndex;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.Catch;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpModifierList;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpNamespaceReference;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpSwitch;
import com.jetbrains.php.lang.psi.elements.PhpTypeDeclaration;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.PhpUseImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpLanguageLevelInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpLanguageLevelInspection.$$$reportNull$$$0(0);
        }
        return new PhpLanguageFeatureUsageVisitor(){
            private final EnumSet<PhpLanguageFeature> myUsedFeatures;
            private final PhpLanguageLevel myCurrentLevel;
            private final boolean syncWithComposer;
            {
                this.myUsedFeatures = PhpLanguageFeatureUsagesTracker.getInstance().getUsedFeatures(holder.getProject());
                this.myCurrentLevel = PhpProjectConfigurationFacade.getInstance(holder.getProject()).getLanguageLevel();
                this.syncWithComposer = ComposerDataService.getInstance(holder.getProject()).syncLanguageLevel();
            }

            @Override
            protected void checkPhp7TypeHints(CharSequence name, @NotNull PsiElement psi) {
                boolean falseOrNull;
                if (psi == null) {
                    1.$$$reportNull$$$0(0);
                }
                boolean bl = falseOrNull = PhpLangUtil.equalsClassNames(name, "false") || PhpLangUtil.equalsClassNames(name, "null");
                if (PhpLanguageFeature.UNION_TYPES.isSupported(psi.getProject()) && falseOrNull) {
                    return;
                }
                if (this.myCurrentLevel.isAtLeast(PhpLanguageLevel.PHP700) && (PhpLangUtil.equalsClassNames(name, "true") || falseOrNull)) {
                    holder.registerProblem(psi, PhpBundle.message("type.primitive.hints.names.are.forbidden", new Object[0]), new LocalQuickFix[0]);
                }
            }

            @Override
            public void visitPhpClass(PhpClass clazz) {
                super.visitPhpClass(clazz);
                CharSequence name = clazz.getNameCS();
                ASTNode node = clazz.getNameNode();
                PsiElement psi = node != null ? node.getPsi() : null;
                this.checkPhp7ClassName(name, psi);
                this.checkPhp71ClassName(name, psi);
                this.checkPhp72ClassName(name, psi);
            }

            @Override
            public void visitPhpMethod(Method method) {
                PsiElement abstractKeyword;
                super.visitPhpMethod(method);
                this.visitPhpFunction((Function)method);
                PhpModifierList modifiers = (PhpModifierList)PhpPsiUtil.getChildByCondition((PsiElement)method, (Condition<? super PsiElement>)PhpModifierList.INSTANCEOF);
                if (modifiers != null && (abstractKeyword = PhpPsiUtil.getChildOfType((PsiElement)modifiers, PhpTokenTypes.kwABSTRACT)) != null) {
                    PhpClassHierarchyUtils.processSuperMethods((Method)method, (superMethod, subClass, baseClass) -> {
                        PhpClass superContainingClass = superMethod.getContainingClass();
                        if (superMethod.isAbstract() && superContainingClass != null && !superContainingClass.isInterface() && !superContainingClass.isTrait()) {
                            this.checkFeature(PhpLanguageFeature.ABSTRACT_FUNCTION_OVERRIDE, abstractKeyword);
                        }
                        return false;
                    });
                }
            }

            @Override
            protected boolean isString(PhpType type) {
                return super.isString(type.global(holder.getProject()));
            }

            @Override
            public void visitPhpUse(PhpUse expression) {
                super.visitPhpUse(expression);
                String name = expression.getAliasName();
                PsiElement psi = expression.getLastChild();
                if (!PhpUseImpl.isOfFunction(expression) && !PhpUseImpl.isOfConst(expression)) {
                    this.checkPhp7ClassName(name, psi);
                    this.checkPhp71ClassName(name, psi);
                    this.checkPhp72ClassName(name, psi);
                }
            }

            public void visitPhpElement(PhpPsiElement element) {
                super.visitPhpElement(element);
                if (!PhpLanguageFeature.NAMESPACED_NAME_AS_SINGLE_TOKEN.isSupported(holder.getProject())) {
                    return;
                }
                ASTNode nameNode = PhpLanguageLevelInspection.getNameNode((PsiElement)element);
                if (nameNode == null) {
                    return;
                }
                PsiElement nameIdentifier = nameNode.getPsi();
                PsiElement namespaceReference = PhpPsiUtil.getPrevSiblingIgnoreWhitespace(nameIdentifier, true);
                if (namespaceReference instanceof PhpNamespaceReference) {
                    if (PhpPsiUtil.getPrevSibling(nameIdentifier, new Condition[0]) instanceof PsiWhiteSpace) {
                        holder.registerProblem((PsiElement)element, TextRange.create((int)namespaceReference.getTextRangeInParent().getStartOffset(), (int)nameIdentifier.getTextRangeInParent().getEndOffset()), PhpBundle.message("inspection.message.qualified.name.can.t.contain.whitespaces", new Object[0]), new LocalQuickFix[]{PhpRemoveWhiteSpacesQuickFix.INSTANCE});
                    } else if (PsiTreeUtil.getChildOfType((PsiElement)namespaceReference, PsiWhiteSpace.class) != null) {
                        holder.registerProblem(namespaceReference, PhpBundle.message("inspection.message.qualified.name.can.t.contain.whitespaces", new Object[0]), new LocalQuickFix[]{PhpRemoveWhiteSpacesQuickFix.INSTANCE});
                    }
                }
            }

            @Override
            protected void checkKeywordInFQN(PsiElement child, IElementType type) {
                if (type == PhpTokenTypes.kwFN && this.myCurrentLevel.equals((Object)PhpLanguageLevel.PHP740)) {
                    holder.registerProblem(child, PhpBundle.message("inspection.php.language.level.description", new Object[0]), new LocalQuickFix[0]);
                } else {
                    super.checkKeywordInFQN(child, type);
                }
            }

            private void checkPhp7ClassName(CharSequence name, PsiElement psi) {
                if (psi != null && this.myCurrentLevel.isAtLeast(PhpLanguageLevel.PHP700) && (PhpLangUtil.equalsClassNames(name, "int") || PhpLangUtil.equalsClassNames(name, "string") || PhpLangUtil.equalsClassNames(name, "float") || PhpLangUtil.equalsClassNames(name, "bool") || PhpLangUtil.equalsClassNames(name, "true") || PhpLangUtil.equalsClassNames(name, "false") || PhpLangUtil.equalsClassNames(name, "null"))) {
                    holder.registerProblem(psi, PhpBundle.message("primitive.hints.name.are.forbidden.in.php.7", new Object[0]), new LocalQuickFix[0]);
                }
            }

            private void checkPhp71ClassName(CharSequence name, PsiElement psi) {
                if (psi != null && this.myCurrentLevel.isAtLeast(PhpLanguageLevel.PHP710) && (PhpLangUtil.equalsClassNames(name, "void") || PhpLangUtil.equalsClassNames(name, "iterable"))) {
                    holder.registerProblem(psi, PhpBundle.message("classes.named.void.and.iterable.are.forbidden.in.php.7.1", new Object[0]), new LocalQuickFix[0]);
                }
            }

            private void checkPhp72ClassName(CharSequence name, PsiElement psi) {
                if (psi != null && this.myCurrentLevel.isAtLeast(PhpLanguageLevel.PHP720) && PhpLangUtil.equalsClassNames(name, "object")) {
                    holder.registerProblem(psi, PhpBundle.message("classes.named.object.are.forbidden.in.php.7.2", new Object[0]), new LocalQuickFix[0]);
                }
            }

            public void visitPhpSwitch(PhpSwitch switchStatement) {
                if (this.myCurrentLevel.isAtLeast(PhpLanguageLevel.PHP700)) {
                    int defaults = 0;
                    for (PsiElement child = switchStatement.getLastChild(); child != null; child = child.getPrevSibling()) {
                        if (!PhpPsiUtil.isOfType(child, PhpElementTypes.CASE_DEFAULT) || defaults++ <= 0) continue;
                        holder.registerProblem(child, PhpBundle.message("switch.statements.may.only.contain.one.default.clause.in.php.7", new Object[0]), new LocalQuickFix[0]);
                    }
                }
            }

            @Override
            public void visitPhpArrayAccessExpression(ArrayAccessExpression expression) {
                super.visitPhpArrayAccessExpression(expression);
                if (!PhpLanguageLevel.current(expression.getProject()).isAtLeast(PhpLanguageLevel.PHP800)) {
                    PhpPsiElement indexValue;
                    PhpPsiElement value = expression.getValue();
                    ArrayIndex index = expression.getIndex();
                    PhpPsiElement phpPsiElement = indexValue = index != null ? index.getValue() : null;
                    if (indexValue != null) {
                        if (PhpLanguageLevelInspection.isInterpolatedString(value)) {
                            holder.registerProblem((PsiElement)indexValue, PhpBundle.message("inspection.message.interpolated.string.dereferencing.available.in.php.only", new Object[0]), this.getFixes(PhpLanguageLevel.PHP800, new LocalQuickFix[0]));
                        } else if (PhpLanguageLevelInspection.isMagicConstant(value)) {
                            holder.registerProblem((PsiElement)indexValue, PhpBundle.message("inspection.message.magic.constant.dereferencing.available.in.php.only", new Object[0]), this.getFixes(PhpLanguageLevel.PHP800, new LocalQuickFix[0]));
                        }
                    }
                }
            }

            @Override
            protected void checkFeature(@NotNull PhpLanguageFeature languageFeature, @Nls @NotNull String errorMessage, @NotNull PsiElement psiElement, @Nullable TextRange rangeInElement) {
                if (languageFeature == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (errorMessage == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (psiElement == null) {
                    1.$$$reportNull$$$0(3);
                }
                this.myUsedFeatures.add(languageFeature);
                PhpLanguageLevel preferableLanguageLevel = this.myCurrentLevel;
                if (!preferableLanguageLevel.hasFeature(languageFeature)) {
                    for (PhpLanguageLevel level : PhpLanguageLevel.values()) {
                        if (!level.hasFeature(languageFeature)) continue;
                        preferableLanguageLevel = level;
                        break;
                    }
                    ProblemHighlightType severity = languageFeature == PhpLanguageFeature.ATTRIBUTES ? ProblemHighlightType.WEAK_WARNING : ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
                    holder.registerProblem(psiElement, errorMessage, severity, rangeInElement, this.getFixes(preferableLanguageLevel, this.getAdditionalFixes(psiElement, languageFeature)));
                }
            }

            private LocalQuickFix[] getFixes(PhpLanguageLevel preferableLanguageLevel, LocalQuickFix ... additionalFixes) {
                LocalQuickFix quickFix = PhpLanguageLevelInspection.getSwitchLanguageLevelQuickFix(holder.getProject(), preferableLanguageLevel, this.syncWithComposer, isOnTheFly);
                return this.getFixes(quickFix, additionalFixes);
            }

            private LocalQuickFix[] getAdditionalFixes(@NotNull PsiElement psiElement, @NotNull PhpLanguageFeature languageFeature) {
                LocalQuickFix[] localQuickFixArray;
                if (psiElement == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (languageFeature == null) {
                    1.$$$reportNull$$$0(5);
                }
                Object additionalFix = null;
                if (PhpLanguageFeature.NUMERIC_LITERALS_SEPARATORS == languageFeature) {
                    additionalFix = PhpRemoveNumericLiteralsSeparatorsQuickFix.INSTANCE;
                } else if (PhpLanguageFeature.NULLSAFE_DEREFERENCING == languageFeature) {
                    additionalFix = PhpRemoveQuestQuickFix.INSTANCE;
                } else if (PhpLanguageFeature.CLASS_NAME_LITERAL_ON_OBJECT == languageFeature) {
                    additionalFix = PhpReplaceWithGetClassQuickFix.INSTANCE;
                } else if (PhpLanguageFeature.PROPERTY_PROMOTION == languageFeature) {
                    additionalFix = new PhpReplacePromotedFieldWithTraditionalQuickFix((Parameter)psiElement);
                } else if (PhpLanguageFeature.RETURN_VOID == languageFeature || PhpLanguageFeature.CLASS_CONSTANT_VISIBILITY == languageFeature) {
                    additionalFix = new PhpDeleteElementQuickFix(psiElement);
                } else if (PhpLanguageFeature.NULLABLES == languageFeature) {
                    PsiElement opQuest;
                    PhpTypeDeclaration typeDeclaration = (PhpTypeDeclaration)PhpPsiUtil.getParentByCondition(psiElement, false, (Condition<? super PsiElement>)((Condition)PhpTypeDeclaration.class::isInstance));
                    PsiElement psiElement2 = opQuest = typeDeclaration != null ? PhpPsiUtil.getChildOfType((PsiElement)typeDeclaration, PhpTokenTypes.opQUEST) : null;
                    if (opQuest != null) {
                        additionalFix = new PhpDeleteElementQuickFix(opQuest);
                    }
                } else if (PhpLanguageFeature.CATCH_MULTIPLE == languageFeature) {
                    additionalFix = PhpSplitIntoMultipleCatchesQuickFix.INSTANCE;
                } else if (PhpLanguageFeature.ARROW_FUNCTION_SYNTAX == languageFeature) {
                    additionalFix = PhpConvertShortArrowFunctionToClosureQuickFix.INSTANCE;
                } else if (PhpLanguageFeature.STATIC_RETURN_TYPE_HINT == languageFeature) {
                    PhpClass phpClass = (PhpClass)PhpPsiUtil.getParentByCondition(psiElement, true, (Condition<? super PsiElement>)PhpClass.INSTANCEOF);
                    if (phpClass != null) {
                        additionalFix = new PhpReplaceWithCurrentClassQuickFix(phpClass.getName());
                    }
                } else if (PhpLanguageFeature.NON_CAPTURING_CATCHES == languageFeature) {
                    additionalFix = PhpIntroduceCatchVariableQuickFix.INSTANCE;
                } else if (PhpLanguageFeature.COALESCE_OPERATOR == languageFeature) {
                    BinaryExpression binaryExpression = (BinaryExpression)PhpPsiUtil.getParentByCondition(psiElement, false, (Condition<? super PsiElement>)((Condition)BinaryExpression.class::isInstance));
                    if (binaryExpression != null && !PhpSideEffectDetector.canContainSideEffect((PsiElement)binaryExpression)) {
                        additionalFix = PhpReplaceWithTernaryExpressionQuickFix.INSTANCE;
                    }
                }
                if (additionalFix != null) {
                    LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                    localQuickFixArray = localQuickFixArray2;
                    localQuickFixArray2[0] = additionalFix;
                } else {
                    localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
                }
                return localQuickFixArray;
            }

            private LocalQuickFix @NotNull [] getFixes(@Nullable LocalQuickFix quickFix, LocalQuickFix @NotNull [] additionalFixes) {
                if (additionalFixes == null) {
                    1.$$$reportNull$$$0(6);
                }
                if (quickFix == null) {
                    if (additionalFixes == null) {
                        1.$$$reportNull$$$0(7);
                    }
                    return additionalFixes;
                }
                if (additionalFixes.length == 0) {
                    LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{quickFix};
                    if (localQuickFixArray == null) {
                        1.$$$reportNull$$$0(8);
                    }
                    return localQuickFixArray;
                }
                LocalQuickFix[] localQuickFixArray = (LocalQuickFix[])ArrayUtil.prepend((Object)quickFix, (Object[])additionalFixes);
                if (localQuickFixArray == null) {
                    1.$$$reportNull$$$0(9);
                }
                return localQuickFixArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 7: 
                    case 8: 
                    case 9: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 7: 
                    case 8: 
                    case 9: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "psi";
                        break;
                    }
                    case 1: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "languageFeature";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "errorMessage";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "psiElement";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "additionalFixes";
                        break;
                    }
                    case 7: 
                    case 8: 
                    case 9: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpLanguageLevelInspection$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpLanguageLevelInspection$1";
                        break;
                    }
                    case 7: 
                    case 8: 
                    case 9: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFixes";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "checkPhp7TypeHints";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "checkFeature";
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "getAdditionalFixes";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray;
                        objectArray[2] = "getFixes";
                        break;
                    }
                    case 7: 
                    case 8: 
                    case 9: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 7: 
                    case 8: 
                    case 9: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    private static boolean isMagicConstant(PhpPsiElement value) {
        return value instanceof ConstantReference && PhpLangUtil.MAGIC_CONSTANT_NAMES.contains(value.getName());
    }

    private static boolean isInterpolatedString(PhpPsiElement value) {
        return value instanceof StringLiteralExpression && !((StringLiteralExpression)value).isSingleQuote() && PhpPsiUtil.getChildByCondition((PsiElement)value, (Condition<? super PsiElement>)Variable.INSTANCEOF) != null;
    }

    @Nullable
    private static ASTNode getNameNode(@Nullable PsiElement element) {
        return element instanceof PhpNamedElement ? ((PhpNamedElement)element).getNameNode() : (element instanceof PhpReference ? ((PhpReference)element).getNameNode() : null);
    }

    @Nullable
    public static LocalQuickFix getSwitchLanguageLevelQuickFix(Project project, PhpLanguageLevel preferableLanguageLevel, boolean syncWithComposer, boolean isOnTheFly) {
        if (!syncWithComposer) {
            return PhpSwitchLanguageLevelQuickFix.getInstance(preferableLanguageLevel);
        }
        return PhpSwitchComposerLanguageLevelQuickFix.getInstance(project, preferableLanguageLevel, isOnTheFly);
    }

    @Override
    @Nullable
    public JComponent createOptionsPanel() {
        return PhpInspectionsUtil.createPanelWithSettingsLink(PhpBundle.message("link.label.languages.frameworks.php", new Object[0]), PhpProjectConfigurable.class, PhpProjectConfigurable::new);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/PhpLanguageLevelInspection", "buildVisitor"));
    }

    private static class PhpReplaceWithCurrentClassQuickFix
    implements LocalQuickFix {
        private final String myClassName;

        private PhpReplaceWithCurrentClassQuickFix(@NotNull @NlsSafe String className) {
            if (className == null) {
                PhpReplaceWithCurrentClassQuickFix.$$$reportNull$$$0(0);
            }
            this.myClassName = className;
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("php.replace.with", this.myClassName);
            if (string == null) {
                PhpReplaceWithCurrentClassQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                PhpReplaceWithCurrentClassQuickFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                PhpReplaceWithCurrentClassQuickFix.$$$reportNull$$$0(3);
            }
            descriptor.getStartElement().replace((PsiElement)PhpPsiElementFactory.createClassReference(project, this.myClassName));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "className";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpLanguageLevelInspection$PhpReplaceWithCurrentClassQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpLanguageLevelInspection$PhpReplaceWithCurrentClassQuickFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PhpConvertShortArrowFunctionToClosureQuickFix
    implements LocalQuickFix {
        static final LocalQuickFix INSTANCE = new PhpConvertShortArrowFunctionToClosureQuickFix();

        private PhpConvertShortArrowFunctionToClosureQuickFix() {
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("convert.the.arrow.function.to.a.traditional.closure", new Object[0]);
            if (string == null) {
                PhpConvertShortArrowFunctionToClosureQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                PhpConvertShortArrowFunctionToClosureQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                PhpConvertShortArrowFunctionToClosureQuickFix.$$$reportNull$$$0(2);
            }
            PhpConvertShortArrowFunctionToClosureIntention.convertArrowFunctionToClosure(project, (Function)PhpPsiUtil.getParentByCondition(descriptor.getStartElement(), false, (Condition<? super PsiElement>)Function.INSTANCEOF));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpLanguageLevelInspection$PhpConvertShortArrowFunctionToClosureQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpLanguageLevelInspection$PhpConvertShortArrowFunctionToClosureQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PhpSplitIntoMultipleCatchesQuickFix
    implements LocalQuickFix {
        static final LocalQuickFix INSTANCE = new PhpSplitIntoMultipleCatchesQuickFix();

        private PhpSplitIntoMultipleCatchesQuickFix() {
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.split.into.multiple.catch.statements", new Object[0]);
            if (string == null) {
                PhpSplitIntoMultipleCatchesQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            Catch phpCatch;
            if (project == null) {
                PhpSplitIntoMultipleCatchesQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                PhpSplitIntoMultipleCatchesQuickFix.$$$reportNull$$$0(2);
            }
            if ((phpCatch = (Catch)PhpPsiUtil.getParentByCondition(descriptor.getStartElement(), false, (Condition<? super PsiElement>)Catch.INSTANCEOF)) == null) {
                return;
            }
            ClassReference exceptionTypeToKeep = (ClassReference)ContainerUtil.getFirstItem((Collection)phpCatch.getExceptionTypes());
            Collection<Catch> catchesToAdd = PhpSplitIntoMultipleCatchesQuickFix.createCatchesToAdd(exceptionTypeToKeep, phpCatch);
            Catch anchorToAddAfter = phpCatch;
            for (Catch catchToAdd : catchesToAdd) {
                anchorToAddAfter = phpCatch.getParent().addAfter((PsiElement)catchToAdd, (PsiElement)anchorToAddAfter);
            }
            PhpSplitIntoMultipleCatchesQuickFix.removeAllCatchTypesExceptChosen(exceptionTypeToKeep, phpCatch);
        }

        private static Collection<Catch> createCatchesToAdd(ClassReference exceptionTypeToKeep, Catch phpCatch) {
            return phpCatch.getExceptionTypes().stream().filter(e -> exceptionTypeToKeep != e).map(e -> {
                Catch catchCopy = (Catch)phpCatch.copy();
                PhpSplitIntoMultipleCatchesQuickFix.removeAllCatchTypesExceptChosen(e, catchCopy);
                return catchCopy;
            }).collect(Collectors.toList());
        }

        private static void removeAllCatchTypesExceptChosen(ClassReference chosenExceptionType, Catch phpCatch) {
            PsiElement copy = chosenExceptionType.copy();
            Collection types = phpCatch.getExceptionTypes();
            phpCatch.deleteChildRange((PsiElement)ContainerUtil.getFirstItem((Collection)types), (PsiElement)ContainerUtil.iterateAndGetLastItem((Iterable)types));
            PsiElement lParen = PhpPsiUtil.getChildOfType((PsiElement)phpCatch, PhpTokenTypes.chLPAREN);
            phpCatch.addAfter(copy, lParen);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpLanguageLevelInspection$PhpSplitIntoMultipleCatchesQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpLanguageLevelInspection$PhpSplitIntoMultipleCatchesQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PhpReplaceWithGetClassQuickFix
    implements LocalQuickFix {
        static final LocalQuickFix INSTANCE = new PhpReplaceWithGetClassQuickFix();

        private PhpReplaceWithGetClassQuickFix() {
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.replace.with.get.class.call", new Object[0]);
            if (string == null) {
                PhpReplaceWithGetClassQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                PhpReplaceWithGetClassQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                PhpReplaceWithGetClassQuickFix.$$$reportNull$$$0(2);
            }
            PsiElement parent = descriptor.getStartElement().getParent();
            String argumentText = parent.getFirstChild().getText();
            FunctionReference getClassCall = PhpPsiElementFactory.createFromText(project, FunctionReference.class, "get_class(" + argumentText + ")");
            assert (getClassCall != null);
            parent.replace((PsiElement)getClassCall);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpLanguageLevelInspection$PhpReplaceWithGetClassQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpLanguageLevelInspection$PhpReplaceWithGetClassQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PhpRemoveQuestQuickFix
    implements LocalQuickFix {
        static final LocalQuickFix INSTANCE = new PhpRemoveQuestQuickFix();

        private PhpRemoveQuestQuickFix() {
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("annotator.fix.remove", "?");
            if (string == null) {
                PhpRemoveQuestQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                PhpRemoveQuestQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                PhpRemoveQuestQuickFix.$$$reportNull$$$0(2);
            }
            descriptor.getStartElement().delete();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpLanguageLevelInspection$PhpRemoveQuestQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpLanguageLevelInspection$PhpRemoveQuestQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PhpRemoveWhiteSpacesQuickFix
    implements LocalQuickFix {
        static final LocalQuickFix INSTANCE = new PhpRemoveWhiteSpacesQuickFix();

        private PhpRemoveWhiteSpacesQuickFix() {
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.collapse.whitespaces", new Object[0]);
            if (string == null) {
                PhpRemoveWhiteSpacesQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PhpNamespaceReference namespaceReference;
            if (project == null) {
                PhpRemoveWhiteSpacesQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                PhpRemoveWhiteSpacesQuickFix.$$$reportNull$$$0(2);
            }
            if ((namespaceReference = (PhpNamespaceReference)ObjectUtils.tryCast((Object)descriptor.getStartElement(), PhpNamespaceReference.class)) != null) {
                PhpRemoveWhiteSpacesQuickFix.removeWhitespaces(namespaceReference);
                return;
            }
            ASTNode nameNode = PhpLanguageLevelInspection.getNameNode(descriptor.getStartElement());
            if (nameNode == null) {
                return;
            }
            PhpNamespaceReference prevNamespaceReference = (PhpNamespaceReference)ObjectUtils.tryCast((Object)PhpPsiUtil.getPrevSiblingIgnoreWhitespace(nameNode.getPsi(), true), PhpNamespaceReference.class);
            if (prevNamespaceReference == null) {
                return;
            }
            PhpRemoveWhiteSpacesQuickFix.getWhitespacesBetweenNamespaceAndNameNode(prevNamespaceReference, nameNode).forEach(PsiElement::delete);
            PhpRemoveWhiteSpacesQuickFix.removeWhitespaces(prevNamespaceReference);
        }

        private static void removeWhitespaces(PhpNamespaceReference namespaceReference) {
            PsiWhiteSpace[] whiteSpaces = (PsiWhiteSpace[])PsiTreeUtil.getChildrenOfType((PsiElement)namespaceReference, PsiWhiteSpace.class);
            if (whiteSpaces != null) {
                for (PsiWhiteSpace space : whiteSpaces) {
                    space.delete();
                }
            }
        }

        @NotNull
        private static Collection<PsiWhiteSpace> getWhitespacesBetweenNamespaceAndNameNode(@NotNull PhpNamespaceReference namespaceReference, ASTNode nameNode) {
            if (namespaceReference == null) {
                PhpRemoveWhiteSpacesQuickFix.$$$reportNull$$$0(3);
            }
            if (nameNode == null) {
                List<PsiWhiteSpace> list = Collections.emptyList();
                if (list == null) {
                    PhpRemoveWhiteSpacesQuickFix.$$$reportNull$$$0(4);
                }
                return list;
            }
            ArrayList<PsiWhiteSpace> whitespacesBetweenNamespaceAndNameNode = new ArrayList<PsiWhiteSpace>();
            for (PsiElement possibleWhitespace = nameNode.getPsi(); possibleWhitespace != namespaceReference; possibleWhitespace = possibleWhitespace.getPrevSibling()) {
                if (!(possibleWhitespace instanceof PsiWhiteSpace)) continue;
                whitespacesBetweenNamespaceAndNameNode.add((PsiWhiteSpace)possibleWhitespace);
            }
            ArrayList<PsiWhiteSpace> arrayList = whitespacesBetweenNamespaceAndNameNode;
            if (arrayList == null) {
                PhpRemoveWhiteSpacesQuickFix.$$$reportNull$$$0(5);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpLanguageLevelInspection$PhpRemoveWhiteSpacesQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "namespaceReference";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpLanguageLevelInspection$PhpRemoveWhiteSpacesQuickFix";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getWhitespacesBetweenNamespaceAndNameNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getWhitespacesBetweenNamespaceAndNameNode";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

