/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class PhpInternalEntityUsedInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpInternalEntityUsedInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpMethodReference(MethodReference reference) {
                PhpInternalEntityUsedInspection.check((PhpReference)reference, PhpBundle.message("inspection.message.method.ref.marked.as.internal", new Object[0]), holder);
            }

            public void visitPhpFunctionCall(FunctionReference reference) {
                PhpInternalEntityUsedInspection.check((PhpReference)reference, PhpBundle.message("inspection.message.function.ref.marked.as.internal", new Object[0]), holder);
            }

            public void visitPhpClassReference(ClassReference reference) {
                PhpInternalEntityUsedInspection.check((PhpReference)reference, PhpBundle.message("inspection.message.class.ref.marked.as.internal", new Object[0]), holder);
            }

            public void visitPhpClassConstantReference(ClassConstantReference reference) {
                PhpInternalEntityUsedInspection.check((PhpReference)reference, PhpBundle.message("inspection.message.constant.ref.marked.as.internal", new Object[0]), holder);
            }

            public void visitPhpFieldReference(FieldReference reference) {
                PhpInternalEntityUsedInspection.check((PhpReference)reference, PhpBundle.message("inspection.message.field.ref.marked.as.internal", new Object[0]), holder);
            }

            public void visitPhpConstantReference(ConstantReference reference) {
                PhpInternalEntityUsedInspection.check((PhpReference)reference, PhpBundle.message("inspection.message.constant.ref.marked.as.internal", new Object[0]), holder);
            }
        };
    }

    private static void check(PhpReference reference, @InspectionMessage String desc, ProblemsHolder holder) {
        PsiElement element = reference.resolve();
        if (element instanceof PhpNamedElement) {
            if (!((PhpNamedElement)element).isInternal()) {
                return;
            }
            PsiFile referenceFile = reference.getContainingFile();
            PsiFile resolvedElementFile = element.getContainingFile();
            if (resolvedElementFile.equals(referenceFile)) {
                return;
            }
            ProjectFileIndex index = ProjectRootManager.getInstance((Project)holder.getProject()).getFileIndex();
            VirtualFile referenceVirtualFile = referenceFile.getVirtualFile();
            VirtualFile resolvedVirtualFile = resolvedElementFile.getVirtualFile();
            if (Objects.equals(index.getSourceRootForFile(referenceVirtualFile), index.getSourceRootForFile(resolvedVirtualFile))) {
                return;
            }
            if (index.isInTestSourceContent(referenceVirtualFile) && !index.isInLibrary(resolvedVirtualFile)) {
                return;
            }
            PhpDocComment docComment = ((PhpNamedElement)element).getDocComment();
            if (docComment != null && PhpDocUtil.hasDocTagWithName(docComment, "@internal")) {
                holder.registerProblem((PsiReference)reference, desc, ProblemHighlightType.LIKE_DEPRECATED);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/PhpInternalEntityUsedInspection", "buildVisitor"));
    }
}

