/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.util.ui.JBUI;
import com.jetbrains.php.ui.PhpUiUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpInspectionsUtil {
    public static <T extends Configurable> JPanel createPanelWithSettingsLink(@NotNull @NlsContexts.LinkLabel String linkText, @NotNull Class<T> configurableClass, @NotNull Function<? super Project, ? extends T> configurableConstructor) {
        if (linkText == null) {
            PhpInspectionsUtil.$$$reportNull$$$0(0);
        }
        if (configurableClass == null) {
            PhpInspectionsUtil.$$$reportNull$$$0(1);
        }
        if (configurableConstructor == null) {
            PhpInspectionsUtil.$$$reportNull$$$0(2);
        }
        return PhpInspectionsUtil.createPanelWithSettingsLink(linkText, configurableClass, configurableConstructor, null);
    }

    public static <T extends Configurable> JPanel createPanelWithSettingsLink(@NotNull @NlsContexts.LinkLabel String linkText, final @NotNull Class<T> configurableClass, final @NotNull Function<? super Project, ? extends T> configurableConstructor, final @Nullable Consumer<? super T> consumer) {
        if (linkText == null) {
            PhpInspectionsUtil.$$$reportNull$$$0(3);
        }
        if (configurableClass == null) {
            PhpInspectionsUtil.$$$reportNull$$$0(4);
        }
        if (configurableConstructor == null) {
            PhpInspectionsUtil.$$$reportNull$$$0(5);
        }
        HyperlinkLabel settingsLink = new HyperlinkLabel(linkText);
        settingsLink.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                DataManager.getInstance().getDataContextFromFocusAsync().onSuccess(dataContext -> {
                    Settings settings = (Settings)Settings.KEY.getData(dataContext);
                    if (settings != null) {
                        Configurable configurable = settings.find(configurableClass);
                        settings.select(configurable).doWhenDone(() -> {
                            if (consumer != null) {
                                consumer.accept(configurable);
                            }
                        });
                    } else {
                        Project project = (Project)dataContext.getData(CommonDataKeys.PROJECT);
                        if (project != null) {
                            Configurable configurable = (Configurable)configurableConstructor.apply(project);
                            if (consumer != null) {
                                consumer.accept(configurable);
                            }
                            PhpUiUtil.editConfigurable(project, configurable);
                        }
                    }
                });
            }
        });
        JPanel panel2 = new JPanel();
        panel2.setLayout(new BorderLayout());
        panel2.setBorder((Border)JBUI.Borders.emptyTop((int)5));
        panel2.add((Component)settingsLink, "North");
        return panel2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "linkText";
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "configurableClass";
                break;
            }
            case 2: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[0] = "configurableConstructor";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/php/lang/inspections/PhpInspectionsUtil";
        objectArray[2] = "createPanelWithSettingsLink";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

